// conauto.cpp : Defines the entry point for the console application.
//

// Modified by Herbert!!!!!!!!!!!!!!!!!!
////////////////////////////////////////////////////////////////////////////////

#include <iostream.h>
#include <fstream.h>

#include "stdafx.h"
#include "conauto.h"
#include <atlbase.h>

CComModule _Module;
#include <atlcom.h>
#include <atlimpl.cpp>
#include <atlctl.h>
#include <atlctl.cpp>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



/////////////////////////////////////////////////////////////////////////////
// The one and only application object

CWinApp theApp;

using namespace std;

void Invoke(CComPtr<IDispatch> &Ptr,BSTR pszName,long Typ,DISPPARAMS* disp,VARIANT* pResult)
{
	DISPID dispid;
	Ptr->GetIDsOfNames( IID_NULL,
                      &pszName,
                      1,
                      LOCALE_NEUTRAL,
                      &dispid );

	VariantClear(pResult);
	Ptr->Invoke(dispid, IID_NULL, LOCALE_NEUTRAL, Typ, disp, pResult, NULL, NULL);
}

int _tmain(int argc, TCHAR* argv[], TCHAR* envp[])
{
	int nRetCode = 0;
	HRESULT hr;


	///////   initialize MFC and print and error on failure///////////////////////////////////////

	if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
	{
		// TODO: change error code to suit your needs
		cerr << _T("Fatal Error: MFC initialization failed") << endl;
		nRetCode = 1;
	}

	////////////////////////////////////////////////////////////////////////////////////////////
	
	
	else
	{
		if ( argc < 3 || argc > 4 )
			return 1;

    hr = ::CoInitialize(NULL);
		CComPtr<IDispatch> realexcel;

		HRESULT hr;

		CLSID excel;
		DISPID dispid;
		DISPPARAMS disp;
		disp.cArgs = 0;
		disp.cNamedArgs = 0;
		VARIANT varResult;
	
		hr = CLSIDFromProgID(L"Excel.Application", &excel);

		hr = CoCreateInstance(excel, NULL, CLSCTX_LOCAL_SERVER, IID_IDispatch, (void**)&realexcel);

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

		VARIANTARG* FileParameter = new VARIANTARG[1];
		VARIANTARG* OneParameter = new VARIANTARG[1];

		OneParameter[0].vt = VT_BOOL;
		OneParameter[0].boolVal = VARIANT_TRUE;

		DISPID dispid2 = DISPID_PROPERTYPUT;
		DISPPARAMS disp2 = { OneParameter, &dispid2, 1, 1 };

		Invoke(realexcel,L"Visible",DISPATCH_PROPERTYPUT,&disp2,&varResult);

		if ( argc == 4 ) {
			if ( strcmp(argv[3],"Invisible") == 0 ) {
				OneParameter[0].boolVal = VARIANT_FALSE;
				Invoke(realexcel,L"ScreenUpdating",DISPATCH_PROPERTYPUT,&disp2,&varResult);
			}
		}

		Invoke(realexcel,L"Workbooks",DISPATCH_PROPERTYGET,&disp,&varResult);
		CComPtr<IDispatch> workbooks = varResult.pdispVal;

		VARIANT vt;
		vt.vt = VT_BSTR;
		if ( strcmp(argv[1],"dll") == 0 )
			vt.bstrVal = ::SysAllocString(L"C:\\Temp\\Mappe1.xls");
		else if ( strcmp(argv[1],"vba") == 0 )
			vt.bstrVal = ::SysAllocString(L"C:\\Temp\\auto.xls");

		FileParameter[0].vt = VT_BYREF|VT_VARIANT;
		FileParameter[0].pvarVal = &vt;

		DISPPARAMS filedisp = { FileParameter, NULL, 1, 0 };

		Invoke(workbooks,L"Open",DISPATCH_METHOD,&filedisp,&varResult);
		VariantClear(&vt);
		VariantClear(&varResult);

		if ( strcmp(argv[1],"vba") == 0 ) {
			BSTR pszName = L"Run";
			hr = realexcel->GetIDsOfNames( IID_NULL,
													&pszName,
													1,
													LOCALE_NEUTRAL,
													&dispid );

			clock_t start, finish;
			double duration;
			VARIANTARG* TwoParameters = new VARIANTARG[2];
			TwoParameters[0].vt = VT_I4;
			DISPPARAMS twodisp = { TwoParameters, NULL, 1, 0 };
			TwoParameters[1].vt = VT_BSTR;
			long count = atol(argv[2]);
			start = clock();
			for(long j = 1;j <= count;j++) {
				TwoParameters[0].lVal = j;
				TwoParameters[1].bstrVal = ::SysAllocString(L"Module1.one");
				DISPPARAMS twodisp = { TwoParameters, NULL, 2, 0 };
				hr = realexcel->Invoke(dispid, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_METHOD, &twodisp, &varResult, NULL, NULL);
			}
			finish = clock();
			SysFreeString(TwoParameters[1].bstrVal);
			delete TwoParameters;
			duration = (double)(finish - start) / CLOCKS_PER_SEC;
			printf( "%d\t%2.6f\n", j - 1, duration );
		} else  if ( strcmp(argv[1],"dll") == 0 ) {
			BSTR pszName = L"Run";
			hr = realexcel->GetIDsOfNames( IID_NULL,
													&pszName,
													1,
													LOCALE_NEUTRAL,
													&dispid );

			VARIANTARG* Makro = new VARIANTARG[1];

			Makro[0].vt = VT_BSTR;
			Makro[0].bstrVal = SysAllocString(L"Modul1.LoadDLL");;

			DISPPARAMS MakroDisp = { Makro, NULL, 1, 0 };
			hr = realexcel->Invoke(dispid, IID_NULL, LOCALE_NEUTRAL, DISPATCH_METHOD, &MakroDisp, &varResult, NULL, NULL);
			CComPtr<IDispatch> DLL = varResult.pdispVal;

			SysFreeString(Makro[0].bstrVal);
			pszName = L"One";
			hr = DLL->GetIDsOfNames( IID_NULL,
													&pszName,
													1,
													LOCALE_USER_DEFAULT,
													&dispid );

			clock_t start, finish;
			double duration;
			VARIANTARG* Count = new VARIANTARG[1];
			Count[0].vt = VT_I4;
			DISPPARAMS DispCount = { Count, NULL, 1, 0 };
			long count = atol(argv[2]);
			start = clock();
			for(long j = 1;j <= count;j++) {
				Count[0].lVal = j;
				hr = DLL->Invoke(dispid, IID_NULL, LOCALE_NEUTRAL, DISPATCH_METHOD, &DispCount,NULL,NULL,NULL);
			}
			finish = clock();
			delete Count;
			delete Makro;
			duration = (double)(finish - start) / CLOCKS_PER_SEC;
			printf( "%d\t%2.6f\n", j - 1, duration );
		}

		if ( argc == 4 ) {
			if ( strcmp(argv[3],"Invisible") == 0 ) {
				OneParameter[0].boolVal = VARIANT_TRUE;
				Invoke(realexcel,L"ScreenUpdating",DISPATCH_PROPERTYPUT,&disp2,&varResult);
			}
		}

		delete OneParameter;
		delete FileParameter;
	}
	CoUninitialize();

	return nRetCode;
}


