// SAPATLToolkit.h : Declaration of the CATLTestCtrl

#ifndef __SAPATLTOOLKIT_H_
#define __SAPATLTOOLKIT_H_

class CDispPtr: public CComDispatchDriver
{
public:
	CDispPtr();

	CDispPtr(IDispatch* lp);

	CDispPtr(IUnknown* lp);

	CDispPtr(const CDispPtr &lp);

	HRESULT GetIdOfName(OLECHAR* pName,LCID lcid,DISPID& rDispId);
		
	HRESULT GetPropertyByID(DISPID nDispId, LCID lcid, VARIANT* pVar);
	HRESULT PutPropertyByID(DISPID nDispId, LCID lcid, VARIANT* pVar);

	HRESULT GetIndexedPropertyByID(DISPID nDispId, LCID lcid, DISPPARAMS* pDispParams,VARIANT* pVarResult,UINT* pArgErr);

	HRESULT GetDispPropertyByID(DISPID nDispId, LCID lcid, CDispPtr& rObj);

	HRESULT InvokeMethodByID(DISPID nDispId, LCID lcid, DISPPARAMS* pDispParams,VARIANT* pVarResult,UINT* pArgErr);

	HRESULT GetPropertyByName(OLECHAR* pName, LCID lcid, VARIANT* pVar);
	HRESULT PutPropertyByName(OLECHAR* pName, LCID lcid, VARIANT* pVar);

	HRESULT GetIndexedPropertyByName(OLECHAR* pName,LCID lcid,DISPPARAMS* pDispParams,VARIANT* pVarResult,UINT* pArgErr);

	HRESULT GetDispPropertyByName(OLECHAR* pName, LCID lcid, CDispPtr& rObj);

	HRESULT InvokeMethodByName(OLECHAR* pName,LCID lcid,DISPPARAMS* pDispParams,VARIANT* pVarResult,UINT* pArgErr);

	HRESULT InvokeMethodByName(OLECHAR* pName,LCID lcid,DISPPARAMS* pDispParams,VARIANT* pVarResult,UINT* pArgErr,UINT* pError,CComBSTR& rErrorString);

	IDispatch* operator=(IDispatch* lp);
	IDispatch* operator=(IUnknown* lp);
	CDispPtr& CDispPtr::operator=(CDispPtr& lp);
};


/////////////////////////////////////////////////////////////////////////////
// CComDispParams

class CComDispParams: public DISPPARAMS
{
public:
	CComDispParams(DWORD nArgCount)
	{
		if ( nArgCount > 0 ) {
			rgvarg = new VARIANTARG[nArgCount];
			if ( rgvarg ) {
				for ( DWORD i = 0; i < nArgCount; i++ ) {
					::VariantInit(&rgvarg[i]);
					rgvarg[i].vt = VT_ERROR;
					rgvarg[i].scode = DISP_E_PARAMNOTFOUND;
				};
			};
		}else{
			rgvarg = NULL;
		};
		rgdispidNamedArgs = NULL;
		cArgs = nArgCount;
		cNamedArgs = 0;
	}

	~CComDispParams()
	{
		if ( rgvarg ) delete rgvarg;
	}

	operator void*() const { return rgvarg; }
	bool operator!() const { return (rgvarg == NULL); }

	void SetParam(DWORD nIndex, int nSrc)
	{
		if ( rgvarg && nIndex < cArgs ) {
			::VariantInit(&rgvarg[nIndex]);
			rgvarg[nIndex].vt = VT_I4;
			rgvarg[nIndex].lVal = nSrc;
		};
	}
	void SetParam(DWORD nIndex, BYTE nSrc)
	{
		if ( rgvarg && nIndex < cArgs ) {
			::VariantInit(&rgvarg[nIndex]);
			rgvarg[nIndex].vt = VT_UI1;
			rgvarg[nIndex].bVal = nSrc;
		}
	}
	void SetParam(DWORD nIndex, short nSrc)
	{
		if ( rgvarg && nIndex < cArgs ) {
			::VariantInit(&rgvarg[nIndex]);
			rgvarg[nIndex].vt = VT_I2;
			rgvarg[nIndex].iVal = nSrc;
		}
	}
	void SetParam(DWORD nIndex, long nSrc, VARTYPE vtSrc = VT_I4)
	{
		if ( rgvarg && nIndex < cArgs ) {
			::VariantInit(&rgvarg[nIndex]);
			rgvarg[nIndex].vt = vtSrc;
			if ( vtSrc == VT_BOOL ) {
#pragma warning(disable: 4310) // cast truncates constant value
				rgvarg[nIndex].boolVal = nSrc ? VARIANT_TRUE : VARIANT_FALSE;
#pragma warning(default: 4310) // cast truncates constant value
			}else{
				rgvarg[nIndex].lVal = nSrc;
			};
		}
	}
	void SetParam(DWORD nIndex, float fltSrc)
	{
		if ( rgvarg && nIndex < cArgs ) {
			::VariantInit(&rgvarg[nIndex]);
			rgvarg[nIndex].vt = VT_R4;
			rgvarg[nIndex].fltVal = fltSrc;
		}
	}
	void SetParam(DWORD nIndex, double dblSrc)
	{
		if ( rgvarg && nIndex < cArgs ) {
			::VariantInit(&rgvarg[nIndex]);
			rgvarg[nIndex].vt = VT_R8;
			rgvarg[nIndex].dblVal = dblSrc;
		};
	}
	void SetParam(DWORD nIndex, BSTR pStr)
	{
		if ( rgvarg && nIndex < cArgs ) {
			::VariantInit(&rgvarg[nIndex]);
			rgvarg[nIndex].vt = VT_BSTR;
			rgvarg[nIndex].bstrVal = pStr;
		};
	}
	void SetParam(DWORD nIndex, VARIANT& rVar)
	{
		if ( rgvarg && nIndex < cArgs ) {
			::VariantInit(&rgvarg[nIndex]);
			rgvarg[nIndex] = rVar;
		};
	}
};

#endif //__SAPATLTOOLKIT_H_
