#!/usr/bin/perl -w
#
#  Copyright (c) 2000 Reinhold Klapsing and Martin Rueschoff
# 
#  Reinhold Klapsing, Email: Reinhold.Klapsing@uni-essen.de
#  Martin Rueschoff,  Email: Martin.Rueschoff@uni-essen.de
# 
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Library General Public
#  License as published by the Free Software Foundation; either
#  version 2 of the License, or (at your option) any later version.
# 
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
# 
#  You should have received a copy of the GNU Library General Public
#  License along with this library; if not, write to the
#  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.
#


use CGI;
use Unix::Syslog qw(:macros);
use Unix::Syslog qw(:subs);

#--------------------------
require "wml_email.cfg"; 

require "../../shared_modules/M_session.pm";
require "wml_header.pm";
require "M_pop.pm";
require "M_wmessages.pm";
require "ZwapTools.pm";


#--------------
# in wml_email_config  my $URLbase = "http://matush.wi-inf.uni-essen.de/~mnr/zwap/";
my $URLbase = $wml_email_config::URLbase;
my $loginURL = "${URLbase}login.pl";
my $readMailURL = "${URLbase}pop3.pl";

# http://www.zwap.de/z.wml
my $startUpURL = $wml_email_config::startUpURL;
#-----------------
my $pop3auth = 1;    # 1 auth per pop3 , sonst per Zwap-PW 

#-----------------
my $debug = 0;          # debug-meldungen
my $logit = 1;          # sysloggen
$M_session::debug = $debug;
$M_pop::debug = $debug;

#--- fuer User-DB
my $UserDB_DIR      = "../../databases/ZWap-User";
my $UserDB_DSN      = "DBI:CSV:f_dir=$UserDB_DIR";
my $UserDB_USER     = "";
my $UserDB_PASSWD   = "";

#--- fuer SessionDB
my $SessDB_DIR      = "../../databases/ZWap-SessionKeys";
my $SessDB_DSN      = "DBI:CSV:f_dir=$SessDB_DIR";
my $SessDB_USER     = "";
my $SessDB_PASSWD   = "";

#---------------------------------
#  zumm Aufloesen von Variablen
my $CardTitle = "";
my $CardText = "";
#---------------------------------
my $RET = 99;

my $anzahl = $wml_email_config::anzahl;    # Anzahl dargestellter MailHeader

###################################################################
my $query = new CGI;

#-- welcher Client ruft an?
my $WapDevice = $ENV{"HTTP_USER_AGENT"};

###################################################################
#    in PATH_INFO:
#         ID
#         ServerNummer
#
#
#    als Parameter:
#         action
#         passwort p
#
###################################################################

my $P  = $query->param("p");
my $action = $query->param("action");
if ( !defined($action)) { $action = "";}

my $sessID = "";
my $POP3Server = "";
my $POP3account = "";
my $start = 1;

#-# ID und start aus PATH_INFO holen
my $PATHI = $ENV{"PATH_INFO"};
my $ID = "";
my $serverNo = "";
$PATHI =~ s#^/+(.*)#$1#;     # fuehrende / ab
($ID,$serverNo) = split( '/', $PATHI);
if ( !defined($ID)) { $ID = "";}
if ( !defined($serverNo)) { $serverNo = 1;}
if ( $serverNo > 3 || $serverNo < 1) { $serverNo = 1; }    # es kann nur 3 geben

#---------------------------------------------------------------
#-- sysloggen
openlog("zWAP-wml: login.pl", LOG_PID, LOG_DAEMON) if $logit;

#--- header schicken
WML_header::printContentType();
WML_header::printDocType();
WML_header::printWmlBegin();


if( $ID ne "" ) {     # name angegeben

  #-- Sprache, Schriftart  aus UserDB lesen
  ($GUI_language, $GUI_Font) = 
    ZwapTools::getGUIdata(
			  $UserDB_DSN,
			  $UserDB_USER,
			  $UserDB_PASSWD,
			  $ID 
			 );

  #-- Session--Datenbank-Verbindung herstellen  
  my $SessDbh = M_session::connectDB(
				     $SessDB_DSN, 
				     $SessDB_USER, 
				     $SessDB_PASSWD
				    );
  if ($SessDbh) { #- SessionDB OK
    #------------------------------------------------------------


#>>>>>>>>>    
    if ( $action eq "off") {      #-- user will eine noch laufende Session beenden

      #-- die ID = ZwapUser, und Passwd = ZwapPW pruefen; session bestimmen und beenden
      if ( defined( $P)) {       
	if ( ZwapTools::userValid( 
				  $UserDB_DSN,
				  $UserDB_USER,
				  $UserDB_PASSWD,
				  $ID, 
				  $P
				 ) == 1 ) {

	  #-- sessID fuer ID herausfinden
	  my $sess = M_session::getSessionFromID( $SessDbh, $ID);

	  M_session::deleteSessID( $SessDbh, $sess);
	  # syslog:
	  syslog( LOG_INFO, "member $ID killed his session $sess.") if $logit;

	  #- Texte sprachabhaengig auslesen
	  $CardTitle = M_Wmessages::getText( $GUI_language,"T_CLOSED");
	  $CardText = M_Wmessages::getText( $GUI_language,"C_SESSION_KILLED");
	  #- Variablen in $CardT* aufloesen
	  $CardTitle =~ s/(\$\w+)/$1/eeg; 
	  $CardText =~ s/(\$\w+)/$1/eeg; 
	  
	  WML_header::printErrorCard( 1,
				      "main",
				      $CardTitle,
				      $CardText
				    );
	 
	} else {    #- User/PW ungueltig
	  #- Texte sprachabhaengig auslesen
	  $CardTitle = M_Wmessages::getText( $GUI_language,"T_FAILED");
	  $CardText = M_Wmessages::getText( $GUI_language,"C_WRONG_NAMEPW_ZWAP");
	  #- Variablen in $CardT* aufloesen
	  $CardTitle =~ s/(\$\w+)/$1/eeg; 
	  $CardText =~ s/(\$\w+)/$1/eeg; 
	  
	  WML_header::printErrorCard( 1,
				      "main",
				      $CardTitle,
				      $CardText
				    );
	}
      } else {      #-  password fehlt
	  #- Texte sprachabhaengig auslesen
	  $CardTitle = M_Wmessages::getText( $GUI_language,"T_FAILED");
	  $CardText = M_Wmessages::getText( $GUI_language,"C_NO_PWFOUND");
	  #- Variablen in $CardT* aufloesen
	  $CardTitle =~ s/(\$\w+)/$1/eeg; 
	  $CardText =~ s/(\$\w+)/$1/eeg; 
	  
	  WML_header::printErrorCard( 1,
				      "main",
				      $CardTitle,
				      $CardText
				    );
      }


#>>>>>>>>>    
    } elsif ( $action eq "logoff") {      #-- user will sich ausloggen
      
      my $sessID = $query->param('session');
      my $sessIDvalid = M_session::validID( $SessDbh, $sessID);
      
      if( $sessIDvalid) {
	
	M_session::deleteSessID( $SessDbh, $sessID);

	# syslog:
	syslog( LOG_INFO, "member $ID left system.") if $logit;

	################################################
	#
	#    nach dem Ausloggen
	#    hier Card mit Timer erzeugen, nach timeout
	#    "z.wml" ($startUpURL)  laden
	#
	################################################

	#-- hier nach logoff die startseite (login.wml) laden
	#- Texte sprachabhaengig auslesen
	$CardTitle = M_Wmessages::getText( $GUI_language,"T_LOGOFF");
	#- Variablen in $CardT* aufloesen
	$CardTitle =~ s/(\$\w+)/$1/eeg; 
	# Variablen im BrowserContext loeschen
	print "<card title=\"$CardTitle\">"
	  . "<onevent type=\"ontimer\">"
	  . "<go href=\"${startUpURL}\">"
	  . "<setvar name=\"session\" value=\"\" />"
	  . "<setvar name=\"lang\" value=\"\" />"
	  . "<setvar name=\"tx\" value=\"\" />"
          . "<setvar name=\"tn\" value=\"\" />"
	  . "<setvar name=\"subj\" value=\"\" />"
	  . "<setvar name=\"cont\" value=\"\" />"
	  . "<setvar name=\"to\" value=\"\" />"
	  . "</go></onevent>"
 	  . "<timer value=\"10\"/>"
	  . "<p><img src=\"${URLbase}/wbmp/zwap2k.wbmp\" alt=\"zWAP\" align=\"middle\"/></p>"
	  . "</card>";

      } else {

	#- Texte sprachabhaengig auslesen
	$CardTitle = M_Wmessages::getText( $GUI_language,"T_CLOSED");
	$CardText = M_Wmessages::getText( $GUI_language,"C_SESSION_CLOSED");
	#- Variablen in $CardT* aufloesen
	$CardTitle =~ s/(\$\w+)/$1/eeg; 
	$CardText =~ s/(\$\w+)/$1/eeg; 

	WML_header::printErrorCard( 1,
				    "main",
				    $CardTitle,
				    $CardText
				  );
      }

      
#>>>>>>>>>    
    } elsif ( $action eq "login" ) {    #-- einloggen

      #- falls PW definiert, einloggen sonst  
      #- ausloggen, weil back in der history benutzt wurde
      if( defined( $P) ) {

	if ( $pop3auth == 1) {    # auth per pop3
	  #------------- POPdaten holen, user auth. ----------------------------
	  ($POP3server, $POP3account) = 
	    ZwapTools::getPOPdata(
				  $UserDB_DSN,
				  $UserDB_USER,
				  $UserDB_PASSWD,
				  $ID,
				  $serverNo               # serverNo
				 );
	  
	  if ( defined($POP3server) && defined($POP3account) ) {
	    
	    #-- auth. per pop3server durchfuehren
	    $RET = M_pop::POPauth( $POP3server, $POP3account, $P);
	    
	  } else {           # keine POP-daten definiert
	    $RET = 99;
	  }
	} else {  # auth per Zwap-PW
	  
	  $RET = 99;

	}


	#------------ auth OK -----------------------------------
	if ( $RET == 1 ) {      # user und pw OK
	  if ( ! M_session::userIn( $SessDbh, $ID) ) {  # noch nicht eingeloggt
	    if ( defined( $sessID = M_session::getSessID( $SessDbh, $ID)) ) { 
	      syslog( LOG_INFO, "member $ID entered system.") if $logit;
	    
	      #-- Passwort in  Session-Entry speichern   auch serverNo ??
 	      M_session::savePWSessID( $SessDbh, $sessID, $P, $serverNo);

	      #-- fetch default filter type from UserDB
	      my $fi_cfg = ZwapTools::getDefaultFilterType(
							   $UserDB_DSN,
							   $UserDB_USER,
							   $UserDB_PASSWD,
							   $ID 
							  );

	      #-- default filter type in  Session-Entry speichern
 	      M_session::saveFilterCFGtoSession( $SessDbh, $sessID, $fi_cfg);
	    
	      ################################################
	      #
	      #    hier Card mit Timer erzeugen, nach timeout
	      #    pop3.pl starten: start = 1 , 
	      #                     end = Start+ anzahl
	      #                       bzw. end berechnen
	      ################################################

	      my $end = $start + $anzahl -1;
	      #- Texte sprachabhaengig auslesen
	      $CardTitle = M_Wmessages::getText( $GUI_language,"T_CONNECT");
	      #- Variablen in $CardT* aufloesen
	      $CardTitle =~ s/(\$\w+)/$1/eeg; 
	      # sessionID und Sprache in BrowserContext speichern
	      print "<card title=\"$CardTitle\">\n"
	        . "<onevent type=\"ontimer\">"
	        . "<go href=\"$readMailURL/$sessID/$ID?action=content\&amp;start=${start}\&amp;end=${end}\"> \n"
	        . "<setvar name=\"session\" value=\"$sessID\" />"
		. "</go></onevent>"
                . "<timer value=\"20\"/><p>"
	        . "<img src=\"${URLbase}/wbmp/zwap2k.wbmp\" alt=\"zWAP\" align=\"middle\"/>";
	      WML_header::logoffButton( $loginURL,$sessID,$ID);
	      print "</p></card> \n";
	    }
	  } else {
	    #- Texte sprachabhaengig auslesen
	    $CardTitle = M_Wmessages::getText( $GUI_language,"T_BUSY");
	    $CardText = M_Wmessages::getText( $GUI_language,"C_SESSION_RUNNING");
	    #- Variablen in $CardT* aufloesen
	    $CardTitle =~ s/(\$\w+)/$1/eeg; 
	    $CardText =~ s/(\$\w+)/$1/eeg; 
	    
	    WML_header::printErrorCard( 1,
					"main",
					$CardTitle,
					$CardText
				      );
	  }
	  
	  #----------------- Fehler beim auth. -----------------
	} elsif ( $RET == 0) {  # pw falsch
	  #- Texte sprachabhaengig auslesen
	  $CardTitle = M_Wmessages::getText( $GUI_language,"T_FAILED");
	  $CardText = M_Wmessages::getText( $GUI_language,"C_WRONG_NAMEPW");
	  #- Variablen in $CardT* aufloesen
	  $CardTitle =~ s/(\$\w+)/$1/eeg; 
	  $CardText =~ s/(\$\w+)/$1/eeg; 
	  
	  WML_header::printErrorCard( 1,
				      "main",
				      $CardTitle,
				      $CardText
				    );

	} elsif ( $RET == 2) {  #  server nicht gefunden
	  #- Texte sprachabhaengig auslesen
	  $CardTitle = M_Wmessages::getText( $GUI_language,"T_FAILED");
	  $CardText = M_Wmessages::getText( $GUI_language,"C_NO_MAILSERVER_CONNECT");
	  #- Variablen in $CardT* aufloesen
	  $CardTitle =~ s/(\$\w+)/$1/eeg; 
	  $CardText =~ s/(\$\w+)/$1/eeg; 
	  
	  WML_header::printErrorCard( 1,
				      "main",
				      $CardTitle,
				      $CardText
				    );
	  # syslog:
	  syslog( LOG_INFO, "mailserver connect failed.") if $logit;
	  
	} elsif ( $RET == 99) { # no DB-connection 
	  #- Texte sprachabhaengig auslesen
	  $CardTitle = M_Wmessages::getText( $GUI_language,"T_FAILED");
	  $CardText = M_Wmessages::getText( $GUI_language,"C_NO_USERDB_CONNECT");
	  #- Variablen in $CardT* aufloesen
	  $CardTitle =~ s/(\$\w+)/$1/eeg; 
	  $CardText =~ s/(\$\w+)/$1/eeg; 
	  
	  WML_header::printErrorCard( 1,
				      "main",
				      $CardTitle,
				      $CardText
				    );
	  # syslog:
	  syslog( LOG_INFO, "userDB connect failed") if $logit;
	  
	} else {  # kommt das vor ?
	  #- Texte sprachabhaengig auslesen
	  $CardTitle = M_Wmessages::getText( $GUI_language,"T_FAILED");
	  $CardText = M_Wmessages::getText( $GUI_language,"ErrUnknown");
	  #- Variablen in $CardT* aufloesen
	  $CardTitle =~ s/(\$\w+)/$1/eeg; 
	  $CardText =~ s/(\$\w+)/$1/eeg; 
	  
	  WML_header::printErrorCard( 1,
				      "main",
				      $CardTitle,
				      $CardText
				    );	  	 
	}
      } else {
	#-- und ausloggen
	M_session::deleteSessID( $SessDbh, $sessID);
	syslog( LOG_INFO, "member $ID logoff. (no password)") if $logit;

	#- Texte sprachabhaengig auslesen
	$CardTitle = M_Wmessages::getText( $GUI_language,"T_FAILED");
	$CardText = M_Wmessages::getText( $GUI_language,"C_NO_PWFOUND");
	#- Variablen in $CardT* aufloesen
	$CardTitle =~ s/(\$\w+)/$1/eeg; 
	$CardText =~ s/(\$\w+)/$1/eeg; 
	
	WML_header::printErrorCard( 1,
				    "main",
				    $CardTitle,
				    $CardText
				  );
      }


#>>>>>>>>>    
    } else { # action ist leer , script aus history aufgerufen -> ausloggen
      
      ################################################
      #
      #    hier Card erzeugen, die nach "logoff" weiterleitet
      #      falls sie aus der history aufgerufen wurde
      #    "login.pl" starten mit: 
      #       action = logoff , 
      #       sessID = session (aus BrowserSpeicher)
      #                     
      ################################################

      #- Texte sprachabhaengig auslesen
      $CardTitle = M_Wmessages::getText( $GUI_language,"T_AUTOLOGOUT");
      #- Variablen in $CardT* aufloesen
      $CardTitle =~ s/(\$\w+)/$1/eeg; 
      # User-Name steht in $(id) im Browser
      # sessID steht in $(session) im Browser
      print "<card title=\"$CardTitle\">"
	. "<onevent type=\"onenterbackward\">"
	. "<go href=\"$loginURL/\$(id)\">"
        . "<postfield name=\"action\" value=\"logoff\"/>"
        . "<postfield name=\"session\" value=\"\$(session)\"/>"
        . "</go></onevent></card>";

      syslog( LOG_INFO, "auto-logoff for member $ID .") if $logit;
    }

    #- sessionDB schliessen
    M_session::disconnectDB( $SessDbh); 
  
  } else {
    #- Texte sprachabhaengig auslesen
    $CardTitle = M_Wmessages::getText( $GUI_language,"T_FAILED");
    $CardText = M_Wmessages::getText( $GUI_language,"C_NO_SESSIONDB_CONNECT");
    #- Variablen in $CardT* aufloesen
    $CardTitle =~ s/(\$\w+)/$1/eeg; 
    $CardText =~ s/(\$\w+)/$1/eeg; 
    
    WML_header::printErrorCard( 1,
				"main",
				$CardTitle,
				$CardText
			      );   
    syslog( LOG_INFO, "sessionDB connect failed") if $logit;
  }
  
} else {  #- kein Name angegeben; Meldung in allen Sprachen, da GUI_language nicht bekannt
  
  $GUI_language = $GUI_language_def;

  #- Texte sprachabhaengig auslesen
  $CardTitle = M_Wmessages::getText( $GUI_language,"T_FAILED");
  $CardText = M_Wmessages::getText( $GUI_language,"C_NO_USERNAME");
  #- Variablen in $CardT* aufloesen
  $CardTitle =~ s/(\$\w+)/$1/eeg; 
  $CardText =~ s/(\$\w+)/$1/eeg; 
  
  WML_header::printErrorCard( 1,
			      "main",
			      $CardTitle,
			      $CardText
			    );
}

#-- WML-ende
WML_header::printWmlEnd();

#-- sysloggen beenden
closelog() if $logit;

#---------------------- ende ---------------------

