#
#  Copyright (c) 2000 Reinhold Klapsing and Martin Rueschoff
# 
#  Reinhold Klapsing, Email: Reinhold.Klapsing@uni-essen.de
#  Martin Rueschoff,  Email: Martin.Rueschoff@uni-essen.de
# 
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Library General Public
#  License as published by the Free Software Foundation; either
#  version 2 of the License, or (at your option) any later version.
# 
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
# 
#  You should have received a copy of the GNU Library General Public
#  License along with this library; if not, write to the
#  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.
#

# package zur user-verwaltung

package M_user;

use DBI;



##################################################
sub connectDB {
##################################################
  my ($DB_DSN, $DB_USER, $DB_PASSWD) = @_;

  #-- Datenbank-Verbindung herstellen  
  my $dbh = DBI->connect($DB_DSN, $DB_USER, $DB_PASSWD) or $dbh = undef;
 
  return $dbh;
}

##################################################
sub disconnectDB {
##################################################
  my ($dbh) = @_;

  #-- Datenbank-Verbindung schliessen
  $dbh->disconnect();  # Datenbankverbindung lsen.
}


##################################################
sub user_exists {
##################################################
  my ($dbh,$ZWAPuser) = @_;

  my $sth = $dbh->prepare(
			  "SELECT ZWAPuser FROM members WHERE (ZWAPuser = ?)"
			 ) 
    or return(0);
  $sth->execute( $ZWAPuser) or return(0);

  ($ID) =  (@row = $sth->fetchrow_array);
  if( !defined $ID) { $ID = "";}
  
  if ( $ID eq $ZWAPuser) {
    return(1);
  } else {
    return(0);
  }
}


##################################################
sub insert_rec {
##################################################
  my(
     $dbh, $dbflist,
     $ZWAPuser, $ZWAPpw,
     $fname, $lname, $phone,
     $email, $addr, $notes,
     $s_question, $s_answer, 
     $pop3server1, $pop3account1,
     $pop3server2, $pop3account2,
     $pop3server3, $pop3account3,
     $gui_lang, $gui_font, $fi_global
    ) = @_;
  

  if( user_exists( $dbh, $ZWAPuser)) {
    return(0);
  }

  my $id = time . $$;  # Generate ID
         
  my $sql = qq[
	       INSERT INTO members
	       (id, $dbflist)
	       VALUES (
		       '$id', '$ZWAPuser','$ZWAPpw',
		       '$fname', '$lname', '$phone', 
		       '$email', '$addr', '$notes',
		       '$s_question', '$s_answer',
		       '$pop3server1', '$pop3account1',
		       '$pop3server2', '$pop3account2',
		       '$pop3server3', '$pop3account3',
		       '$gui_lang', '$gui_font', '$fi_global'
		      )
	      ];
  $dbh->do($sql) or die "Insert failed ($sql)";

  return(1);
}

##################################################
sub update_rec {
##################################################
  my($dbh, 
     $id,
     $ZWAPuser, $ZWAPpw,
     $fname, $lname, $phone,
     $email, $addr, $notes,
     $s_question, $s_answer, 
     $pop3server1, $pop3account1,
     $pop3server2, $pop3account2,
     $pop3server3, $pop3account3,
     $gui_lang, $gui_font, $fi_global
    ) = @_;
  
  my $sql = qq[
	       UPDATE members SET
	       ZWAPuser='$ZWAPuser',
	       ZWAPpw='$ZWAPpw',
	       fname='$fname', 
	       lname='$lname', 
	       phone='$phone', 
	       email='$email', 
	       addr='$addr', 
	       notes='$notes',
	       s_question='$s_question', 
	       s_answer='$s_answer',
	       pop3server1='$pop3server1', 
	       pop3account1='$pop3account1',
	       pop3server2='$pop3server2', 
	       pop3account2='$pop3account2',
	       pop3server3='$pop3server3', 
	       pop3account3='$pop3account3',
	       gui_lang='$gui_lang',
	       gui_font='$gui_font',
	       fi_global='$fi_global'
	       WHERE id = '$id'
	      ];

  $dbh->do($sql) or die "Update failed ($sql)";

  return(1);
}


##################################################
sub delete_rec {
##################################################
  my ($dbh,
      $user
     ) = @_; 

  my $sql = qq[
               DELETE FROM members
               WHERE ZWAPuser = '$user'
              ];
 
  $dbh->do($sql) or die "Delete failed ($sql)";       

  return(1);
}


##################################################
#--- User und Passwort ok? ----------------------------
##################################################
sub auth {
# return     1    OK
#            0    pw falsch
#            2    user nicht gefunden

  my ($dbh,$ID,$PW) = @_;
  my $i = "";
  my $p = "";

  my $sth = $dbh->prepare(
			  "SELECT ZWAPpw FROM members WHERE ZWAPuser='$ID'"
			 );
  $sth->execute();
  ($p) = (@row = $sth->fetchrow_array);

  if (!defined $p) { return 2;}        # nicht gefunden
  #- passwd gefunden und passwd gleich
  if( $p eq $PW) {
    return 1;
  } else {
    return  0;
  }
}


#-------------------------------------------------------------
##################################################
#-- pop3server, pop3account holen
sub getPOP {
#            (undef, undef)  ->  user nicht gefunden
##################################################

  my ($dbh,$ID,$serverno) = @_;
  my $sth = "";
  
  if ($serverno == 1) {
    $sth = $dbh->prepare(
		       "SELECT pop3server1, pop3account1, email FROM members WHERE ZWAPuser='$ID'"
		      );
  } elsif ($serverno == 2) {
    $sth = $dbh->prepare(
		       "SELECT pop3server2, pop3account2, email FROM members WHERE ZWAPuser='$ID'"
		      );
  } else {
    $sth = $dbh->prepare(
		       "SELECT pop3server3, pop3account3, email FROM members WHERE ZWAPuser='$ID'"
		      );
  }

  $sth->execute();
  @row = $sth->fetchrow_array or return (undef, undef);

  return @row;
}


##################################################
sub getGUIdata {
 # liefert GUI_lang, GUI_font im Klartext oder als Zahl (0,1)
##################################################
  my ($dbh,$ID,$binaer) = @_;
  
  my $sth = $dbh->prepare(
		       "SELECT gui_lang,gui_font FROM members WHERE ZWAPuser='$ID'"
			 );

  $sth->execute();
  @row = $sth->fetchrow_array or return (undef,undef);

  if ($binaer == 1) {
    return gui_ascii2bin( @row);
  } else {
    return( @row);
  }
}

##################################################
sub getDefFilterType {
##################################################
  my ($dbh,$ID) = @_;
  
  my $sth = $dbh->prepare(
		       "SELECT fi_global FROM members WHERE ZWAPuser='$ID'"
			 );

  $sth->execute();
  my $fi_type = $sth->fetchrow_array or return (undef);

  return( $fi_type);
}


##################################################
sub gui_ascii2bin {
##################################################
  my ($lang,$font) = @_;

  my $GUI_lang, 
  my $GUI_small;
  if( $lang eq 'englisch') {
    $GUI_lang = 0;
  } else {
    $GUI_lang = 1;
  }
  
  if( $font eq 'klein') {
    $GUI_small = 1;
  } else {
    $GUI_small = 0;
  }
  
  return( $GUI_lang, $GUI_small);
}


##################################################
sub gui_bin2ascii {
##################################################
  my ($lang,$font) = @_;

  my $GUI_lang, 
  my $GUI_small;

  if( $lang == 0) {
    $GUI_lang = 'englisch';
  } else {
    $GUI_lang = 'deutsch';
  }
  
  if( $font == 1) {
    $GUI_small = 'klein';
  } else {
    $GUI_small = 'normal';
  }
  
  return( $GUI_lang, $GUI_small);
}


#---------------------------------------------------------------------

1;     # rueckmeldung

#---------------------------------------------------------------------
