#
#  Copyright (c) 2000 Reinhold Klapsing and Martin Rueschoff
# 
#  Reinhold Klapsing, Email: Reinhold.Klapsing@uni-essen.de
#  Martin Rueschoff,  Email: Martin.Rueschoff@uni-essen.de
# 
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Library General Public
#  License as published by the Free Software Foundation; either
#  version 2 of the License, or (at your option) any later version.
# 
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
# 
#  You should have received a copy of the GNU Library General Public
#  License along with this library; if not, write to the
#  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.
#


# package zur Session-Verwaltung


package M_session;

use DBI;


#---- session timeout in sekunden
$idTimeout = 600;


#--------------
#- DB oeffnen
sub connectDB {
  my ($DB_DSN, $DB_USER, $DB_PASSWD) = @_;
  
  #-- Datenbank-Verbindung herstellen
  my $dbh = DBI->connect($DB_DSN, $DB_USER, $DB_PASSWD) or $dbh = undef;
  
  return $dbh;                
}

#--------------
#- DB schliessen
sub disconnectDB {
  my ($dbh) = @_;
  
  #-- Datenbank-Verbindung schliessen
  $dbh->disconnect();  # Datenbankverbindung lsen.       
}

#--------------- 
#- ist dieser User eingeloggt?
sub userIn {
  #-- return:  1 oder 0
  my ($dbh,$user) = @_;
  
  print "DBH: $dbh    USER: $user  <br>\n" if $debug;

  #- gibts einen Eintrag user?
  my $sth = $dbh->prepare(
			  "SELECT user FROM SessionKeys WHERE (user = ?)"
			 ) 
    or return(undef);
  $sth->execute( $user) or return(undef);
  
  my ($ID) =  (@row = $sth->fetchrow_array);
  if( !defined $ID) { $ID = "";}
  
  print "User: $ID \n" if $debug;
  
  if ( $ID eq $user) {
    return(1);
  } else {
    return(0);
  }
}



#-------------------------------------------------------         
#--- SessionID valid -----------------------------------
sub validID {
  #- return:   1  oder 0
  my ($dbh,$sessID) = @_;     # gibts diese session
  
  #- gibts einen Eintrag sessID?
  my $sth = $dbh->prepare(
			  "SELECT sessionID FROM SessionKeys WHERE (sessionID = ?)"
			 ) 
      or return(0);
  $sth->execute($sessID) or return(0);
  
  my ($ID) =  (@row = $sth->fetchrow_array);
  if( !defined $ID) { $ID = "";}
  
  print "ID: $ID \n" if $debug;
  
  if ( $ID eq $sessID) {
    return(1);
  } else {
    return(0);
  }
}


#-------------------------------------------------------         
#--- delete SessionID ----------------------------------
sub deleteSessID {
  #-- return:  1 oder 0
  my ($dbh,$sessID) = @_;     # fuer diesen user
  
  if ( validID( $dbh, $sessID) ) {
    #- Eintrage mit sessID loeschen
    my $sql = qq[ 
		 DELETE FROM SessionKeys
		 WHERE (sessionID = "$sessID")
		];
    $dbh->do($sql) or return(0);
    
    return(1);
  } else {
    return(0);
  }
}

#--- SessionID busy -----------------------------------
sub busy {
  #-- return:   OK  oder  FAIL
  my ($dbh,$user) = @_;     # fuer diesen user
  
  return( $answ);
}

#--- SessionID holen ----------------------------------
sub getSessID {
  #-- return:   sessID   oder  undef
  my ($dbh,$user) = @_;     # fuer diesen user
  
    if ( ! userIn( $dbh, $user) ) {
    
    #- sessID : user+datum in sek.
    #- timeout: datum in sek. um $idTimeout erhoeht
    #-
    #- sessID erzeugen, mit berechnetem timeout und user eintragen
    
    my $zeit = time;
    
    my $sessID    = $user . $zeit ;
    my $timelimit = $zeit + $idTimeout;
    
    print "<br>NEWID ZEIT: $zeit    ID: $sessID   LIMIT: $timelimit PW: \n" if $debug;
 
    my $sql = qq[ 
		 INSERT INTO SessionKeys
		 (user, sessionID, timelimit, pw, serverNo, FI_global)
		 VALUES ('$user', '$sessID', '$timelimit',"", "", "")
		];
    $dbh->do($sql) or return(undef);

    return($sessID);
  } else {
    return(undef);
  }
}

#--- SessionID updaten ----------------------------------
sub updateSessID {
  #-- return:   1 oder 0
  my ($dbh,$sessID) = @_;     # fuer diesen user
  
  print "<br> updateSessID $dbh $sessID \n" if $debug;
  print "<br> timeout: $idTimeout \n" if $debug;

  if ( validID( $dbh, $sessID) ) {
    print "<br> updateSessID: valid \n" if $debug;
    
    #- Eintrag mit neuem Timeout setzen
    #- Eintrag v. sessID lesen
    #-            datum um $idTimeout erhoehen
    #-            Eintrag zurueckschreiben
    $zeit = time;
    
    $timelimit = $zeit + $idTimeout;
    
    my $sql = qq[ 
		 UPDATE SessionKeys SET timelimit = "$timelimit"
		 WHERE (sessionID = "$sessID")
		];
    $dbh->do($sql) or return(0);
    
    return(1);
  } else {
    return(0);
  }
  
}

#--- Passwort in Session speichern -----------------------
sub savePWSessID {
  #-- return:  1 oder 0
  my ($dbh, $sessID, $p, $serverNo) = @_;     # passwd fuer diesen user
  
  if ( validID( $dbh, $sessID) ) {
    
    #- Eintrag mit PW setzen
    #-    "     "  serverNo setzen
    my $sql = qq[ 
		 UPDATE SessionKeys SET pw = "$p", serverNo = "$serverNo"
		 WHERE (sessionID = "$sessID")
		];

    $dbh->do($sql) or return(0);
    
    return(1);
  } else {
    return(0);
  }
}

#--- Passwort der Session liefern -----------------------
sub getPWSessID {
  #-- return:  Liste mit PW, ServerNo  oder  undef
  my ($dbh,$sessID) = @_;     #  fuer diese session

  if ( validID( $dbh, $sessID) ) {
    
    #- Eintrag v. sessID lesen
    my $sth = $dbh->prepare(
			    "SELECT pw, serverNo FROM SessionKeys WHERE ( sessionID = ?)"
			   ) 
      or return(0);
    $sth->execute($sessID) or return(undef);
    
    my ($P,$serverNo) =  (@row = $sth->fetchrow_array);
    if( !defined $P) { $P = "";}
    
    print "getPW: $sessID \n" if $debug;
    
    return( @row);
  } else {
    return(undef);
  }
}


#--- FilterCFG in Session speichern -----------------------
sub saveFilterCFGtoSession {
  #-- return:  1 oder 0
  my ($dbh, $sessID, $F_cfg) = @_;     # FilterCFG fuer diesen user
  
  if ( validID( $dbh, $sessID) ) {
    
    #- Eintrag mit F_cfg setzen
    my $sql = qq[ 
		 UPDATE SessionKeys SET FI_global = "$F_cfg"
		 WHERE (sessionID = "$sessID")
		];

    $dbh->do($sql) or return(0);
    
    return(1);
  } else {
    return(0);
  }
}

#--- FilterCFG der Session liefern -----------------------
sub getFilterCFGfromSession {
  #-- return:  FilterCFG  oder  undef
  my ($dbh,$sessID) = @_;     #  fuer diese session

  if ( validID( $dbh, $sessID) ) {
    
    #- Eintrag v. sessID lesen
    my $sth = $dbh->prepare(
			    "SELECT FI_global FROM SessionKeys WHERE ( sessionID = ?)"
			   ) 
      or return(0);
    $sth->execute($sessID) or return(undef);
    
    my ($FI) =  (@row = $sth->fetchrow_array);
    if( !defined $FI) { $FI = "";}
    
    print "getPW: $sessID \n" if $debug;
    
    return( $FI);
  } else {
    return( "" );    # default > don't filter
  }
}



#-----------------------------------------------------
sub getIDFromSession {
  #-- return:  ID  oder  undef
  my ($dbh,$sessID) = @_;     #  fuer diese session

  #- Eintrag v. sessID lesen
  my $sth = $dbh->prepare(
			  "SELECT user FROM SessionKeys WHERE ( sessionID = ?)"
			 ) 
    or return(0);
  $sth->execute($sessID) or return(undef);
  
  my ($ID) =  (@row = $sth->fetchrow_array);
  if( !defined $ID) { $ID = undef;}
  
  print "getIDFromSession: $ID \n" if $debug;
  
  return($ID);
}

#-----------------------------------------------------
sub getSessionFromID {
  #-- return:  sessionID  oder  undef
  my ($dbh,$ID) = @_;     #  fuer diese session
    
  #- Eintrag v. sessID lesen
  my $sth = $dbh->prepare(
			  "SELECT sessionID FROM SessionKeys WHERE ( user = ?)"
			 ) 
    or return(0);
  $sth->execute($ID) or return(undef);
  
  my ($sess) =  (@row = $sth->fetchrow_array);
  if( !defined $sess) { $sess = undef;}
  
  print "getSessionFromID: $sessID \n" if $debug;
  
  return($sess);
}


#-----------
1;  # rueckmeldung

#-----------------------------------------

=head1 NAME

M_session - Package zur Session-Verwaltung

=head1 SYNOPSIS

M_session ist ein Package zur Verwaltung von Sessions, 
so da ein Benutzername und ein Kennwort mittels einer 
sessionId aus einer Datenbank abgefragt werden kann.



=head1 Benutzung

Einbinden des Packages M_session

use lib "/net/swt/u/students/accountName/perl_modules";

setzt den Pfad auf das Verzeichnis, in dem lokal Perl-Module 
installiert sind.

use M_session;

bindet das Package M_session ein.


Folgende Variable sind im aufrufenden Script zu setzen
und an die Funktion "connectDB" zu bergeben.

z.B. fr die Verwendung einer Datenbank mit dem Namen SessionDB

my $SessDB_DIR = "./SessionDB";

my $SessDB_DSN = "DBI:CSV:f_dir=$SessDB_DIR";

my $SessDB_USER = "";

my $SessDB_PASSWD = "";


=head2 Datenbank ffnen

my $SessDbh = M_session::connectDB(
                                   $SessDB_DSN, 
                                   $SessDB_USER, 
                                   $SessDB_PASSWD
                                  );

 Beschreibung:
 - speichert ein neu erzeugtes Datenbank-Handle in der Skalarvariable $SessDbh

 Argumente: 
 - $SessDB_DSN ist eine Referenz auf die zu benutzende Datenbank
 - $SessDB_USER ist eine UserId
 - $SessDB_PASSWD ist ein Kennwort

 Rckgabewert: 
 - Datenbank-Handle


=head2 Datenbank schlieen 

M_session::disconnectDB($SessDbh); 

 Beschreibung
 - schliet die durch das Datenbank-Handle $SessDbh referenzierte Datenbank.

 Argumente: 
 - $SessDbh ist ein Datenbank-Handle 

 Rckgabewert: 
 - Nein

=head2 Abfrage ob ein User schon eingelogged ist.

M_session::userIn( $SessDbh, $ID)

  Argumente: 
  - $SessDbh ist ein Datenbank-Handle 
  - $ID ist eine UserID

  Rckgabewert:
  - 1 wenn User schon eingelogged ist 
  - 0 wenn User noch nicht eingelogged ist


=head2 Abfrage ob eine Session schon existiert

M_session::validID( $SessDbh, $sessID);

 Argumente:
 - $SessDbh ist ein Datenbank-Handle
 - $sessID ist eine Session-ID

 Rckgabewert: 
 - 1 wenn Session schon existiert
 - 0 wenn Session noch nicht existiert

=head2 Beenden einer Session

M_session::deleteSessID( $SessDbh, $sessID);

 Argumente: 
 - $SessDbh ist ein Datenbank-Handle
 - $sessID ist eine Session-ID

 Rckgabewert:
 - 1 wenn Beenden der Session erfolgreich war
 - 0 wenn ein Fehler beim Beenden der Session aufgetreten ist

=head2 Erzeugen einer Session-ID

M_session::getSessID( $SessDbh, $ID)

 Beschreibung:
 - die Session-ID verfllt nach einem Time-Out

 Argumente: 
 - $SessDbh ist ein Datenbank-Handle
 - $ID ist eine User-ID

 Rckgabewert: 
 - eine Session-ID
 - oder undef wenn keine Session-ID erzeugt werden konnte

=head2 Timeout fr eine Session-Id neu setzen

M_session::updateSessID( $SessDbh, $sessID);

 Beschreibung:
 - Eine Session-ID wird automatisch nach einer bestimmten 
   Zeit aus der Session-ID-Datenbank gelscht. Diese Funktion
   ist notwendig, um zu gewhrleisten das eine Session auch 
   beendet wird, wenn ein User sich nicht korrekt vom System 
   abmeldet.

 Argumente: 
 - $SessDbh ist ein Datenbank-Handle
 - $sessID ist eine Session-ID

 Rckgabewert: 
 - 1, wenn updaten der Session-ID erfolgreich war
 - 0, wenn ein Fehler beim updaten der Session-ID aufgetreten ist

=head2 Ermitteln der aktuellen Session-ID fr einen User

 M_session::getSessionFromID( $SessDbh, $ID);

 Argumente: 
 - $SessDbh ist ein Datenbank-Handle
 - $ID ist ein User

 Rckgabewert: 
 - Session-ID
 - oder undef wenn fr den User keine aktuelle Session existiert

=head2 Ermitteln eines Benutzers mittels einer Session-ID

 M_session::getIDFromSession($SessDbh, $sessID);

 Argumente: 
 - $SessDbh ist ein Datenbank-Handle
 - $sessID ist eine Session-ID

 Rckgabewert: 
 - user
 - oder undef, wenn fr die Session-ID kein User ermittelt werden konnte

=head2



=cut


#-------------------------------------------------------         
