#
#  Copyright (c) 2000 Reinhold Klapsing and Martin Rueschoff
# 
#  Reinhold Klapsing, Email: Reinhold.Klapsing@uni-essen.de
#  Martin Rueschoff,  Email: Martin.Rueschoff@uni-essen.de
# 
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Library General Public
#  License as published by the Free Software Foundation; either
#  version 2 of the License, or (at your option) any later version.
# 
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
# 
#  You should have received a copy of the GNU Library General Public
#  License along with this library; if not, write to the
#  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.
#

# package zur verwaltung der MailFilter

package M_filters;

use DBI;


###########################################################
#
#     DataBase: ZWap-Email
#
#
#
#           table  Filters
#   ------------------------------------------
#   ZWAPuser,   alias,   filterstring,  type,  target, activ
#
#                                        excl    From   yes
#                                       /incl   /Subj  /no
#
############################################################




##################################################
sub connectDB {
##################################################
  my (
      $DB_DSN, 
      $DB_USER, 
      $DB_PASSWD
     ) = @_;

  #-- Datenbank-Verbindung herstellen  
  my $dbh = DBI->connect($DB_DSN, $DB_USER, $DB_PASSWD) or $dbh = undef;
 
  return $dbh;
}

##################################################
sub disconnectDB {
##################################################
  my ($dbh) = @_;

  #-- Datenbank-Verbindung schliessen
  $dbh->disconnect();  # Datenbankverbindung lsen.
}

##################################################
sub alias_exists {
##################################################
  my (
      $dbh, 
      $user, 
      $alias
     ) = @_;
			  
  my $sql = qq[SELECT alias FROM Filters WHERE ZWAPuser = ? AND alias = ?];

  my $sth = $dbh->prepare( $sql) or return(0);
  $sth->execute( $user, $alias) or return(0);

  ($ali) =  (@row = $sth->fetchrow_array);
  if( !defined $ali) { $ali = "";}
  
  if ( $ali eq $alias) {
    return(1);
  } else {
    return(0);
  }
}

##################################################
sub insert_rec {
##################################################
  my(
     $dbh,
     $user,
     $alias, 
     $filter,
     $type,
     $target,
     $activ
    ) = @_;
  
  if( alias_exists( $dbh, $user, $alias)) {
    return(0);
  }

  my $sql = qq[
	       INSERT INTO Filters
	       (ZWAPuser,alias,filterstring,type,target,activ)
	       VALUES ('$user', '$alias', '$filter', '$type','$target','$activ')
	      ];

  $dbh->do($sql) or die "Insert failed ($sql)";

  return(1);
}

##################################################
sub update_rec {
##################################################
  my(
     $dbh,
     $user,
     $alias, 
     $filter,
     $type,
     $target,
     $activ
    ) = @_;

  my $sql = qq[
	       UPDATE Filters SET
	       filterstring='$filter', type='$type', target='$target', activ='$activ'
	       WHERE (ZWAPuser = '$user' AND alias = '$alias')
	      ];

  $dbh->do($sql) or die "Update failed ($sql)";

  return(1);
}

##################################################
sub delete_rec {
##################################################
  my(
     $dbh,
     $user,
     $alias
    ) = @_;

  my $sql = qq[
               DELETE FROM Filters
               WHERE (ZWAPuser = '$user' AND alias = '$alias')
              ];

  $dbh->do($sql) or return(0);

  return(1);
}

#################################################
#-- Mail-Filters holen
#################################################
sub getMailFilters {
  my (
      $dbh, 
      $user, 
      $filters,
      $types,
      $targets,
      $actives,
      $getall
     ) = @_;

  my $sth = undef;

  if ( $getall == 1) {
    $sth = $dbh->prepare(
			 "SELECT alias, filterstring, type, target,activ FROM Filters WHERE (ZWAPuser = ?)"
			);
  } else {
    $sth = $dbh->prepare(
			 "SELECT alias, filterstring, type, target,activ FROM Filters WHERE (ZWAPuser = ? AND activ=\"Y\")"
			);
  }


  $sth->execute( $user);
  
  while( (@row = $sth->fetchrow_array) ) {
    ($alias,$filter,$type,$target,$activ) =  (@row);

#print STDERR "M_filters::F: $filter  A: $alias   Typ: $type   Targ: $target   Activ: $activ \n";

    $ {$filters}{$alias}  = ${filter}; 
    $ {$types}{$alias}    = ${type};
    $ {$targets}{$alias}  = ${target};
    $ {$actives}{$alias}  = ${activ};
  }

}


#################################################
#-- einen    Mail-Filter holen
#################################################
sub getMailFilter {
  my (
      $dbh, 
      $user, 
      $alias,
      $getall
     ) = @_;

  my $sth = undef;

  if ( $getall == 1) {

    $sth = $dbh->prepare(
			 "SELECT filterstring, type, target,activ FROM Filters WHERE (ZWAPuser = ? AND alias = ?)"
			);
  } else {
    $sth = $dbh->prepare(
			 "SELECT filterstring, type, target,activ FROM Filters WHERE (ZWAPuser = ? AND alias = ? AND activ=\"Y\")"
			);
  }


  $sth->execute( $user, $alias) or return("");;

  my ($filter, $type, $target, $activ) = (@row = $sth->fetchrow_array);
  return($filter,$type,$target,$activ);
}


#---------------------------------------------------------------------

1;     # rueckmeldung

#---------------------------------------------------------------------
