#!/usr/bin/perl -w
#
#  Copyright (c) 2000 Reinhold Klapsing and Martin Rueschoff
# 
#  Reinhold Klapsing, Email: Reinhold.Klapsing@uni-essen.de
#  Martin Rueschoff,  Email: Martin.Rueschoff@uni-essen.de
# 
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Library General Public
#  License as published by the Free Software Foundation; either
#  version 2 of the License, or (at your option) any later version.
# 
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
# 
#  You should have received a copy of the GNU Library General Public
#  License along with this library; if not, write to the
#  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.
#
 
use CGI qw/:standard :html3/;
use CGI::Carp qw/fatalsToBrowser/;
use Unix::Syslog qw(:macros);
use Unix::Syslog qw(:subs);
use Net::SMTP;

#- config
require "html_interface.cfg";

require "../shared_modules/M_user.pm";
require "../shared_modules/M_session.pm";

require "M_languages.pm";
require "M_messages.pm";
require "M_tools.pm";

#-----------------------------------------------
my $debug = 0;
my $logit = 1;
$M_session::debug = $debug;

#-----------------------------------------------
my $MailTo             = $html_interface_config::MailTo;
my $MailFrom           = $html_interface_config::MailFrom; 

#-----------------------------------------------
my $use_smtp           = $html_interface_config::use_smtp;
my $path2sendmail      = $html_interface_config::path2sendmail;
my $sendmail_options   = $html_interface_config::sendmail_options;
my $SMTP_server        = $html_interface_config::SMTP_server;

#- marker for required input fields
my $required_marker    = $html_interface_config::required_marker;

my $no_session_message = $html_interface_config::mess_closed;
my $logoff_message     = $html_interface_config::mess_logoff;
my $bye_message        = $html_interface_config::mess_deleted;
my $mail_message       = $html_interface_config::mess_mail;

my $URLbase            = $html_interface_config::URLbase;
my $registrationURL    = "${URLbase}Z_registration.pl";
my $configURL          = "${URLbase}Z_email_conf.pl";


#-----------------------------------------------

my $lang_code = "EN";     # actual language, must be fetched from userDB

# possible languages for wml-interface, EN DE ES
my $languages = M_languages::getLanguages();
#- for form selection lists
my $tmp_languages = $s = "";
foreach $s (split(" ",$languages)) {
  $tmp_languages = $tmp_languages ."'" . $s ."',";
}



my $font_code = "S";  # default fontsize small

# possible fontsizes for wml-interface, S N
my $fonts = M_messages::getFonts();
#- for form selection lists
my $tmp_fonts = $s = "";
foreach $s (split(" ",$fonts)) {
  $tmp_fonts = $tmp_fonts ."'" . $s ."',";
}

#-----------------------------------------------
my $UserDB_DIR      = "../databases/ZWap-User";
my $UserDB_DSN      = "DBI:CSV:f_dir=$UserDB_DIR";
my $UserDB_USER     = "";
my $UserDB_PASSWD   = "";
 
my @UserDbFields = 
  qw/ZWAPuser ZWAPpw fname lname phone email addr 
     notes s_question s_answer
     pop3server1 pop3account1
     pop3server2 pop3account2
     pop3server3 pop3account3 
     gui_lang gui_font fi_global /;
my $UserDbFlist  = join(', ', @UserDbFields);

#--- for SessionDB
my $SessDB_DIR      = "../databases/ZWap-SessionKeys";
my $SessDB_DSN      = "DBI:CSV:f_dir=$SessDB_DIR";
my $SessDB_USER     = "";
my $SessDB_PASSWD   = "";

#-- create connection to Session-database  
my $SessDbh = M_session::connectDB($SessDB_DSN, $SessDB_USER, $SessDB_PASSWD) 
  or die "Cannot connect to sessionDB";


#-- find sessID  ---------------
my $sessID = $ENV{"PATH_INFO"};
$sessID =~ s#^/+(.*)#$1#;     # fuehrende / ab
my $sessIDvalid = M_session::validID( $SessDbh, $sessID);


my %texts = (
	     N => "none",
	     X => "reject",
	     I => "accept"
	    );
my $textsRef = \%texts;


#--- create syslog-connection
openlog("zWAP-html: Z_registration.pl", LOG_PID, LOG_DAEMON) if $logit;

#-- there is no active session ---------
if ( (    param('edit') eq "1" 
       || param('delete') eq "1"
       || param('change') eq "1"
       || param('logoff') eq "1"
     ) 
     && $sessIDvalid == 0) {

  no_session( $sessID);
  # syslog:
  syslog( LOG_INFO, "no session $sessID (edit, change, delete, logoff).") if $logit;
  closelog() if $logit;
  exit;
}
#--------------------------------



#-- create connection to User-database
my $UserDbh = M_user::connectDB($UserDB_DSN, $UserDB_USER, $UserDB_PASSWD) 
  or die "Cannot connect to userDB";

#-- let's start 
 print header(), start_html(-BGCOLOR=>'#FFFFFF');



#-- neuer User
if(param('insert')) {

  $user = param('ZWAPuser');
  
  if( M_user::insert_rec($UserDbh, $UserDbFlist, map { param($_) } @UserDbFields ) == 1) {
    #- 
    my $tmp_langRef = M_languages::getLanguageHashRef( param('gui_lang') );
    my $tmp_fontRef = M_messages::getSizesHashRef( param('gui_lang') );

    print "<h1>Member $user registered.</h1>\n";

    print 
      table({"border" => 1},
 
#	    TR(td("Account name:"),     td( param('ZWAPuser')),    td("Password:"),       td( param('ZWAPpw'))  ),
	    TR(td("Account name:"),     td( param('ZWAPuser')),    td("Password:"),       td( "**SECRET NOT SHOWN**")  ),
	    TR(td("Firstname:"), 	td( param('fname')),       td("Family name:"),    td( param('lname'))  ),
	    TR(td("Phone:"), 	        td( param('phone')),       td("Email:"),          td( param('email')) ),
	    TR(td("Address:"), 	        td( param('addr')),        td("Notes:"),          td( param('notes')) ),
	    TR(td("Question:"),         td( param('s_question')),  td("Answer:"),         td( param('s_answer')) ),
	    TR(td("POP3-Server1:"),     td( param('pop3server1')), td("POP3-Account1:"),  td( param('pop3account1')) ),
	    TR(td("POP3-Server2:"),     td( param('pop3server2')), td("POP3-Account2:"),  td( param('pop3account2')) ),
	    TR(td("POP3-Server3:"),     td( param('pop3server3')), td("POP3-Account3:"),  td( param('pop3account3')) ),
	    TR(td("WAP-Language:"),     td( param('gui_lang')),    td("WAP-Font:"),       td( param('gui_font')) ),
	    TR(td("Default Mail Filter Type:"),   td( $texts{param('fi_global')} ), td(""),  td("") ),
	   );

    # syslog:
    syslog( LOG_INFO, "new user $user created.") if $logit;

    #-- for testing purposes send an email to ... 
    my $mailcontent = 
      "Neuer User: " . param('ZWAPuser') . "\n" . param('fname') . " " . param('lname');
    
    sendMail2( $MailTo, $MailFrom, "zWAP: news", $mailcontent );

    #-- send acknowledge mail to registered user
    #-- user data, passwd ??

    sendAck2User( param('email'), $MailFrom );

  } else {
    print "insert failed: zWAP-Name $user exists!\n";
    # syslog:
    syslog( LOG_INFO, "create new user $user failed.") if $logit;
  }



#-- delete user 
} elsif ( $sessIDvalid && param('delete')) {

  # delete DB entry 
  my $user = param('user');
     
  my $sql = qq[
	       DELETE FROM members
	       WHERE ZWAPuser = '$user'
	      ];

  $UserDbh->do($sql) or die "Delete failed ($sql)";

  user_deleted();

  M_session::deleteSessID( $SessDbh, $sessID);

  #-- for testing purposes send an email to ... 
  my $mailcontent = 
    "User " . $user . " loeschte seinen account.\n";

  sendMail2( $MailTo, $MailFrom, "zWAP: user deleted", $mailcontent );
  
  # syslog:
  syslog( LOG_INFO, "user $user deleted.") if $logit;



#-- logoff User 
} elsif ( $sessIDvalid && param('logoff')) {

  my $user = param('user');

  logged_off();

  M_session::deleteSessID( $SessDbh, $sessID);
  # syslog:
  syslog( LOG_INFO, "member $user left system.") if $logit;




#-- edit user data 
} elsif ( $sessIDvalid && param('edit')) {

  # get DB entry for $ID 
  my $ID = param('user');
  # memorize id from DB -> hidden
  my $id = "";


  my $sql = qq[
	       SELECT id, $UserDbFlist
	       FROM members
	       WHERE ZWAPuser = '$ID'
	      ];
  my $cursor = $UserDbh->prepare($sql) or 
    die "Cannot select ($sql)";
  $cursor->execute() or die "SQL failed";

  while(defined($row = $cursor->fetch)) {
    $id = $row->[0];
    
    my $i = 1;
    foreach $field (@UserDbFields) {
      param($field, $row->[$i++]);
    }
  }

  #- 
  my $tmp_langRef = M_languages::getLanguageHashRef( param('gui_lang') );
  my $tmp_fontRef = M_messages::getSizesHashRef( param('gui_lang') );

  print "<h1>Registry Data</h1>\n";
  print "<h3>Fields marked ${required_marker} are required!</h3>";

  # create form 
  print start_form( -action => "${registrationURL}/${sessID}",
		    -method => "post"),
  table({"border" => 1},
	
	hidden(-name => 'id',
	       -value => $id ),
	
	# have ZWAPuser handy, there's no textedit field any more
	hidden(-name => 'ZWAPuser',
	       -value => param('ZWAPuser') ),

# internal DB identifier, not public	TR(td("id:"),td($id) ),
	
	TR(td("Account name:"), 
# don't edit account name!! 	   td(textfield(-name => 'ZWAPuser', value => param('ZWAPuser') )), 
	   td(param('ZWAPuser') ), 
	   td("${required_marker}Password:"), 
	   td(password_field(-name => 'ZWAPpw', value => param('ZWAPpw')))),
	TR(td("Firstname:"),
	   td(textfield(-name => 'fname', value => param('fname') )),
	   td("${required_marker}Family name:"), 
	   td(textfield(-name => 'lname', value => param('lname') ))),
	TR(td("Phone:"), 
	   td(textfield(-name => 'phone', value => param('phone') )),
	   td("${required_marker}Email:"), 
	   td(textfield(-name => 'email', value => param('email') ))),
	TR(td("Address:"), 
	   td(textarea(-name => 'addr', -rows => 3, value => param('addr') )),
	   td("Notes:"), 
	   td(textarea(-name => 'notes', -rows => 3, value => param('notes') ))),
	TR(td("Question:"), 
	   td(textfield(-name => 's_question', value => param('s_question') )),
	   td("Answer:"), 
	   td(textfield(-name => 's_answer', value => param('s_answer') ))),
	TR(td("${required_marker}POP3-Server1:"), 
	   td(textfield(-name => 'pop3server1', value => param('pop3server1') )),
	   td("${required_marker}POP3-Account1:"), 
	   td(textfield(-name => 'pop3account1', value => param('pop3account1') ))),
	TR(td("POP3-Server2:"), 
	   td(textfield(-name => 'pop3server2', value => param('pop3server2') )),
	   td("POP3-Account2:"), 
	   td(textfield(-name => 'pop3account2', value => param('pop3account2') ))),
	TR(td("POP3-Server3:"), 
	   td(textfield(-name => 'pop3server3', value => param('pop3server3') )),
	   td("POP3-Account3:"), 
	   td(textfield(-name => 'pop3account3', value => param('pop3account3') ))),
	TR(td("WAP-Language:"),   
	   td( scrolling_list( 
			      -name => 'gui_lang', 
			      -values => [eval($tmp_languages)],
			      -labels => $tmp_langRef,
			      -default => param('gui_lang'),
			      -size    => 1
			     )), 
	   td("WAP-Font:"),  
	   td( scrolling_list(
			      -name => 'gui_font',
			      -values => [eval($tmp_fonts)],
			      -labels => $tmp_fontRef,
			      -default => param('gui_font'),
			      -size => 1
			     )) ),
	TR(td("default Mail Filter Type:"),   
	   td( scrolling_list( 
			      -name => 'fi_global', 
			      -values => ['X','I','N'],
			      -labels => $textsRef,
			      -default => param('fi_global'),
			      -size    => 1
			     )), 
	   td(""),  
	   td("") ),
       ),
       # submit with 'change'
       hidden(-name => 'change',
	      -value => 1 );
  
  print submit( -value => 'Update record');

  #-- update TimeStamp 
  M_session::updateSessID( $SessDbh, $sessID);




#-- write modified user data 
} elsif ( $sessIDvalid && param('change')) {

  $user = param('ZWAPuser');
  #- 
  my $tmp_langRef = M_languages::getLanguageHashRef( param('gui_lang') );
  my $tmp_fontRef = M_messages::getSizesHashRef( param('gui_lang') );

  print 
    table({"border" => 1},

#	  TR(td("id:"),
#	     td( param('id')) ,
#	     td( ), 
#	     td( )),
	  TR(td("Account name:"),     
	     td( param('ZWAPuser')),
	     td("Password:"), 
#	     td( param('ZWAPpw'))  ),
	     td( "**SECRET NOT SHOWN**") ) ,
	  TR(td("Firstname:"), 	     
	     td( param('fname'))  ,
	     td("Family name:"),      
	     td( param('lname')) ),
	  TR(td("Phone:"), 	     
	     td( param('phone')) ,
	     td("Email:"), 	     
	     td( param('email')) ),
	  TR(td("Address:"), 	     
	     td( param('addr')) ,
	     td("Notes:"), 	     
	     td( param('notes')) ),
	  TR(td("Question:"), 	     
	     td( param('s_question')) ,
	     td("Answer:"), 	     
	     td( param('s_answer')) ),
	  TR(td("POP3-Server1:"),     
	     td( param('pop3server1')) ,
	     td("POP3-Account1:"),    
	     td( param('pop3account1')) ),
	  TR(td("POP3-Server2:"),     
	     td( param('pop3server2')) ,
	     td("POP3-Account2:"),    
	     td( param('pop3account2')) ),
	  TR(td("POP3-Server1:"),     
	     td( param('pop3server3')) ,
	     td("POP3-Account3:"),    
	     td( param('pop3account3')) ),
	  TR(td("WAP-Language:"),   
	     td( param('gui_lang')),
	     td("WAP-Font:"),  
	     td( param('gui_font')) ),
	  TR(td("default Mail Filter Type:"),   
	     td( $texts{param('fi_global')} ),
	     td(""),  
	     td("") ),
	 );

  # update DB entry
  $R = M_user::update_rec($UserDbh, param('id'), map { param($_) } @UserDbFields );

  print "<br>update ok<br>\n" if $debug;

  print "<br>data changed \n";
  #-- update TimeStamp 
  M_session::updateSessID( $SessDbh, $sessID);

  # syslog:
  syslog( LOG_INFO, "data for user $user changed.") if $logit;



#-- query new user data, insert-button 
} else {

  #- default language for new user: EN (english)
  my $tmp_langRef = M_languages::getLanguageHashRef('EN');
  my $tmp_fontRef = M_messages::getSizesHashRef('EN');


  print "<h1>Zwap member registration</h1>\n";
  print "<h3>Fields marked ${required_marker} are required!</h3>";

  print start_form( -method => "post"), 
  table({"border" => 1},
 
	TR(td("${required_marker}Account name:"), 
	   td(textfield(-name => 'ZWAPuser')),
	   td("${required_marker}Password:"), 
	   td(password_field(-name => 'ZWAPpw'))),
	TR(td("Firstname:"), 
	   td(textfield(-name => 'fname')),
	   td("${required_marker}Family name:"), 
	   td(textfield(-name => 'lname'))),
	TR(td("Phone:"), 
	   td(textfield(-name => 'phone')),
	   td("${required_marker}Email:"), 
	   td(textfield(-name => 'email'))),
	TR(td("Address:"), 
	   td(textarea(-name => 'addr', -rows => 3)),
	   td("Notes:"), 
	   td(textarea(-name => 'notes', -rows => 3))),
	TR(td("Question:"), 
	   td(textfield(-name => 's_question')),
	   td("Answer:"), 
	   td(textfield(-name => 's_answer'))),
	TR(td("${required_marker}POP3-Server1:"), 
	   td(textfield(-name => 'pop3server1')),
	   td("${required_marker}POP3-Account1:"), 
	   td(textfield(-name => 'pop3account1'))),
	TR(td("POP3-Server2:"), 
	   td(textfield(-name => 'pop3server2')),
	   td("POP3-Account2:"), 
	   td(textfield(-name => 'pop3account2'))),
	TR(td("POP3-Server3:"), 
	   td(textfield(-name => 'pop3server3')),
	   td("POP3-Account3:"), 
	   td(textfield(-name => 'pop3account3'))),
	TR(td("WAP-Language:"),   
	   td( scrolling_list( 
			      -name => 'gui_lang', 
			      -values => [eval($tmp_languages)],
			      -labels => $tmp_langRef,
			      -default => $lang_code,
			      -size    => 1
			     )), 
	   td("WAP-Font:"),  
	   td( scrolling_list(
			      -name => 'gui_font',
			      -values => [eval($tmp_fonts)],
			      -labels => $tmp_fontRef,
			      -default => $font_code,
			      -size    => 1
			     )) ),

	TR(td("default Mail Filter Type:"),   
	   td( scrolling_list( 
			      -name => 'fi_global', 
			      -values => ['X','I','N'],
			      -labels => $textsRef,
			      -default => 'N',
			      -size    => 1
			     )), 
	   td(""),  
	   td("") ),
	
       );
  
  print submit(-name  => 'insert', 
	       -value => 'Register user');
  
  print end_form();
}

print end_html();

M_user::disconnectDB( $UserDbh );

#--- close connection syslog
closelog() if $logit;
       
#------------------ END --------------------------------

#-----------------------------------------------------------
#--  message "session not active"
sub no_session {
  my ($sessID) = @_;

  print header(), start_html(-BGCOLOR=>'#FFFFFF') ;
  M_tools::print_file($no_session_message);
  M_tools::print_file($mail_message);
  print end_html();
}


#-- send info mail ( new user registered, user account deleted)
sub sendMail2 {
  my ($to, $from, $subj,$content) = @_;

  if ( $to ne "") {
    my (@mail_header, @mail_body);
    @mail_header = (
		    "To: $to \n",
		    "From: $from \n",
		    "Reply-To: webmaster\@zwap.de \n",
		    "Subject: $subj \n",
		    "\n\n"                              # end of headers
		   );
    @mail_body = (
		  "$content"
		 );
    
    #- send mail: sendmail or smtp 
    if ($use_smtp) {
      
      $smtp = Net::SMTP->new($SMTP_server);
      if($smtp) {
	$smtp->mail($from);
	$smtp->to($to);
	
	$smtp->data();
	foreach $line (@mail_header) {
#print STDERR "head: $line \n";
	  $smtp->datasend($line);
	}
	foreach $line (@mail_body) {
#print STDERR "body: $line \n";
	  $smtp->datasend($line);
	}
	$smtp->dataend();
	$smtp->quit();
	
	return 1;
	
      }
    } else {
      open (MAIL,"| ${path2sendmail} ${sendmail_options}") ||
	die "Error: Can't start mail program";
      
      foreach $line (@mail_header) {
	print MAIL "$line";
      }
      foreach $line (@mail_body) {
	print MAIL "$line";
      }
      print MAIL "\n.\n";    # end of mail

      close(MAIL);
      
      return (1);
    }
  } else {
    return(0);
  }
}


#-- send registry acknowledge mail to user
sub sendAck2User {
  my ($to, $from) = @_;

  if ( $to ne "") {
    my (@mail_header, @mail_body);
    @mail_header = (
		    "To: $to \n",
		    "From: $from \n",
		    "Reply-To: webmaster\@zwap.de \n",
		    "Subject: Welcome to Zwap! \n",
		    "\n\n"                            # end of headers
		   );
    
    @mail_body = (
		  "Welcome ". param('fname') . " " . param('lname') . "! \n\n",
		  
		  "You are registered to Zwap with:"        . "\n\n",
		  "Account name : " . param('ZWAPuser')     . "\n",
#		  "Password     : " . param('ZWAPpw')       . "\n",
		  "Password     : " . "**SECRET NOT SHOWN**" . "\n",
		  "Firstname    : " . param('fname')        . "\n", 
		  "Family name  : " . param('lname')        . "\n",
		  "Phone        : " . param('phone')        . "\n",
		  "Email        : " . param('email')        . "\n",
		  "Question     : " . param('s_question')   . "\n", 
		  "Answer       : " . param('s_answer')     . "\n",
		  "POP3-Server1 : " . param('pop3server1')  . "\n", 
		  "POP3-Account1: " . param('pop3account1') . "\n",
		  "POP3-Server2 : " . param('pop3server2')  . "\n", 
		  "POP3-Account2: " . param('pop3account2') . "\n",
		  "POP3-Server3 : " . param('pop3server3')  . "\n", 
		  "POP3-Account3: " . param('pop3account3') . "\n",
		  "WAP-Language : " . param('gui_lang')     . "\n", 
		  "WAP-Font     : " . param('gui_font')     . "\n",
		  "default Mail Filter Type: " . $texts{param('fi_global')} . "\n\n",
		  "Address:       " . "\n" . param('addr')        . "\n\n",
		  "Notes:         " . "\n" . param('notes')       . "\n\n",
		  "\n--\n",
		  "***    www.zwap.de    ***\n",
		  "**  webmaster\@zwap.de  **\n",
		  "* email2wml transformer *\n"
		 );
    
    
    #- send mail: sendmail or smtp 
    if ($use_smtp) {
      
      $smtp = Net::SMTP->new($SMTP_server);
      if($smtp) {
	$smtp->mail($from);
	$smtp->to($to);
	
	$smtp->data();
	foreach $line (@mail_header) {
	  #print STDERR "head: $line \n";
	  $smtp->datasend($line);
	}
	foreach $line (@mail_body) {
	  #print STDERR "body: $line \n";
	  $smtp->datasend($line);
	}
	$smtp->dataend();
	$smtp->quit();
	
	return 1;

      }
    } else {
      open (MAIL,"| ${path2sendmail} ${sendmail_options}") ||
	die "Error: Can't start mail program";
      
      foreach $line (@mail_header) {
	print MAIL "$line";
      }
      foreach $line (@mail_body) {
	print MAIL "$line";
      }
      print MAIL "\n.\n";    # end of mail
      
      close(MAIL);
      
      return(1);
    }
  } else {
    return(0);
  }
}


#---------
sub logged_off  {
  M_tools::print_file($logoff_message);
  M_tools::print_file($mail_message);
}

#---------
sub user_deleted  {
  M_tools::print_file($bye_message);
  M_tools::print_file($mail_message);
}


#-----------------------------------------------------------
 


