#!/usr/bin/perl -w
#
#  Copyright (c) 2000 Reinhold Klapsing and Martin Rueschoff
# 
#  Reinhold Klapsing, Email: Reinhold.Klapsing@uni-essen.de
#  Martin Rueschoff,  Email: Martin.Rueschoff@uni-essen.de
# 
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Library General Public
#  License as published by the Free Software Foundation; either
#  version 2 of the License, or (at your option) any later version.
# 
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
# 
#  You should have received a copy of the GNU Library General Public
#  License along with this library; if not, write to the
#  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.
#
 
use CGI qw/:standard :html3/;
use CGI::Carp qw/fatalsToBrowser/;


require "../shared_modules/M_session.pm";
require "M_tools.pm";
require "html_interface.cfg";

#-----------------------------------------------
my $debug = 0;

#-----------------------------------------------

my $lang_code = "EN";     # actual language, must be fetched from userDB

#-----------------------------------------------
my $no_session_message = $html_interface_config::mess_closed;
my $mail_message       = $html_interface_config::mess_mail;



#--- for SessionDB
my $SessDB_DIR      = "../databases/ZWap-SessionKeys";
my $SessDB_DSN      = "DBI:CSV:f_dir=$SessDB_DIR";
my $SessDB_USER     = "";
my $SessDB_PASSWD   = "";

#-- create connection to Session-database  
my $SessDbh = M_session::connectDB(
				   $SessDB_DSN, 
				   $SessDB_USER, 
				   $SessDB_PASSWD
				  ) 
  or die "Cannot connect to sessionDB";


#-- find sessID  ---------------
my $sessID = $ENV{"PATH_INFO"};
$sessID =~ s#^/+(.*)#$1#;     # fuehrende / ab
my $sessIDvalid = M_session::validID( $SessDbh, $sessID);


#-- there is no active session ---------
if ( $sessIDvalid == 0) {
  no_session( $sessID);
  exit;
}
#--------------------------------
# get UserID from Session
my $user = M_session::getIDFromSession( $SessDbh, $sessID);

#--------------------------------


#-- let's start 
print header(), start_html(-BGCOLOR=>'#FFFFFF');


print_menu( $sessID, $user );


#---
print end_html();


#-- update TimeStamp 
M_session::updateSessID( $SessDbh, $sessID);

M_session::disconnectDB( $SessDbh );

       
#------------------ END --------------------------------

#-----------------------------------------------------------
#--  message "session not active"
sub no_session {
  my ($sessID) = @_;

  print header(), start_html(-BGCOLOR=>'#FFFFFF') ;
  M_tools::print_file($no_session_message);
  M_tools::print_file($mail_message);
  print end_html();
}

#--- create config-menu  ------------------
sub print_menu {

  my ($sessID,$ID) = @_;

  print h1("Configuration");
  print h3("User:&nbsp;&nbsp; $ID");

  #- new browser window for help
  print "<a href=\"/zwap/html_interface/help.html\" target=\"_blank\">Help</a>\n";
  print "<br><br>\n";

  print "<a href=\"/zwap/html_interface/Z_registration.pl/${sessID}?user=${ID}&edit=1\" target=\"config_content\">Change Registry Data</a>\n";
  print "<br><br>\n";
  print "<a href=\"/zwap/html_interface/Z_instantext.pl/${sessID}?user=${ID}\" target=\"config_content\">Edit InstanText</a>\n";
  print "<br><br>\n";
  print "<a href=\"/zwap/html_interface/Z_aliases.pl/${sessID}?user=${ID}\" target=\"config_content\">Edit Mail Aliases</a>\n";
  print "<br><br>\n";
  print "<a href=\"/zwap/html_interface/Z_filters.pl/${sessID}?user=${ID}\" target=\"config_content\">Edit Mail Filters</a>\n";
  print "<br><br>\n";

  print "<a href=\"/zwap/html_interface/Z_signature.pl/${sessID}?user=${ID}\" target=\"config_content\">Edit Mail Signature</a>\n";
  print "<br><br>\n";

  print "<a href=\"/zwap/html_interface/Z_registration.pl/${sessID}?user=${ID}&logoff=1\" target=\"main\"><font color=\"red\">Logoff</font></a>\n";
  print "<br><br><hr>\n";
  print "<a href=\"/zwap/html_interface/Z_registration.pl/${sessID}?user=${ID}&delete=1\" target=\"main\"><font color=\"red\">Delete Account</font></a>\n";

}


#-----------------------------------------------------------
 


