#
#  Copyright (c) 2000 Reinhold Klapsing and Martin Rueschoff
# 
#  Reinhold Klapsing, Email: Reinhold.Klapsing@uni-essen.de
#  Martin Rueschoff,  Email: Martin.Rueschoff@uni-essen.de
# 
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Library General Public
#  License as published by the Free Software Foundation; either
#  version 2 of the License, or (at your option) any later version.
# 
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
# 
#  You should have received a copy of the GNU Library General Public
#  License along with this library; if not, write to the
#  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.
#


package M_languages;



# ein hash aus hashes
my %languages = (
		
	    EN => {                      # englisch
		   EN    => "english",
		   DE    => "german",
		   ES    => "spanish",
		  },
	    
	    DE => {                      # deutsch
		   EN    => "englisch",
		   DE    => "deutsch",
		   ES    => "spanisch",
		  },
	    
#	    ES => {                      # spanisch
#		   EN    => "ingles",
#		   DE    => "aleman",
#		   ES    => "espanol",
#		  },
	    
	   );


#----------------------------
# returns string containing language identifiers
sub getLanguages {
  my $lang = "";
  foreach $l (keys %languages) {
    $lang = $l . " ". $lang;
  }
  chop($lang);
  return ($lang);
}

#----------------------------
# returns referenz to hash containing names of languages 
sub getLanguageHashRef { 
  my ($lcode) = @_;
  return($languages{$lcode});
}


#----------------------------
1;
#----------------------------




