/**************************************************/
/* Listet alle Terminals und Karten im System auf */
/*												  */
/* Autor: Kai-Uwe Mrkor							  */
/**************************************************/

#include <stdio.h>
#include <winscard.h>

int main( void)
{
	SCARDCONTEXT		hContext=0;
	SCARD_READERSTATE	KartenStatus;
	DWORD				groesse=0;
	char				*pLeser, *p, *pKarte;
	bool				istKarte;

	/* mit Context verbinden */
	if (SCardEstablishContext(SCARD_SCOPE_USER,0,0,&hContext) != SCARD_S_SUCCESS)
	{
		printf("SCardEstablishContext fehlgeschlagen\n");
		return 1;
	}

	/* Feldgre fr Terminal-Namen ermitteln */
	if (SCardListReaders(hContext,0,0,&groesse)!=SCARD_S_SUCCESS)
	{
		printf("SCardListReaders fehlgeschlagen\n");
		return 1;
	}
	pLeser=(char *)malloc(groesse);

	/* Terminal-Namen in das Feld legen */
	if (SCardListReaders(hContext,0, pLeser,&groesse)!=SCARD_S_SUCCESS)
	{
		printf("SCardListReaders fehlgeschlagen\n");
		return 1;
	}

	/* Ausgabe */
	printf("Ausgabe der zur Zeit am System angemeldeten Terminal- und Kartennamen.");
	for (p=pLeser; *p; p+=strlen(p)+1)
	{
		printf("\n\nTerminal-Name:\t%s\n",p); /* Kartenname ausgeben */

		/* Test ob eine Karte im Leser ist */
		KartenStatus.szReader=(char *)p;
		KartenStatus.dwEventState=SCARD_STATE_UNAWARE;
		if (SCardGetStatusChange(hContext,0,&KartenStatus,1)==SCARD_S_SUCCESS)
		{
			istKarte=((KartenStatus.dwEventState & SCARD_STATE_PRESENT)!=0);
			printf("Karte Gesteckt:\t%s\n",istKarte?"JA":"Nein");

			/* Ist eine Karte im Terminal? */
			if (istKarte)
			{
				printf("Kartenname:\t");

				/* Kartenname ermitteln  */
				if (SCardListCards(hContext, KartenStatus.rgbAtr,0,0,0,&groesse) 
					== SCARD_S_SUCCESS)
				{

					pKarte=(char *)malloc(groesse);
					if (SCardListCards(hContext, KartenStatus.rgbAtr,0,0,pKarte,&groesse) 
						== SCARD_S_SUCCESS)
					{
						if (*pKarte==NULL)
							printf("Kartentyp unbekannt");
						else
							printf("%s",pKarte);
					}
					free(pKarte);
				}
			} /* if (istKarte) */
		} /* if (SCardGetStatusChange */
	} /* for */

	if (SCardReleaseContext(hContext) != SCARD_S_SUCCESS)
		printf("Kontextfreigabe fehlgeschlagen\n");

	free(pLeser);
	return 0;
}