/**********************************/
/* CT-API ATR-Ausgabe 			  */
/*								  */
/* Kai-Uwe Mrkor                  */
/* 2000                           */
/**********************************/
#include <windows.h>

#include <stdio.h>
#include <conio.h>
#include "ctapi.h"


HINSTANCE	hDLL;			/* Handle auf die DLL */

/****************/
/* ldt die DLL */
/****************/
int load_ct( void)
{
 hDLL= LoadLibrary( (LPSTR)"ctapiw32.dll"); /* DLL-Name ist herstellerabhngig !!!*/
 if (hDLL==NULL)
 {
	printf("Die Datei ct32.dll wurde nicht gefunden!");
	return FALSE;
 }

 CT_init = (CTAPI_INIT)GetProcAddress( hDLL, "CT_init");
 CT_close= (CTAPI_CLOSE)GetProcAddress( hDLL, "CT_close");
 CT_data = (CTAPI_DATA)GetProcAddress( hDLL, "CT_data");

 return TRUE;
}


/*****************/
/* Hauptprogramm */
/*****************/
int main( void)
{
 unsigned char      sad, dad;       /* Quell- und Zieladresse */
 unsigned char      command[30];    /* Kommando-String */
 unsigned char      response[100];  /* Antwort-Speicher */
 unsigned short int cnr,            /* KartenTerminal-Nummer */
                    lenr,           /* Grenangabe Antwortpuffer */
                    lenc;           /* Grenangabe Kommando */
 char               ret;            /* Rckgabewert der Funktion */
 int                i;

 /*                              CLA   INS   P1    P2    LEN */
 unsigned char RESET_ICC1[]=	{0x20, 0x11, 0x01, 0x01, 00}; 

 if (!load_ct())
	 return -1;

 /* Initialisierung */
 cnr=0;                 /* TerminalNummer=0 */
 ret=CT_init(cnr,2);    /* Verbindung mit COM2 herstellen */
 if (ret != OK)
 {
     printf("Kartenterminal konnte nicht initialisiert werden\n");
     exit(1);
 }

  /* Anforderung der Chipkarte */
 sad=2;                     /* Quelle = Host */
 dad=1;                     /* Ziel = Kartenterminal */
 lenc=sizeof(RESET_ICC1);	/* Gre der APDU ermitteln */
 lenr=sizeof(response);     /* Puffergre der Antwort-APDU */
 memcpy(command, RESET_ICC1, lenc);
 ret=CT_data(cnr, &dad, &sad, lenc, command, &lenr, response);
 if (ret != OK)
 {
     printf("RESET_ICC1 ist fehlgeschlagen!\n"); 
     return -1;										/**/
 }

 if (response[lenr-2]==0x90 && (response[lenr-1]==0x01 || response[lenr-1]==0x00))
 {
	 printf("ATR:\n----\n");
	 for (i=0; i<lenr-2; i++) /* Ausgabe der ATR */
	   printf("%.2Xh ",response[i]);

 }
 else
    printf("Fehler beim Kartenzugriff!\n");

 /* Freigabe */
 ret=CT_close(cnr);
 FreeLibrary(hDLL);

 return 0;
}
