//Titel:        Mail-Client
//Version:      0.99
//Copyright:    Copyright (c) 2000
//Autor:        Christoph Borowski, cb@ordix.de
//Firma:        ORDIX AG, www.ordix.de, Westernmauer 12-16, 33098 Paderborn
//Beschreibung: Beispielanwendung, die die JavaMail-API einsetzt.

package mail.view;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.io.*;

import mail.model.*;

/**
  * Die Klasse implementiert das Fenster zum Erstellen
  * und Versenden von e-Mails. 
  */
public class SendFrame extends JFrame
						            implements ActionListener {
	JButton		sendButton = new JButton("Senden");
	JButton		clearButton = new JButton("Lschen");
	JButton		attachmentButton = new JButton("...");
	
	JLabel		recipientLabel = new JLabel("Empfnger:");
	JLabel		subjectLabel = new JLabel("Betreff:");
	JLabel		attachmentLabel = new JLabel("Anhang:");
	JLabel		messageLabel = new JLabel("Mailtext:");
	
	JTextField	recipientField = new JTextField();
	JTextField	subjectField = new JTextField();
	JTextField	attachmentField = new JTextField();
	
	JTextArea	messageArea = new JTextArea();
	
	File		attachment;
	
	/**
	  * Konstruktor, der das Sendefenster erzeugt.
	  */
	public SendFrame() {
		getContentPane().add(getMessagePanel(), BorderLayout.CENTER);
		getContentPane().add(getButtonPanel(), BorderLayout.SOUTH);

		// Fenster darf nicht geschlossen werden
		setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);

		// Titel und Gre des Fensters festlegen
		setTitle("Mail senden");
		setSize(400, 300);
	}

	/**
	  * Liefert die JScrollPane zurck, die die Textfelder fr
    * die Eingabe des Empfngers, des Betreffs, des Anhangs
    * und Mailtextes enthlt.
	  */
	private JPanel getMessagePanel() {
		JPanel panel = new JPanel(new BorderLayout());
		
		GridBagLayout gridbag = new GridBagLayout();
		GridBagConstraints c_label = new GridBagConstraints();
		GridBagConstraints c_field = new GridBagConstraints();

		c_label.gridwidth = 1;		
		c_label.gridheight = 1;
		c_label.anchor = GridBagConstraints.WEST;
		c_label.insets = new Insets(0, 0, 0, 10);

		c_field.gridwidth = GridBagConstraints.REMAINDER;
		c_field.gridheight = 1;
		c_field.anchor = GridBagConstraints.WEST;
		c_field.fill = GridBagConstraints.HORIZONTAL;
		c_field.weightx = 1;
		
		JPanel panel1 = new JPanel(gridbag);
		panel1.setBorder(BorderFactory.createEmptyBorder(5,5,0,5));
		
		gridbag.setConstraints(recipientLabel, c_label);
		panel1.add(recipientLabel);
		gridbag.setConstraints(recipientField, c_field);
		panel1.add(recipientField);
		
		gridbag.setConstraints(subjectLabel, c_label);
		panel1.add(subjectLabel);
		gridbag.setConstraints(subjectField, c_field);
		panel1.add(subjectField);
		
		attachmentButton.addActionListener(this);
		gridbag.setConstraints(attachmentLabel, c_label);
		panel1.add(attachmentLabel);
		gridbag.setConstraints(attachmentButton, c_label);
		panel1.add(attachmentButton);
		gridbag.setConstraints(attachmentField, c_field);
		panel1.add(attachmentField);
		attachmentField.setEditable(false);
		
		gridbag.setConstraints(messageLabel, c_field);
		panel1.add(messageLabel);
		
		messageArea.setLineWrap(true);
		messageArea.setWrapStyleWord(true);
		JScrollPane scrollPane = new JScrollPane(messageArea);
		
		panel.add(panel1, BorderLayout.NORTH);
		panel.add(scrollPane, BorderLayout.CENTER);
		return panel;
	}
	
	/**
	  * Erzeugt das JPanel mit den zwei Button Senden und Lschen.
	  */
	private JPanel getButtonPanel() {
		// JPanel erzeugen
		JPanel panel = new JPanel(new BorderLayout());
    JPanel panel1 = new JPanel();

    // Tastaturkrzel fr die Buttons setzen
    sendButton.setMnemonic('S');
    clearButton.setMnemonic('L');

		// Fenster als Listener bei den Button anmelden
		sendButton.addActionListener(this);
		clearButton.addActionListener(this);

		// Button zum JPanel panel1 hinzufgen
		panel1.add(sendButton);
		panel1.add(clearButton);

    panel.add(panel1, BorderLayout.CENTER);
    panel.add(new JLabel(new ImageIcon("logo.gif")), BorderLayout.EAST);
		
		return panel;
	}
	
	/**
	  * ActionListener-Methode zur Behandlung der ActionEvents
    * der Buttons attachmentButton, sendButton und clearButton.
	  */
	public void actionPerformed(ActionEvent ae) {
		if (ae.getSource() == attachmentButton) {
			// Dateidialog ffnen, um die Anlagedatei auszuwhlen
			JFileChooser fc = new JFileChooser();
			int returnVal = fc.showOpenDialog(this);
			if (returnVal == JFileChooser.APPROVE_OPTION) {
				// Benutzer hat Datei ausgewhlt, also Auswahl merken
				attachment = fc.getSelectedFile();
				// Datei samt Pfad im Anlagetextfeld anzeigen
				attachmentField.setText(attachment.getAbsolutePath());
			} else {
				// Benutzer hat keine Datei ausgewhlt, also Anlagetextfeld lschen
				attachmentField.setText(null);
				attachment = null;
			}
			return;
		}
		if (ae.getSource() == sendButton) {
			// e-Mail senden
			Thread worker = new Thread() {
				public void run() {
					// MailSender-Objekt erzeugen und gleichzeitig mit 
					// den eingegebenen Daten initialisieren
					MailSender ms = new MailSender(
						MailOptions.get().getFromAddress(),
						recipientField.getText(), 
						attachment,
						subjectField.getText(), 
						messageArea.getText(), 
						MailOptions.get().getMailServerOut());

					// MailSender-Objekt anweisen, die e-Mail zu senden
		    		ms.sendMessage();
				}
			};
			worker.start();
			return;
		}
		if (ae.getSource() == clearButton) {
			// Alle eingabefelder werden gelscht
			subjectField.setText(null);
			recipientField.setText(null);
			messageArea.setText(null);
		}
	}
}