//Titel:        Mail-Client
//Version:      0.99
//Copyright:    Copyright (c) 2000
//Autor:        Christoph Borowski, cb@ordix.de
//Firma:        ORDIX AG, www.ordix.de, Westernmauer 12-16, 33098 Paderborn
//Beschreibung: Beispielanwendung, die die JavaMail-API einsetzt.

package mail.view;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.io.*;

import mail.model.*;

/**
  * Dialog zum ndern der Anwendungseinstellungen. Diese sind
  * der Postaushang (SMTP), der Posteingang (POP3), die Kennung, 
  * das Kennwort und die Absenderadresse.
  */
public class OptionsDialog extends JDialog
{
	JButton okButton = new JButton("bernehmen");
	JButton cancelButton = new JButton("Abbrechen");
	OptionsActionListener oal = new OptionsActionListener();
	
	JLabel mailServerOutLabel = new JLabel("Postausgang (SMTP) :");
	JLabel mailServerInLabel = new JLabel("Posteingang (POP3) :");
	JLabel loginLabel = new JLabel("Kennung :");
	JLabel passwordLabel = new JLabel("Kennwort :");
	JLabel fromAddressLabel = new JLabel("Absenderadresse :");
	
	JTextField mailServerOutField = new JTextField();
	JTextField mailServerInField = new JTextField();
	JTextField loginField = new JTextField();
	JPasswordField passwordField = new JPasswordField();
	JTextField fromAddressField = new JTextField();
	
	MailOptions options = MailOptions.get();
	
	/**
	  * Konstruktor, der den Dialog erzeugt.
	  */
	public OptionsDialog(JFrame owner, String title) {
		super(owner, title, true);
		// Oberflche aufbauen
		getContentPane().add(getOptionPanel(), BorderLayout.CENTER);
		getContentPane().add(getButtonPanel(), BorderLayout.SOUTH);
		
		// Eingabefelder mit den Einstellungen aus dem 
		// MailOptions-Objekt vorbelegen
		fromAddressField.setText(options.getFromAddress());
		mailServerOutField.setText(options.getMailServerOut());
		loginField.setText(options.getLogin());
		passwordField.setText(options.getPassword());
		mailServerInField.setText(options.getMailServerIn());
		
		// Gre des Dialogs festlegen
		setSize(350, 180);
		// Dialog auf den Bildschirm bringen
		setVisible(true);
	}

	/**
	  * Liefert das JPanel mit den Eingabefeldern fr
    * die Einstellungen.
	  */
	private JPanel getOptionPanel() {
		GridBagLayout gridbag = new GridBagLayout();
		GridBagConstraints c_label = new GridBagConstraints();
		GridBagConstraints c_field = new GridBagConstraints();

		JPanel panel = new JPanel(gridbag);
		panel.setBorder(BorderFactory.createEmptyBorder(5,5,0,5));

		c_label.gridwidth = 1;		
		c_label.gridheight = 1;
		c_label.anchor = GridBagConstraints.WEST;
		c_label.insets = new Insets(0, 0, 0, 10);

		c_field.gridwidth = GridBagConstraints.REMAINDER;
		c_field.gridheight = 1;
		c_field.anchor = GridBagConstraints.WEST;
		c_field.fill = GridBagConstraints.HORIZONTAL;
		c_field.weightx = 1;
	
		gridbag.setConstraints(mailServerInLabel, c_label);
		panel.add(mailServerInLabel);
		gridbag.setConstraints(mailServerInField, c_field);
		panel.add(mailServerInField);

		gridbag.setConstraints(mailServerOutLabel, c_label);
		panel.add(mailServerOutLabel);
		gridbag.setConstraints(mailServerOutField, c_field);
		panel.add(mailServerOutField);

		gridbag.setConstraints(loginLabel, c_label);
		panel.add(loginLabel);
		gridbag.setConstraints(loginField, c_field);
		panel.add(loginField);

		gridbag.setConstraints(passwordLabel, c_label);
		panel.add(passwordLabel);
		gridbag.setConstraints(passwordField, c_field);
		panel.add(passwordField);

		gridbag.setConstraints(fromAddressLabel, c_label);
		panel.add(fromAddressLabel);
		gridbag.setConstraints(fromAddressField, c_field);
		panel.add(fromAddressField);

		return panel;
	}
	
	/**
	  * Erzeugt das JPanel mit den zwei Buttons bernehmen
    * und Abbrechen.
	  */
	private JPanel getButtonPanel() {
		// JPanel erzeugen
		JPanel panel = new JPanel();

    okButton.setMnemonic('b');
    cancelButton.setMnemonic('A');
		
		// Dialog als Listener bei den Button anmelden
		okButton.addActionListener(oal);
		cancelButton.addActionListener(oal);
		
		// Button zum JPanel hinzufgen
		panel.add(okButton);
		panel.add(cancelButton);

		return panel;
	}

	/**
	  * Innere Klasse, die den ActionListener zur Behandlung der
    * ActionEvents der beiden Buttons okButton und cancelButton
    * implementiert.
	  */
	class OptionsActionListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			if (e.getSource() == okButton) {
				// berprfen, ob alle Eingabefelder belegt sind
				if (!mailServerOutField.getText().trim().equals("")
					&& !mailServerInField.getText().trim().equals("")
					&& !loginField.getText().trim().equals("")
					&& !new String(passwordField.getPassword()).trim().equals("")
					&& !fromAddressField.getText().trim().equals(""))
				{
					// Einstellungen in dem MailOptions-Objekt setzen
					options.setMailServerOut(mailServerOutField.getText());
					options.setMailServerIn(mailServerInField.getText());
					options.setLogin(loginField.getText());
					options.setPassword(new String(passwordField.getPassword()));
					options.setFromAddress(fromAddressField.getText());
					
					// Einstellungen des MailOptions-Objekt speichern
					options.saveOptions();
					
					// Dialog schlieen
					dispose();
				} else {
					// Nicht alle Einstellungen wurden gemacht, 
					// also Benutzer informieren
					JOptionPane message = new JOptionPane();
					message.showMessageDialog(null, 
						"Sie mssen den Mail-Server und die Absenderadresse angeben!",
						"Fehlende Einstellungen",
						JOptionPane.INFORMATION_MESSAGE);
				}
			}
			if (e.getSource() == cancelButton) {
				// Dialog schlieen
				dispose();
			}
		}
	}
}