//Titel:        Mail-Client
//Version:      0.99
//Copyright:    Copyright (c) 2000
//Autor:        Christoph Borowski, cb@ordix.de
//Firma:        ORDIX AG, www.ordix.de, Westernmauer 12-16, 33098 Paderborn
//Beschreibung: Beispielanwendung, die die JavaMail-API einsetzt.

package mail.model;

import java.io.*;
import java.util.*;

/**
  * Die Klasse MailOptions verwaltet die Benutzereinstellungen
  * Postaushang (SMTP), Posteingang (POP3), Benutzerkennung,
  * Benutzerkennwort und Absenderadresse in einem Properties-Objekt,
  * welches persistent in der Datei options.mml abgespeichert wird.
  */
public class MailOptions {
	
	private Properties appProperties = new Properties();
	static private MailOptions options;
	
	// Datei, in der die Einstellungen gespeichert werden.
	static private String fileName = "options.mml";

	/**
	  * Klasse implementiert das Design-Pattern Singleton.
	  */
	static public MailOptions get() {
		if (options == null) {
			options = new MailOptions();
			options.loadOptions();
		}
		return options;
	}
	
	/**
	  * Liefert die Absenderadresse zurck.
	  */
	public String getFromAddress() {
		return appProperties.getProperty("fromAddress");
	}

	/**
	  * Setzt die Absenderadresse.
	  */
	public void setFromAddress(String fromAddress) {
		appProperties.put("fromAddress", fromAddress);
	}

	/**
	  * Liefert das Login zurck.
	  */
	public String getLogin() {
		return appProperties.getProperty("login");
	}

	/**
	  * Setzt das Login.
	  */
	public void setLogin(String login) {
		appProperties.put("login", login);
	}

	/**
	  * Liefert das Passwort zurck.
	  */
	public String getPassword() {
		return appProperties.getProperty("password");
	}

	/**
	  * Setzt das Passwort.
	  */
	public void setPassword(String password) {
		appProperties.put("password", password);
	}

	/**
	  * Liefert den Mailserver fr den Postausgang zurck.
	  */
	public String getMailServerOut() {
		return appProperties.getProperty("mailServerOut");
	}

	/**
	  * Setzt den Mailserver fr den Postausgang.
	  */
	public void setMailServerOut(String mailServer) {
		appProperties.put("mailServerOut", mailServer);
	}

	/**
	  * Liefert den Mailserver fr den Posteingang zurck.
	  */
	public String getMailServerIn() {
		return appProperties.getProperty("mailServerIn");
	}

	/**
	  * Setzt den Mailserver fr den Posteingang.
	  */
	public void setMailServerIn(String mailServer) {
		appProperties.put("mailServerIn", mailServer);
	}

	/**
	  * Sichert die Anwendungseinstellungen in die Datei options.mml.
	  */
	public void saveOptions() {
		try {
			FileOutputStream fos = new FileOutputStream(fileName);
			appProperties.store(fos, "Mail-Options");
			fos.flush();
			fos.close();
		} catch (IOException e) {
			System.out.println("Fehler IOException: "+e.getMessage());
		}
	}
	
	/**
	  * Ld die Anwendungseinstellungen aus der Datei options.mml.
	  */
	public boolean loadOptions() {
		try {
			FileInputStream fis = new FileInputStream(fileName);
			appProperties.load(fis);
			fis.close();
		} catch (IOException e) {
			System.out.println("Fehler IOException: "+e.getMessage());
			return false;
		}
		return true;
	}
}