unit D3DRMiniTexU;  // 09-NOV-99 as (Arne Schpers)
// Minimalistische 3DRM-Demo: Wrfelseiten mit individuellen
// Texturen und/oder Farben; entspricht bis auf die Methode
// BuildScene dem Programm D3DRMini.

{$DEFINE DIRECTX7}
interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, DXTimer, // schneller Timer
{$IFDEF DIRECTX7}  // DX7-Header (Direct3DRM seit 13-JAN-00)
  DirectDraw, Direct3D, Direct3DRM;
{$ELSE}  // DX6-Header
  DDraw,D3D,D3DTypes,D3DCaps,D3DRM,D3DRmDef,D3DRMObj,D3DRMWin;
{$ENDIF}

type
  TD3DRMiniForm = class(TForm)
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormPaint(Sender: TObject);
  private  // 50 Fortschreibungen pro Sekunde
    DXTimer: TDXTimer;
    procedure OnDXTimer(Sender: TObject);
  private  // Direct3DRM-Schnittstellen
    D3dInitialized: Boolean;
    D3DDevGUID: TGUID;  // GUID des (HAL-)Treibers
    Device: IDirect3DRMDevice3;
    D3DRMInterface: IDirect3DRM3;
    View: IDirect3DRMViewPort2;
    Scene, Camera: IDirect3DRMFrame3;
  protected
    function InitD3DInterfaces: Boolean;
    function BuildScene:Boolean;
    function RenderScene:Boolean;
  end;

var D3DRMiniForm: TD3DRMiniForm;

implementation
{$R *.DFM}

function CheckRes(Res: HResult; ErrMsg: String): Boolean;
begin  // Makro, sozusagen
  Result := SUCCEEDED(Res);
  if not Result then ShowMessage('Fehler bei: '+ErrMsg);
end;

// D3D-Treiber abzhlen, Clipper und D3DRM-Schnittstellen anlegen
function TD3DRMiniForm.InitD3DInterfaces: Boolean;
var D3DRMTemp: IDirect3DRM;  // Urversion
    DDrawClipper: IDirectDrawClipper;

  // Rckruf beim Abzhlen der D3D-Gerte bzw. Treiber; bricht ab,
  // sobald der erste Hardware-Treiber gemeldet wird
  function EnumDevicesCallback(const lpGuid: TGUID;
     lpDeviceDescription, lpDeviceName: LPSTR;
     const lpD3DHWDeviceDesc, lpD3DHELDeviceDesc: TD3DDeviceDesc;
        lpUserArg: Pointer) : HResult; stdcall;
  begin
    if Assigned(@lpGUID) then PGUID(lpUserArg)^ := lpGuid;
    if lpD3DHWDeviceDesc.dcmColorModel = D3DCOLOR_RGB
      then Result := DDENUMRET_CANCEL  // OK, ende
      else Result := DDENUMRET_OK;  // weitermachen
  end;

  // DirectDraw-Schnittstelle anlegen, dort nach IDirect3D fragen,
  // IDirect3D zum Abzhlen der Gerte verwenden, danach beide
  // Schnittstellen (automatisch) wieder freigeben
  function Enum3DDevices(var D3DDevGuid: TGuid): Boolean;
  var DDrawObject: IDirectDraw; D3DObject: IDirect3D;
  begin
    Result := SUCCEEDED(DirectDrawCreate(nil, DDrawObject, nil))
     and SUCCEEDED(DDrawObject.QueryInterface(IID_IDirect3D,
       D3DObject)) and SUCCEEDED(D3DObject.EnumDevices
        (@EnumDevicesCallback, @D3DDevGUID));
  end;

begin
  Result := False;

  // DirectD3DRM-Schnittstelle (Urversion), Abfrage nach RM3
  if not CheckRes(Direct3DRMCreate(D3DRMTemp),
    'Direct3DRM-Schnittstelle anlegen')
   or not CheckRes(D3DRMTemp.QueryInterface(IID_IDirect3DRM3,
     D3DRMInterface),' QueryInterface nach RM3') then Exit;

  // DirectDrawClipper-Objekt anlegen, mit dem Fenster verbinden
  if not CheckRes(DirectDrawCreateClipper(0, DDrawClipper, nil),
    'DirectDraw-Clipper anlegen')
   or not CheckRes(DDrawClipper.SetHWnd(0, Handle),
    'DirectDraw-Clipper mit Fenster verbinden') then Exit;

  // GUID des ersten HAL-Treibers abfragen. Das ginge auch
  // ohne die vorherige Initialisierung von D3DRM
  if not Enum3DDevices(D3DDevGUID) then Exit;

  // D3DRM-Gert ber den DirectDrawClipper anlegen. NIL anstelle
  // des GUIDs wre "HEL ramp" anstelle von "HAL"
  if not CheckRes(D3DRMInterface.CreateDeviceFromClipper(
    DDrawClipper, @D3DDevGUID, ClientWidth, ClientHeight,
    Device), 'CreateDeviceFromClipper') then Exit;

  // Master- (= Hintergrund) und Kamera-Frame anlegen
  if not CheckRes(D3DRMInterface.CreateFrame(nil, Scene),
    'CreateFrame fr den Hintergrund')
   or not CheckRes(D3DRMInterface.CreateFrame(Scene, Camera),
    'CreateFrame fr die Kamera') then Exit;

   // Hintergrundfarbe (hier: 128er-Grau), keine Fehlerprfung
   Scene.SetSceneBackgroundRGB(0.5, 0.5, 0.5);

   // Viewport anlegen, hier fr das gesamte Fenster
   // (GetWidth/GetHeight = ClientWidth/ClientHeight)
   Result := CheckRes(D3DRMInterface.CreateViewport(Device,
    Camera, 0, 0, Device.GetWidth, Device.GetHeight, View),
     'CreateViewport');
end;

function TD3DRMiniForm.BuildScene: Boolean;
var
  CubeMesh: IDirect3DRMMesh;
  CubeFrame, Lights: IDirect3DRMFrame3;
  Light1, Light2: IDirect3DRMLight;
  Material: IDirect3DRMMaterial2;
  CubeTex1, CubeTex2: IDirect3DRMTexture3;
  ProgPath: String;
  x: Integer;
const  // Elemente 0 bis 3 reichen im Prinzip
  CubeVertOrder: Array[0..23] of DWord =
    (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12,
     13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23);

  VertexList: Array[0..23] of TD3DRMVertex =
  ((Position:(x:0;y:0;z:0); Normal:(x:-1;y:0;z:0);
     tu:0; tv:1; Color:0), // Vertex 0: linke Seite
   (Position:(x:0;y:0;z:1); Normal:(x:-1;y:0;z:0);
     tu:0; tv:0; Color:0),
   (Position:(x:0;y:1;z:1); Normal:(x:-1;y:0;z:0);
     tu:1; tv:0; Color:0),
   (Position:(x:0;y:1;z:0); Normal:(x:-1;y:0;z:0);
     tu:1; tv:1; Color:0),
   (Position:(x:1;y:0;z:0); Normal:(x:-1;y:0;z:0);
     tu:0; tv:0; Color:0),  // Vertex 4: rechte Seite
   (Position:(x:1;y:1;z:0); Normal:(x:1;y:0;z:0);
     tu:1; tv:0; Color:0),
   (Position:(x:1;y:1;z:1); Normal:(x:1;y:0;z:0);
     tu:1; tv:1; Color:0),
   (Position:(x:1;y:0;z:1); Normal:(x:1;y:0;z:0);
     tu:0; tv:1; Color:0),
   (Position:(x:0;y:0;z:0); Normal:(x:0;y:0;z:-1);
     tu:0; tv:0; Color:0),  // Vertex 8: Vorderseite
   (Position:(x:0;y:1;z:0); Normal:(x:0;y:0;z:-1);
     tu:1; tv:0; Color:0),
   (Position:(x:1;y:1;z:0); Normal:(x:0;y:0;z:-1);
     tu:1; tv:1; Color:0),
   (Position:(x:1;y:0;z:0); Normal:(x:0;y:0;z:-1);
     tu:0; tv:1; Color:0),
   (Position:(x:0;y:0;z:1); Normal:(x:0;y:0;z:1);
     tu:0; tv:1; Color:0),  // Vertex 12: Rckseite
   (Position:(x:1;y:0;z:1); Normal:(x:0;y:0;z:1);
     tu:0; tv:0; Color:0),
   (Position:(x:1;y:1;z:1); Normal:(x:0;y:0;z:1);
     tu:1; tv:0; Color:0),
   (Position:(x:0;y:1;z:1); Normal:(x:0;y:0;z:1);
     tu:1; tv:1; Color:0),
   (Position:(x:0;y:1;z:0); Normal:(x:0;y:1;z:0);
     tu:0; tv:0; Color:0), // Vertex 16: Oberseite
   (Position:(x:0;y:1;z:1); Normal:(x:0;y:1;z:0);
     tu:1; tv:0; Color:0),
   (Position:(x:1;y:1;z:1); Normal:(x:0;y:1;z:0);
     tu:1; tv:1; Color:0),
   (Position:(x:1;y:1;z:0); Normal:(x:0;y:1;z:0);
     tu:0; tv:1; Color:0),
   (Position:(x:0;y:0;z:0); Normal:(x:0;y:-1;z:0);
     tu:0; tv:0; Color:0), // Vertex 20: Unterseite
   (Position:(x:1;y:0;z:0); Normal:(x:0;y:-1;z:0);
     tu:1; tv:0; Color:0),
   (Position:(x:1;y:0;z:1); Normal:(x:0;y:-1;z:0);
     tu:1; tv:1; Color:0),
   (Position:(x:0;y:0;z:1); Normal:(x:0;y:-1;z:0);
     tu:0; tv:1; Color:0));

var  // die mit AddGroup erzeugten Gruppen-IDs
  CubeGroup: Array[0..5] of TD3DRMGroupIndex;

begin
  Result := False; ProgPath := ExtractFilePath(ParamStr(0));
  // Render-Qualitt (in der Praxis wird da Gouraud draus)
  if not CheckRes(Device.SetQuality(D3DRMRENDER_PHONG),
    'SetQuality') then Exit;
  // Mesh, wird hier "zu Fu" mit Vertexen besetzt
  if not CheckRes(D3DRMInterface.CreateMesh(CubeMesh),
    'CreateMesh') then Exit;

{$IFDEF ONEGROUP}  // smtliche Vertexe auf einmal
  CubeMesh.AddGroup(24,6,4,CubeVertOrder[0],CubeGroup[0]);
  CubeMesh.SetVertices(CubeGroup[0], 0, 24, VertexList[0]);
{$ELSE}

  for x := 0 to 5 do
  begin
    if not CheckRes(CubeMesh.AddGroup(4,1,4,CubeVertOrder[0],
           CubeGroup[x]),'AddGroup') then Exit;
    if not CheckRes(CubeMesh.SetVertices(CubeGroup[x], 0, 4,
           VertexList[x*4]), 'SetVertices') then Exit;
  end;
  CubeMesh.SetGroupColorRGB(CubeGroup[0],1,0,0);
  CubeMesh.SetGroupColorRGB(CubeGroup[1],0,1,0);
  CubeMesh.SetGroupColorRGB(CubeGroup[2],0,0,1);
  CubeMesh.SetGroupColorRGB(CubeGroup[3],1,0,1);
  if CheckRes(D3DRMInterface.LoadTexture(PChar(ProgPath+
      'env2.bmp'),CubeTex1),'Load env2.bmp') then
  begin  // rote Ziegel
    CubeMesh.SetGroupTexture(CubeGroup[0],CubeTex1);
        // Ziegel + Wei -> Originalfarbe
    CubeMesh.SetGroupTexture(CubeGroup[4],CubeTex1);
  end;
  if CheckRes(D3DRMInterface.LoadTexture(PChar(ProgPath+
     'shine0.bmp'),CubeTex2),'Load shine0.bmp') then
  begin  // blauer Stern
    CubeMesh.SetGroupTexture(CubeGroup[2],CubeTex2);
        // Stern + Wei -> Originalfarbe
    CubeMesh.SetGroupTexture(CubeGroup[5],CubeTex2);
  end;
{$ENDIF}

  // Ursprung / Drehachse in der Mitte des Wrfels
  CubeMesh.Translate(-0.5, -0.5, -0.5);
  CubeMesh.Scale(2,2,2);  // 2,2,1 wre ein Quader

  // Das Gitternetz mit einem Material versehen (5.0 = Metall,
  // je hher, desto plastikartiger wird es), Farbe auf hellgrn
  if CheckRes(D3DRMInterface.CreateMaterial(35.0,Material),
    'CreateMaterial (fr den Wrfel)') then
  begin  // (schlgt bei ONEGROUP natrlich fehl - unkritisch)
    CubeMesh.SetGroupMaterial(CubeGroup[2],Material);
    CubeMesh.SetGroupMaterial(CubeGroup[3],Material);
  end;

  // Child-Frame in der Szene anlegen, Wrfel dort einsetzen
  if not CheckRes(D3DRMInterface.CreateFrame(Scene, CubeFrame),
    'CreateFrame (fr den Mesh)')
  or not CheckRes(CubeFrame.AddVisual(CubeMesh),
    'AddVisual (CubeMesh -> CubeFrame)') then Exit;

  // Kameraposition setzen. Objekte (= Frames) mit denselben X/Y-
  // Koordinaten wie die Kamera liegen sozusagen vor der Nase
  // des Benutzers, der Z-Wert bestimmt die Entfernung.
  Camera.SetPosition(Scene, 0, 0, -7);

  // Rotation an allen drei Achsen mit 0.01 Rad pro Frame.
  CubeFrame.SetRotation(Scene, 1,1,1, 0.01); // Pfannkucheneffekt

  // Beleuchtung. Positionierung geht wieder ber Frames
  // (und ist hier rechts neben der Kamera)
  if not CheckRes(D3DRMInterface.CreateFrame(Scene, Lights),
    'CreateFrame (fr die Beleuchtung)')
   or not CheckRes(Lights.SetPosition(Scene, 5, 0, -7),
    'SetPosition (fr die Beleuchtung)') then Exit;

  // Die erste Lichtquelle ist ein paralleles Punktlicht
  if CheckRes(D3DRMInterface.CreateLightRGB(
    D3DRMLIGHT_PARALLELPOINT, 1.0, 0.8, 0.9, Light1),
    'CreateLight fr Parallellicht') then Lights.AddLight(Light1);

  // 2. Lichtquelle ist eine gleichmige Umgebungshelligkeit
  if CheckRes(D3DRMInterface.CreateLightRGB(
    D3DRMLIGHT_AMBIENT, 0.1, 0.1, 0.1, Light2),
    'CreateLight fr Umgebung') then Lights.AddLight(Light2);

  // Eine dritte, gerichtete und bewegte Lichtquelle
  if CheckRes(D3DRMInterface.CreateLightRGB(
    D3DRMLIGHT_DIRECTIONAL, 1.0, 0.8, 0.9, Light1),
    'CreateLight fr gerichtetes Licht') then
  begin
    Lights.AddLight(Light1);    // Dir   Up
    Lights.SetOrientation(Scene, 0,0,1, 0,1,0);
     // Drehachse: 45 Grad in XYZ
    Lights.SetRotation(Scene, 1, 1, 1, 0.05);
  end;
  Result:=True;  // wunnebar...
end;


function TD3DRMiniForm.RenderScene: Boolean;
begin
  // Objekt(e) um 1 Frame bewegen. Scene.Move(1.0) ginge auch
  Result := CheckRes(D3DRMInterface.Tick(1.0),'Tick')
   // Viewport lschen
  and CheckRes(View.Clear(D3DRMCLEAR_ALL),'View.Clear')
  // Szene in den Viewport zeichnen
  and CheckRes(View.Render(Scene),'View.Render')
  // und Fenster aktualisieren
  and CheckRes(Device.Update,'Device.Update (RenderScene)');
end;

procedure TD3DRMiniForm.FormCreate(Sender: TObject);
begin
  Caption := 'D3DRM Minidemo, mit mehreren Texturen und Farben';
  ClientWidth := 400; ClientHeight := 300;
  D3DInitialized := InitD3DInterfaces;
  if D3DInitialized and BuildScene then
  begin
    DXTimer := TDXTimer.Create(Self);
    DXTimer.Interval := 20; DXTimer.OnTimer := OnDXTimer;
  end
    else PostQuitMessage(0);
end;

procedure TD3DRMiniForm.FormDestroy(Sender: TObject);
begin  // Die Reihenfolge spielt mal wieder eine Rolle...
  D3DInitialized:=False;
  View := nil; Camera := nil;
  Scene :=nil; Device := nil;
  D3DRMInterface := nil;
end;

procedure TD3DRMiniForm.OnDXTimer(Sender: TObject);
begin
  if D3DInitialized then
    if not RenderScene then
    begin
      PostQuitMessage(0);
      DXTimer.Enabled := False;
    end;
end;

// Sorgt dafr, dass D3DRM bei WM_PAINT den gesamten Zeichen-
// puffer neu malt - und nicht nur die Bereiche, die bei
// normaler Fortschreibung aktualisiert werden mten
procedure TD3DRMiniForm.FormPaint(Sender: TObject);
var WinDev: IDirect3DRMWinDevice;
begin
  // WinDevice-Schnittstelle von RMDevice3
  // bernimmt die Reaktion auf WM_PAINT
  if SUCCEEDED(Device.QueryInterface(
    IID_IDirect3DRMWinDevice,WinDev))
   then WinDev.HandlePaint(Canvas.Handle);
end;


end.


