/*
 * @(#)AddressHtmlResultSet.java	1.32 97/11/21
 *
 * Johannes Plachy (JPlachy@qualityservice.com)
 *
 *
 * Version 1.0
 */

package at.jps.address;

import java.sql.*;


/**
 * AddressHtmlResultSet erweitert HtmlResultSet
 *
 *
 * @author Johannes Plachy
 * @version 1.00, 15/06/99
 */


public class AddressHtmlResultSet extends HtmlResultSet
{

   private String ivServletURL;

   /**
   * Namen Email und URL der Addresse werden
   * als Hyperlink zurueckgeliefert
   *
   * @return String
   * @param Resultset
   * @param ServletURL fuer spaetere Links
   */
   public AddressHtmlResultSet(ResultSet rs, String ServletURL)
   {
      super( rs);
      ivServletURL = ServletURL;
   }

   /**
   * Namen Email und URL der Addresse werden
   * als Hyperlink zurueckgeliefert
   *
   * @return String
   * @param ColumnTitle zur Info
   * @param CellText
   * @param Resultset
   * @param nrCols
   */

   public String getHTMLStringForCell( String ColumnTitle, String CellText, ResultSet rs, int nrCols)
   {
      try
      {
         if (ColumnTitle.equals("NAME"))
         {
            return "<a href=\""+ivServletURL+"?what=edit&id="+rs.getObject(nrCols-1)+"\">"+CellText+"</a></td>";
         }
         else
         if (ColumnTitle.equals("EMAIL"))
         {
            return "<a href=\"mailto:"+CellText+"\">"+CellText+"</a>";
         }
         else
         if (ColumnTitle.equals("URL"))
         {
            return "<a href=\""+CellText+"\">"+CellText+"</a>";
         }

         return CellText;
      }
      catch (SQLException e)
      {
         return "&nbsp;";
      }
   }

   /**
   * letzten 2 spalten sind nur IDs
   * also nicht zur Anzeige gedacht
   *
   * @return columns to hide
   */
   public int getlastColumnsHiddenCount()
   {
      return 2;
   }

}
