		org	0x100
	
		jmp	start
	
century:	.word	0
dossetignore:	.byte	0
oldint1a:	.data4	0
	
	;; Neuer Int 1a, der die Funktionen zum Lesen und
	;; Setzen des Datums manipuliert - er belaesst den
	;; PC im Glauben, er liefe 1996 und schmettert alle
	;; Versuche, das Datum auf > 2000 ab, indem er die
	;; Korrektur um vier Jahre zurckdatiert ;-)
	
newint1a:	pushf
		cmp	ah, #4
		je	newgetdate
		cmp	ah, #5
		je	newsetdate
		popf
		cseg
		jmp	far [oldint1a]

newgetdate:	pushf
		cseg
		call	far [oldint1a]
		push	ax
		mov	ax, cx
		add	ax, #4
		daa
		jnc	nocarry1
		xchg	ah, al
		add	al, #1
		daa
		xchg	ah, al
nocarry1:	mov	cx, ax
		pop	ax
		popf
		retf	#2
	
newsetdate:	cseg
		cmp	byte ptr dossetignore, #0
		jz	contset

		popf
		clc
		retf	#2
	
contset:	cmp	cx, #0x2000
		jb	ignore
		cmp	cx, #0x2002
		ja	ignore
		push	ax
		mov	ax, cx
		call	todec
		sub	ax, #4
		call	tobcd
		mov	cx, ax
		pop	ax
		pushf
		cseg
		call	far [oldint1a]
ignore:		popf
		retf	#2

	;  Unterprogramme
		
tobcd:		push	bx		; konvertiert dec-ax in bcd
		push	cx
		push	dx
		mov	cx, #0xa
		xor	bx, bx

tobcdl:		xor	dx, dx
		div	cx
		or	bl,dl
		ror	bx, #4
		or	ax,ax
		jnz	tobcdl
		mov	ax,bx

		pop	dx
		pop	cx
		pop	bx
		ret

todec:		push	bx		;  konvertiert bcd-ax in dec
		push	cx
		push	dx
	
		mov	cx, ax
		xor	bx, bx
		mov	ax, #1
	
todecl:		push	cx
		and	cx, #0xf
		
		push	ax
		mul	cx
		add	bx ,ax
		pop	ax
		mov	cx, #0xa
		mul	cx
		
		pop	cx
		shr	cx, #4
		or	cx, cx
		jnz	todecl

		mov	ax, bx
		pop	dx
		pop	cx
		pop	bx
		ret

	;; Allgemeiner Teil, Installationspruefung
	;; ggf. Jahrhundert-Byte-Fix et cetera.
	
start:		push	cs
		pop	ds
		mov	dx, #hallo
		mov	ah, #0x9
		int	0x21

		mov	ax, #0xf000
		mov	es, ax
		eseg
		mov	al, byte ptr 0xfffe
		cmp	al, #0xfc
		je	known_modell
		cmp	al, #0xf8
		je	known_modell

	;; Der Test kann nur auf AT und PS/2 funktionieren
	
		mov	dx, #unknown_pc
		mov	ah, #9
		int	0x21
		jmp	plainexit
	
known_modell:	mov	ah, #4	; BIOS Getdate
		int	0x1a
		mov	century, cx

		cmp	cx, #0x1999 ;  Schon 2000?
		ja	noneed

further:	cmp	cx, #0x1970 ; BIOS setzt Jahrhundert nicht?
		ja	instctwindow ; spezielles c't/Award-Fenster

	;; Korrektur des Jahrhundert-Bytes via BIOS-Setdate
	;; das ist bei < 1970 der wahrscheinlichste Fall
	
 		mov	ch, #0x20
		mov	century, cx
		mov	ah, #5
		int	0x1a
	
		mov	dx, #fixcmos
		mov	ah, #9
		int	0x21

	;; Pruefen, ob sich Korrektur ins BIOS herumgesprochen hat

		mov	ah, #4
		int	0x1a
		cmp	cx, #0x2000
		jae	fixdos
	
		mov	dx, #cmosunchanged
		mov	ah, #9
		int	0x21
		jmp	plainexit		
	
	;; DOS-Datum auf gleichen Stand bringen

fixdos:		mov	ax, century
		call	todec
		mov	cx, ax
		xor	ah, ah
		mov	al, dh
		call	todec
		mov	dh, al
		mov	al, dl
		xor	ah, ah
		call	todec
		mov	dl, al
		mov	ah, #0x2b
		int	0x21
			
		jmp	#plainexit
	
noneed:		mov	dx, #notneeded
		mov	ah, #9
		int	0x21
	
plainexit:	mov	ax, #0x4c00
		int	0x21

	;; c't-Fenster-Algorithmus installieren
	;; alle Jahre ab 1996ff werden als 2000ff
	;; dargestellt (funktioniert bis 2003 inkl.,
	;; da auf solchen Rechnern 1999 der Fix noch 
	;; nicht wirken soll.
	
instctwindow:	cmp	cx, #0x1999
		je	noactiontoday
		
		mov	ax, #0x351a
		int	0x21
		mov	ax, es
		mov	oldint1a, bx
		mov	oldint1a+ 2, ax

		mov	dx, #newint1a
		mov	ax, #0x251a
		int	0x21
	

	;; DOS-Datum korrigieren
	
		mov	byte ptr dossetignore, #1
		mov	ax, century
		call	todec
		add	ax, #4
		push	ax
			
		mov	ah, #0x2a
		int	0x21

		pop	cx
		mov	ah, #0x2b
		int	0x21
		mov	byte ptr dossetignore, #0	
		
		mov	dx, #resident
		mov	ah, #9
		int	0x21

		mov	dx, #start
		add	dx, #0x10
		shr	dx, #4
		mov	ah, #0x31
		int	0x21
		
noactiontoday:	mov	dx, #noaction
		mov	ah, #9
		int	0x21
		jmp	#plainexit	
					
hallo:		.ascii	"cty2kfix 1.00, (C) c't/ps"
		.byte	10,13
		.ascii	"Programm korrigiert gaengige PC-BIOS-Fehler im Jahr 2000"
		.byte	13,10
		.ascii	"$"
notneeded:	.ascii	"Jahreskorrekturen nicht noetig (CMOS=20)"
		.byte	10,13
		.ascii	"$"
unknown_pc:	.ascii	"Programm laeuft nur auf AT und PS/2"
		.byte	10,13
		.ascii	"$"
fixcmos:	.ascii	"Einmalige Korrektur des Jahrhunderts via BIOS"
		.byte	10,13
		.ascii	"Verifzieren Sie beim naechsten Systemstart das Datum"
		.byte	10,13
		.ascii	"$"
cmosunchanged:	.ascii	"Jahrhundertkorrektur fehlgeschlagen"
		.byte	10,13
		.ascii	"$"
noaction:	.ascii	"Noch nichts zu tun (1999)"
		.byte	10,13
		.ascii	"$"
resident:	.ascii	"Residenter Teil zur Datumskorrektur installiert."
		.byte	10,13
		.ascii	"RTC laeuft um vier Jahre versetzt (2000=1996 ff)"
		.ascii	"$"
	