/******************************************************************************

    mamedriv.c

    Copyright Nicola Salmoria and the MAME Team.
    Visit http://mamedev.org for licensing and usage restrictions.

    The list of all available drivers. Drivers have to be included here to be
    recognized by the executable.

    To save some typing, we use a hack here. This file is recursively #included
    twice, with different definitions of the DRIVER() macro. The first one
    declares external references to the drivers; the second one builds an array
    storing all the drivers.

******************************************************************************/

#include "driver.h"

#ifndef DRIVER_RECURSIVE

#define DRIVER_RECURSIVE

/* step 1: declare all external references */
#define DRIVER(NAME) extern game_driver driver_##NAME;
#include "aster.c"

/* step 2: define the drivers[] array */
#undef DRIVER
#define DRIVER(NAME) &driver_##NAME,
const game_driver * const drivers[] =
{
#include "aster.c"
	0	/* end of array */
};



#else	/* DRIVER_RECURSIVE */
	/* Nichibutsu games */
	


	/* Atari vector games */
	DRIVER( asteroid )	/* 035127-035145    (c) 1979 */
	DRIVER( asteroi1 )	/* 035127-035145    no copyright notice */
	DRIVER( asteroib )	/* (bootleg) */
	

#endif	/* DRIVER_RECURSIVE */
