package haui.asteroid.control;

/**
 * Strukturiertes Datenpaket vom Emulator.
 * 
 * @author Harald Bögeholz / c't
 * @author Bernhard Haumacher
 */
public class FramePacket {
	
	public static final int VECTOR_RAM_SIZE = 1024;
	public static final int PACKET_SIZE = VECTOR_RAM_SIZE + 2;

	byte vectorRam[] = new byte[VECTOR_RAM_SIZE];
	
	/**
	 * wird bei jedem Frame inkrementiert
	 */
	byte frameNumber;
	
	/**
	 * Der Server schickt das letzte empfangene ping-Byte zurück
	 */
	byte ping;


	/**
	 * Liest dieses strukturierte Datenpaket aus dem gegebenen flachen
	 * Datenpuffer ein.
	 */
	public int copyFrom(byte[] buffer) {
		int pos = 0;
		System.arraycopy(buffer, pos, vectorRam, 0, vectorRam.length);
		pos += vectorRam.length;
		
		frameNumber = buffer[pos++];
		ping = buffer[pos++];
		
		return pos;
	}

}
