/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.tools.designer;

import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QWidget;
import java.lang.reflect.Constructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomWidget {
    private Class pluginClass;
    private String name;
    private boolean container;
    private String group;
    private String tooltip;
    private String whatsThis;
    private String includeFile;
    private QIcon icon;
    private Constructor constructor;

    public CustomWidget(Class<?> clazz) throws NoSuchMethodException {
        this.pluginClass = clazz;
        this.constructor = clazz.getConstructor(QWidget.class);
    }

    public QWidget createWidget(QWidget qWidget) {
        QWidget qWidget2 = null;
        try {
            qWidget2 = (QWidget)this.constructor.newInstance(qWidget);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (qWidget2 == null) {
            qWidget2 = new QWidget(qWidget);
        }
        return qWidget2;
    }

    public boolean isContainer() {
        return this.container;
    }

    public void setContainer(boolean bl) {
        this.container = bl;
    }

    public String group() {
        return this.group;
    }

    public void setGroup(String string) {
        this.group = string;
    }

    public QIcon icon() {
        return this.icon;
    }

    public void setIcon(QIcon qIcon) {
        this.icon = qIcon;
    }

    public String includeFile() {
        if (this.includeFile.length() == 0) {
            return this.pluginClass.getPackage().getName();
        }
        return this.includeFile;
    }

    public void setIncludeFile(String string) {
        this.includeFile = string;
    }

    public String name() {
        if (this.name.length() == 0) {
            return this.pluginClass.getSimpleName();
        }
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Class pluginClass() {
        return this.pluginClass;
    }

    public String tooltip() {
        return this.tooltip;
    }

    public void setTooltip(String string) {
        this.tooltip = string;
    }

    public String whatsThis() {
        return this.whatsThis;
    }

    public void setWhatsThis(String string) {
        this.whatsThis = string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CustomWidget(").append(this.pluginClass.toString());
        if (this.name != null && this.name.length() != 0) {
            stringBuilder.append(",name=").append(this.name);
        }
        if (this.group != null && this.group.length() != 0) {
            stringBuilder.append(",group=").append(this.group);
        }
        if (this.tooltip != null && this.tooltip.length() != 0) {
            stringBuilder.append(",toolTip=").append(this.tooltip);
        }
        if (this.whatsThis != null && this.whatsThis.length() != 0) {
            stringBuilder.append(",whatsThis=").append(this.whatsThis);
        }
        if (this.includeFile != null && this.includeFile.length() != 0) {
            stringBuilder.append(",include=").append(this.includeFile);
        }
        if (this.icon != null && !this.icon.isNull()) {
            stringBuilder.append(",icon=").append(this.icon);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

