/****************************************************************************
**
** Copyright (C) 1992-2008 Trolltech ASA. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

package com.trolltech.examples.qtconcurrent;

import java.lang.reflect.*;
import com.trolltech.qt.core.*;

public class RunFunction {
    public static void hello(String name) {
        System.out.println("Hello " + name + " from " + Thread.currentThread());
    }

    public static String helloReturned(String name) {
        return "Hello " + name + " from " + Thread.currentThread();
    }

    public static void main(String args[]) {
        Method hello = null;
        Method helloReturned = null;
        try {
            hello = RunFunction.class.getMethod("hello", String.class);
            helloReturned = RunFunction.class.getMethod("helloReturned", String.class);
        } catch (Exception e) {
            return ;
        }

        QFutureVoid f1 = QtConcurrent.runVoidMethod(null, hello, "James");
        QFutureVoid f2 = QtConcurrent.runVoidMethod(null, hello, "William");
        QFuture<String> f3 = QtConcurrent.run(null, helloReturned, "Virginia");
        f1.waitForFinished();
        f2.waitForFinished();
        f3.waitForFinished();

        System.out.println(f3.results().get(0));
    }

}
