/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qt.core;

import com.trolltech.qt.core.QCoreApplication;
import com.trolltech.qt.core.QEvent;
import com.trolltech.qt.core.QObject;
import com.trolltech.qt.gui.QApplication;

class QSynchronousInvokable
extends QObject {
    static QEvent.Type SYNCHRONOUS_INVOKABLE_EVENT = QEvent.Type.resolve(QEvent.Type.User.value() + 1);
    private Runnable runnable;
    private Boolean invoked = false;

    public QSynchronousInvokable(Runnable runnable) {
        this.disableGarbageCollection();
        if (QCoreApplication.instance().nativeId() != 0L) {
            this.moveToThread(QCoreApplication.instance().thread());
            this.runnable = runnable;
        }
        if (runnable == null || Thread.currentThread().equals(QApplication.instance().thread())) {
            this.invoked = true;
        }
    }

    synchronized void waitForInvoked() {
        while (!this.invoked.booleanValue()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.invoked = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean event(QEvent e) {
        if (e.type() == SYNCHRONOUS_INVOKABLE_EVENT && this.runnable != null) {
            this.runnable.run();
            QSynchronousInvokable qSynchronousInvokable = this;
            synchronized (qSynchronousInvokable) {
                this.invoked = true;
                this.notifyAll();
            }
            return true;
        }
        return super.event(e);
    }
}

