/****************************************************************************
**
** Copyright (C) 1992-2008 Trolltech ASA. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "pickupaction.h"

#include "gameobject.h"
#include "gamescene.h"

bool PickUpAction::perform(GameScene *scene)
{
    if (objects.size() > 0) {
        return false; 
    } else {
        QList<AbstractGameObject *> cant_pick_up;
        for (int i=0; i<subjects.size(); ++i) {
            if (!(subjects.at(i)->objectFlags() & Game::CanPickUp)) {                
                cant_pick_up.append(subjects.at(i));
            } else {
                scene->addToEgoInventory(subjects.at(i));
            }
        }

        QString msg;
        for (int i=0; i<cant_pick_up.size(); ++i) {
            if (i == 0) {
                msg += "You can't pick up ";
            } else if (i == cant_pick_up.size() - 1) {
                msg += " and ";
            } else {
                msg += ", ";
            }

            msg += cant_pick_up.at(i)->name();
        }

        if (!msg.isEmpty())
            scene->message(msg);

        return cant_pick_up.size() != subjects.size();
    }
}

GameAction *PickUpAction::clone() const
{
    PickUpAction *action = new PickUpAction;
    action->subjects = subjects;
    action->objects = objects;

    return action;
}

