/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.tools.designer;

import com.trolltech.qt.QtJambiInternal;
import com.trolltech.qt.Utilities;
import com.trolltech.qt.core.QAbstractItemModel;
import com.trolltech.qt.core.QModelIndex;
import com.trolltech.qt.core.QSettings;
import com.trolltech.qt.core.QSize;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QAction;
import com.trolltech.qt.gui.QApplication;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QGridLayout;
import com.trolltech.qt.gui.QHBoxLayout;
import com.trolltech.qt.gui.QItemSelectionModel;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLineEdit;
import com.trolltech.qt.gui.QPixmap;
import com.trolltech.qt.gui.QShowEvent;
import com.trolltech.qt.gui.QSizePolicy;
import com.trolltech.qt.gui.QSortFilterProxyModel;
import com.trolltech.qt.gui.QTreeView;
import com.trolltech.qt.gui.QWidget;
import com.trolltech.tools.designer.ClassPathWalker;
import com.trolltech.tools.designer.HourGlass;
import com.trolltech.tools.designer.JambiResourceBrowser;
import com.trolltech.tools.designer.ResourceBrowserModel;
import com.trolltech.tools.designer.SearchPathDialog;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceBrowser
extends JambiResourceBrowser {
    private static final boolean UNFILTERED = Utilities.matchProperty("unfiltered", new String[0]);
    private QItemSelectionModel selection;
    private QLabel preview;
    private QLabel pathText;
    private QLabel sizeText;
    private ClassPathWalker walker;
    private ResourceBrowserModel browserModel;
    private QSortFilterProxyModel filterModel;
    private QTreeView view;
    private String path;
    private String currentPath;
    private QLineEdit filterEdit;
    private HourGlass hourGlass;
    private boolean shown;

    public ResourceBrowser(QWidget qWidget) {
        super(qWidget);
        try {
            QAbstractItemModel qAbstractItemModel;
            if (UNFILTERED) {
                qAbstractItemModel = this.browserModel;
            } else {
                this.filterModel = new ResourceBrowserModel.FilterModel(this);
                this.filterModel.setSourceModel(this.browserModel);
                qAbstractItemModel = this.filterModel;
            }
            this.selection = new QItemSelectionModel(qAbstractItemModel);
            this.view = new QTreeView(this);
            this.view.header().hide();
            this.view.setModel(qAbstractItemModel);
            this.view.setSelectionModel(this.selection);
            this.view.setRootIsDecorated(false);
            this.filterEdit = new QLineEdit(this);
            this.pathText = new QLabel();
            this.pathText.setMaximumSize(250, this.pathText.maximumHeight());
            this.pathText.setTextInteractionFlags(Qt.TextInteractionFlag.TextSelectableByMouse);
            this.sizeText = new QLabel();
            this.sizeText.setAlignment(Qt.AlignmentFlag.AlignLeft);
            this.preview = new QLabel();
            this.preview.setFixedSize(new QSize(64, 64));
            this.preview.setAlignment(Qt.AlignmentFlag.AlignHCenter, Qt.AlignmentFlag.AlignVCenter);
            this.hourGlass = new HourGlass(this);
            QGridLayout qGridLayout = new QGridLayout(this);
            QHBoxLayout qHBoxLayout = new QHBoxLayout();
            qHBoxLayout.addWidget(new QLabel(this.tr("Filter:"), this));
            qHBoxLayout.addWidget(this.filterEdit);
            qHBoxLayout.addWidget(this.hourGlass);
            qGridLayout.addItem(qHBoxLayout, 0, 0, 1, 2);
            qGridLayout.addWidget((QWidget)this.view, 1, 0, 1, 2);
            qGridLayout.addWidget(new QLabel(this.tr("Size:")), 2, 0);
            qGridLayout.addWidget(this.sizeText, 2, 1);
            qGridLayout.addWidget(new QLabel(this.tr("Path:")), 3, 0);
            qGridLayout.addWidget(this.pathText, 3, 1);
            qGridLayout.addWidget((QWidget)this.preview, 4, 0, 1, 2);
            qGridLayout.setMargin(0);
            qHBoxLayout.setSpacing(6);
            qHBoxLayout.setMargin(0);
            QWidget.setTabOrder(this.filterEdit, this.view);
            QSizePolicy qSizePolicy = new QSizePolicy(QSizePolicy.Policy.Expanding, QSizePolicy.Policy.Preferred);
            qSizePolicy.setHorizontalStretch((byte)1);
            this.pathText.setSizePolicy(qSizePolicy);
            this.sizeText.setSizePolicy(qSizePolicy);
            if (!UNFILTERED) {
                this.filterEdit.textChanged.connect(this.filterModel, "setFilterRegExp(String)");
                this.filterEdit.textChanged.connect(this.view, "expandAll()");
                this.filterEdit.textChanged.connect(this, "checkOnlyOne()");
            }
            if (this.window() instanceof QDialog) {
                this.view.doubleClicked.connect((QDialog)this.window(), "accept()");
            }
            this.view.expandAll();
            this.selection.currentChanged.connect(this, "selectionChanged(QModelIndex, QModelIndex)");
            this.setContextMenuPolicy(Qt.ContextMenuPolicy.ActionsContextMenu);
            this.addAction("Refresh", "reindex()");
            this.addAction("Edit searchpath", "changeSearchPath()");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public String currentPath() {
        return this.path;
    }

    @Override
    public void setCurrentPath(String string) {
        this.currentPath = string;
        this.reselectCurrent();
    }

    private void reselectCurrent() {
        if (this.currentPath == null) {
            return;
        }
        QModelIndex qModelIndex = null;
        if (this.browserModel != null) {
            qModelIndex = this.browserModel.indexForPath(this.currentPath);
        }
        if (this.filterModel != null && qModelIndex != null && !UNFILTERED) {
            qModelIndex = this.filterModel.mapFromSource(qModelIndex);
        }
        if (this.selection != null) {
            this.selection.setCurrentIndex(qModelIndex, QItemSelectionModel.SelectionFlag.SelectCurrent);
        }
    }

    @Override
    protected void showEvent(QShowEvent qShowEvent) {
        if (this.walker == null) {
            this.reindex();
        }
        this.shown = true;
        this.filterEdit.setFocus();
    }

    @Override
    public void updateRootDirs(String string) {
        String[] stringArray = string.split(System.getProperty("path.separator"));
        List<String> list = ClassPathWalker.roots();
        if (list != null) {
            for (String string2 : list) {
                QtJambiInternal.removeSearchPathForResourceEngine(string2);
            }
        }
        list = new ArrayList<String>();
        Collections.addAll(list, stringArray);
        for (String string2 : list) {
            QtJambiInternal.addSearchPathForResourceEngine(string2);
        }
        ClassPathWalker.setRoots(list);
        ClassPathWalker.addRootsFromSettings();
        this.reindex();
    }

    private void setPreviewForIndex(QModelIndex qModelIndex) {
        this.path = this.browserModel.resource(qModelIndex);
        if (this.path == null) {
            this.sizeText.setText("");
            this.pathText.setText("");
            this.preview.setPixmap(null);
            return;
        }
        QPixmap qPixmap = new QPixmap(this.path);
        this.sizeText.setText(qPixmap.width() + " x " + qPixmap.height());
        if (qPixmap.width() > 64 || qPixmap.height() > 64) {
            qPixmap = qPixmap.scaled(64, 64, Qt.AspectRatioMode.KeepAspectRatio, Qt.TransformationMode.SmoothTransformation);
        }
        this.preview.setPixmap(qPixmap);
        this.pathText.setText(this.path);
        this.currentPathChanged.emit(this.path);
    }

    private void selectionChanged(QModelIndex qModelIndex, QModelIndex qModelIndex2) {
        QModelIndex qModelIndex3 = qModelIndex;
        if (qModelIndex3 != null) {
            if (!UNFILTERED) {
                qModelIndex3 = this.filterModel.mapToSource(qModelIndex3);
            }
            this.setPreviewForIndex(qModelIndex3);
            this.currentPath = null;
        }
    }

    private void checkOnlyOne() {
        if (UNFILTERED || this.filterModel.rowCount() != 1) {
            return;
        }
        QModelIndex qModelIndex = this.filterModel.index(0, 0, null);
        if (this.filterModel.rowCount(qModelIndex) == 1) {
            QModelIndex qModelIndex2 = this.filterModel.index(0, 0, qModelIndex);
            this.selection.setCurrentIndex(qModelIndex2, QItemSelectionModel.SelectionFlag.SelectCurrent);
        }
    }

    private void addAction(String string, String string2) {
        QAction qAction = new QAction(this.tr(string), this);
        qAction.triggered.connect(this, string2);
        this.addAction(qAction);
    }

    private void expand(QModelIndex qModelIndex) {
        if (UNFILTERED) {
            this.view.expand(qModelIndex);
        } else {
            QModelIndex qModelIndex2 = this.filterModel.mapFromSource(qModelIndex);
            this.view.expand(qModelIndex2);
        }
    }

    private void setupSearchConnections() {
        this.walker.beginSearching.connect(this.hourGlass, "start()");
        this.walker.doneSearching.connect(this.hourGlass, "stop()");
        this.walker.resourceFound.connect(this.hourGlass, "start()");
        this.browserModel.rowsAdded.connect(this, "expand(QModelIndex)");
    }

    @Override
    protected void disposed() {
        if (this.browserModel != null) {
            this.browserModel.dispose();
        }
        if (this.walker != null) {
            this.walker.kill();
            this.walker.dispose();
        }
    }

    private void reindex() {
        this.filterModel.setSourceModel(null);
        if (this.browserModel != null) {
            this.browserModel.dispose();
            this.browserModel = null;
        }
        if (this.walker != null) {
            this.walker.kill();
            this.walker.dispose();
            this.walker = null;
        }
        this.searchClassPath();
        this.filterModel.setSourceModel(this.browserModel);
        this.setupSearchConnections();
    }

    private void updateSettings(List<String> list, List<String> list2) {
        String string = "";
        QSettings qSettings = new QSettings("Trolltech", "Qt Jambi Resource Browser");
        Object object = qSettings.value("Extra paths");
        ArrayList arrayList = new ArrayList();
        if (object != null && object instanceof String) {
            Collections.addAll(arrayList, ((String)object).split(File.pathSeparator));
        }
        for (String string2 : list) {
            if (list2.contains(string2) && !arrayList.contains(string2)) continue;
            if (!string.equals("")) {
                string = string + File.pathSeparator;
            }
            string = string + string2;
        }
        qSettings.setValue("Extra paths", string);
        qSettings.sync();
    }

    private void changeSearchPath() {
        SearchPathDialog searchPathDialog = new SearchPathDialog(this);
        searchPathDialog.setPaths(ClassPathWalker.roots());
        if (searchPathDialog.exec() == QDialog.DialogCode.Accepted.value()) {
            List<String> list = searchPathDialog.paths();
            List<String> list2 = ClassPathWalker.roots();
            for (String string : list2) {
                if (list.contains(string)) continue;
                QtJambiInternal.removeSearchPathForResourceEngine(string);
            }
            for (String string : list) {
                if (list2.contains(string)) continue;
                QtJambiInternal.addSearchPathForResourceEngine(string);
            }
            this.updateSettings(list, list2);
            ClassPathWalker.setRoots(list);
            this.reindex();
        }
    }

    private void searchClassPath() {
        if (this.walker != null) {
            return;
        }
        this.walker = new ClassPathWalker();
        this.walker.setPixmapSize(ResourceBrowserModel.PIXMAP_SIZE);
        this.browserModel = new ResourceBrowserModel();
        this.walker.resourceFound.connect(this.browserModel, "addResource(String, QImage)");
        this.walker.start();
    }

    public static void main(String[] stringArray) {
        QApplication.initialize(stringArray);
        ResourceBrowser resourceBrowser = new ResourceBrowser(null);
        resourceBrowser.show();
        resourceBrowser.setCurrentPath("classpath:com/trolltech/images/copy.png");
        QApplication.exec();
    }
}

