/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.tools.designer;

import com.trolltech.qt.core.QPointF;
import com.trolltech.qt.core.QRectF;
import com.trolltech.qt.core.QSize;
import com.trolltech.qt.core.QTimerEvent;
import com.trolltech.qt.gui.QBrush;
import com.trolltech.qt.gui.QColor;
import com.trolltech.qt.gui.QHideEvent;
import com.trolltech.qt.gui.QMatrix;
import com.trolltech.qt.gui.QPaintEvent;
import com.trolltech.qt.gui.QPainter;
import com.trolltech.qt.gui.QPainterPath;
import com.trolltech.qt.gui.QPen;
import com.trolltech.qt.gui.QShowEvent;
import com.trolltech.qt.gui.QWidget;

public class HourGlass
extends QWidget {
    private boolean running;
    private int timerId;
    private int rotation;
    private QPainterPath path;

    public HourGlass() {
        this((QWidget)null);
    }

    public HourGlass(QWidget qWidget) {
        super(qWidget);
        double d = 8.0;
        double d2 = 2.5;
        double d3 = 1.0;
        this.path = new QPainterPath();
        QPointF qPointF = new QPointF(0.0, d - d2);
        QMatrix qMatrix = new QMatrix();
        for (int i = 0; i < 8; ++i) {
            qMatrix.rotate(-45.0);
            double d4 = Math.max(d2 * 2.0 - (double)i, d3 * 2.0);
            QRectF qRectF = new QRectF(-d4 / 2.0, -d4 / 2.0, d4, d4);
            qRectF.moveCenter(qMatrix.map(qPointF));
            this.path.addEllipse(qRectF);
        }
        this.hide();
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.run(true);
        this.show();
    }

    public void stop() {
        this.running = false;
        this.run(false);
        this.hide();
    }

    protected void showEvent(QShowEvent qShowEvent) {
        this.run(true);
    }

    protected void hideEvent(QHideEvent qHideEvent) {
        this.run(false);
    }

    protected void timerEvent(QTimerEvent qTimerEvent) {
        this.rotation += 45;
        this.update();
    }

    protected void paintEvent(QPaintEvent qPaintEvent) {
        QPainter qPainter = new QPainter(this);
        qPainter.setRenderHint(QPainter.RenderHint.Antialiasing);
        qPainter.translate(this.rect().center());
        qPainter.rotate(this.rotation);
        qPainter.setBrush(new QBrush(QColor.gray));
        qPainter.setPen(QPen.NoPen);
        qPainter.fillPath(this.path, new QBrush(QColor.gray));
    }

    public QSize sizeHint() {
        return new QSize(16, 16);
    }

    private void run(boolean bl) {
        if (bl && this.running && this.timerId == 0) {
            this.timerId = this.startTimer(100);
        } else if (!(this.timerId == 0 || bl && this.running)) {
            this.killTimer(this.timerId);
            this.timerId = 0;
        }
    }
}

