/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qt.designer;

import com.trolltech.qt.designer.ColorPropertyHandler;
import com.trolltech.qt.designer.PropertyHandler;
import com.trolltech.qt.designer.QUiLoaderException;
import com.trolltech.qt.gui.QApplication;
import com.trolltech.qt.gui.QBrush;
import com.trolltech.qt.gui.QColor;
import com.trolltech.qt.gui.QPalette;
import com.trolltech.qt.xml.QDomElement;
import com.trolltech.qt.xml.QDomNode;
import com.trolltech.qt.xml.QDomNodeList;
import java.util.HashMap;

class PalettePropertyHandler
extends PropertyHandler {
    private ColorPropertyHandler colorHandler = new ColorPropertyHandler();
    static HashMap<String, QPalette.ColorRole> colorRoles = new HashMap();

    PalettePropertyHandler() {
    }

    public Object create(QDomElement qDomElement) throws QUiLoaderException {
        QPalette qPalette = QApplication.palette();
        this.parse(qDomElement.namedItem("active").toElement(), qPalette, QPalette.ColorGroup.Active);
        this.parse(qDomElement.namedItem("inactive").toElement(), qPalette, QPalette.ColorGroup.Inactive);
        this.parse(qDomElement.namedItem("disabled").toElement(), qPalette, QPalette.ColorGroup.Disabled);
        return qPalette;
    }

    private void parse(QDomElement qDomElement, QPalette qPalette, QPalette.ColorGroup colorGroup) throws QUiLoaderException {
        QDomNodeList qDomNodeList = qDomElement.childNodes();
        for (int i = 0; i < qDomNodeList.count(); ++i) {
            QDomNode qDomNode = qDomNodeList.at(i);
            if (!qDomNode.nodeName().equals("colorrole")) continue;
            QDomElement qDomElement2 = qDomNode.toElement();
            QPalette.ColorRole colorRole = colorRoles.get(qDomElement2.attribute("role"));
            QDomElement qDomElement3 = qDomElement2.namedItem("brush").toElement();
            if (!qDomElement3.attribute("brushstyle").equals("SolidPattern")) {
                throw new QUiLoaderException("Unhandled brush style: " + qDomElement3.attribute("brushstyle"));
            }
            QColor qColor = (QColor)this.colorHandler.create(qDomElement3.namedItem("color").toElement());
            QBrush qBrush = new QBrush(qColor);
            qPalette.setBrush(colorGroup, colorRole, qBrush);
        }
    }

    static {
        for (QPalette.ColorRole colorRole : QPalette.ColorRole.values()) {
            colorRoles.put(colorRole.name(), colorRole);
        }
    }
}

