/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qt;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    private static HashSet<String> LOADED_LIBS = new HashSet();
    public static final int MAJOR_VERSION = 4;
    public static final int MINOR_VERSION = 3;
    public static final int PATCH_VERSION = 4;
    public static final int BUILD_NUMBER = 1;
    private static final boolean VERBOSE_LOADING = System.getProperty("com.trolltech.qt.verbose-loading") != null;
    public static final String VERSION_STRING = String.format("%1$d.%2$d.%3$d_%4$02d", 4, 3, 4, 1);
    public static OperatingSystem operatingSystem = Utilities.decideOperatingSystem();
    public static Configuration configuration = Utilities.decideConfiguration();
    public static boolean implicitLoading = !Utilities.matchProperty("com.trolltech.qt.implicit-loading", "false");
    public static String libSubPath = Utilities.decideLibSubPath();
    public static boolean loadFromCache = Utilities.matchProperty("com.trolltech.qt.load-from-cache", "true");
    private static final String DEBUG_SUFFIX = "_debuglib";
    private static String EXCLUDE_STRING = "com.trolltech.qt.exclude-libraries";

    public static boolean matchProperty(String string, String ... stringArray) {
        String string2 = System.getProperty(string);
        if (string2 == null) {
            return false;
        }
        if (stringArray == null || stringArray.length == 0) {
            return string2 != null;
        }
        for (String string3 : stringArray) {
            if (!string2.contains(string3)) continue;
            return true;
        }
        return false;
    }

    public static void loadSystemLibraries() {
        List<String> list = Utilities.readSystemLibraries();
        for (String string : list) {
            Utilities.loadLibrary(string);
        }
    }

    public static void loadQtLibrary(String string) {
        Object object;
        String string2 = System.getProperty(EXCLUDE_STRING);
        if (string2 != null) {
            object = new StringTokenizer(string2, File.pathSeparator);
            while (((StringTokenizer)object).hasMoreElements()) {
                if (!string.equals(((StringTokenizer)object).nextElement())) continue;
                if (VERBOSE_LOADING) {
                    System.out.println("Skipped library (" + string + ") since it is listed in " + string2);
                }
                return;
            }
        }
        object = Utilities.qtLibraryName(string);
        Utilities.loadLibrary((String)object);
    }

    public static void loadJambiLibrary(String string) {
        if (configuration == Configuration.Debug) {
            string = string + DEBUG_SUFFIX;
        }
        String string2 = Utilities.jniLibraryName(string);
        Utilities.loadLibrary(string2);
    }

    private static boolean loadFromEnv(String string, String string2, LibraryLoadingInfo libraryLoadingInfo) {
        libraryLoadingInfo.message(".. from environment: " + string + " ");
        try {
            String string3 = System.getProperty(string);
            if (string3 != null) {
                String[] stringArray;
                for (String string4 : stringArray = string3.split(File.pathSeparator)) {
                    File file = new File(string4, string2);
                    if (!file.exists()) continue;
                    Runtime.getRuntime().load(file.getAbsolutePath());
                    libraryLoadingInfo.success("   Loaded from: " + string4);
                    LOADED_LIBS.add(string2);
                    return true;
                }
                if (string3.length() > 0) {
                    libraryLoadingInfo.message("   Failed to find " + string2 + " in " + string + "(" + string3 + ")");
                }
            } else {
                libraryLoadingInfo.message("(Skipped, environment was empty)");
            }
        }
        catch (Throwable throwable) {
            libraryLoadingInfo.message("   Failed to load " + string2 + " from " + string);
            if (VERBOSE_LOADING) {
                libraryLoadingInfo.failed();
            }
            return false;
        }
        return false;
    }

    public static boolean loadLibrary(String string) {
        boolean bl;
        LibraryLoadingInfo libraryLoadingInfo = new LibraryLoadingInfo(string);
        if (LOADED_LIBS.contains(string)) {
            libraryLoadingInfo.success("Already loaded: " + string + " skipping it.");
            return true;
        }
        libraryLoadingInfo.message("Going to load: " + string);
        boolean bl2 = bl = operatingSystem == OperatingSystem.Windows && (string.equals("Microsoft.VC80.CRT.manifest") || string.equals("msvcr80.dll") || string.equals("msvcm80.dll") || string.equals("msvcp80.dll"));
        if (!bl && Utilities.loadFromEnv("com.trolltech.qt.library-path", string, libraryLoadingInfo)) {
            return true;
        }
        if (!bl && Utilities.loadFromEnv("com.trolltech.qt.internal.jambipath", string, libraryLoadingInfo)) {
            return true;
        }
        try {
            libraryLoadingInfo.message(".. from classpath:");
            URL uRL = Utilities.classLoader().getResource(string);
            if (uRL == null) {
                throw new RuntimeException("Library: '" + string + "' could not be resolved");
            }
            File file = Utilities.jambiTempDir();
            File file2 = new File(file, string);
            if (!file2.exists() || !loadFromCache) {
                file.mkdirs();
                Utilities.copy(uRL, file2);
                if (bl) {
                    libraryLoadingInfo.success("Unpacked file: " + file2.getAbsolutePath());
                    return true;
                }
                Runtime.getRuntime().load(file2.getAbsolutePath());
                libraryLoadingInfo.success("Loaded " + file2.getAbsolutePath() + " as " + string + " from class path");
            } else {
                Runtime.getRuntime().load(file2.getAbsolutePath());
                libraryLoadingInfo.success("Loaded " + file2.getAbsolutePath() + " as " + string + " using cached");
            }
            LOADED_LIBS.add(string);
            return true;
        }
        catch (Throwable throwable) {
            Object object;
            libraryLoadingInfo.message(throwable);
            if (bl) {
                return true;
            }
            if (implicitLoading) {
                libraryLoadingInfo.message(".. using relative path (com.trolltech.qt.implicit-loading).");
                try {
                    object = Utilities.class.getProtectionDomain().getCodeSource().getLocation().toURI();
                    File file = new File((URI)object);
                    String string2 = file.isDirectory() ? file.getAbsolutePath() : file.getParentFile().getAbsolutePath();
                    String string3 = string2 + File.separator + libSubPath + File.separator + string;
                    if (new File(string3).exists()) {
                        Runtime.getRuntime().load(string3);
                        libraryLoadingInfo.success("Loaded(" + string3 + ") using deploy path, as " + string);
                        LOADED_LIBS.add(string);
                        return true;
                    }
                    libraryLoadingInfo.message("   File not found: " + string3);
                }
                catch (Throwable throwable2) {
                    libraryLoadingInfo.message(throwable2);
                }
            }
            libraryLoadingInfo.message(".. in standard way.");
            try {
                object = Utilities.stripLibraryName(string);
                System.loadLibrary((String)object);
                libraryLoadingInfo.success("Loaded(" + string + ") in standard way as " + (String)object);
                LOADED_LIBS.add(string);
                return true;
            }
            catch (Throwable throwable3) {
                libraryLoadingInfo.message(throwable3);
                if (Utilities.loadFromEnv("java.library.path", string, libraryLoadingInfo)) {
                    return true;
                }
                libraryLoadingInfo.failed();
                return false;
            }
        }
    }

    public static File jambiTempDir() {
        File file = new File(System.getProperty("java.io.tmpdir"));
        String string = System.getProperty("user.name");
        String string2 = System.getProperty("os.arch");
        return new File(file, "QtJambi_" + string + "_" + string2 + "_" + VERSION_STRING);
    }

    private static void copy(URL uRL, File file) throws IOException {
        Utilities.copy(uRL.openStream(), new FileOutputStream(file));
    }

    private static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[65536];
        while (inputStream.available() > 0) {
            int n = inputStream.read(byArray);
            outputStream.write(byArray, 0, n);
        }
        inputStream.close();
        outputStream.close();
    }

    private static OperatingSystem decideOperatingSystem() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.startsWith("windows")) {
            return OperatingSystem.Windows;
        }
        if (string.startsWith("mac os x")) {
            return OperatingSystem.MacOSX;
        }
        return OperatingSystem.Linux;
    }

    private static Configuration decideConfiguration() {
        if (System.getProperty("com.trolltech.qt.debug") != null) {
            return Configuration.Debug;
        }
        return Configuration.Release;
    }

    private static String decideLibSubPath() {
        return operatingSystem == OperatingSystem.Windows ? "bin" : "lib";
    }

    private static String jniLibraryName(String string) {
        switch (operatingSystem) {
            case Windows: {
                return string + ".dll";
            }
            case MacOSX: {
                return "lib" + string + ".jnilib";
            }
            case Linux: {
                return "lib" + string + ".so";
            }
        }
        throw new RuntimeException("Unreachable statement");
    }

    private static String stripLibraryName(String string) {
        if (operatingSystem != OperatingSystem.Windows) {
            string = string.substring(3);
        }
        int n = -1;
        switch (operatingSystem) {
            case Windows: {
                n = string.indexOf(".dll");
                break;
            }
            case Linux: {
                n = string.indexOf(".so");
                break;
            }
            case MacOSX: {
                n = string.indexOf(".");
            }
        }
        return string.substring(0, n);
    }

    private static String qtLibraryName(String string) {
        switch (operatingSystem) {
            case Windows: {
                return configuration == Configuration.Debug ? string + "d4.dll" : string + "4.dll";
            }
            case MacOSX: {
                if (configuration == Configuration.Debug) {
                    return "lib" + string + "_debug.4.dylib";
                }
                return "lib" + string + ".4.dylib";
            }
            case Linux: {
                return "lib" + string + ".so.4";
            }
        }
        throw new RuntimeException("Unreachable statement");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<String> readSystemLibraries() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = System.getProperty("com.trolltech.qt.systemlibraries");
        if (string != null) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(File.pathSeparator)) {
                arrayList.add(string2);
            }
            return arrayList;
        } else {
            InputStream inputStream = Utilities.classLoader().getResourceAsStream("qt_system_libs");
            if (inputStream == null && VERBOSE_LOADING) {
                System.out.println("No 'qt_system_libs' file");
            }
            if (inputStream == null) return arrayList;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                String string3 = null;
                while ((string3 = bufferedReader.readLine()) != null) {
                    arrayList.add(string3);
                }
                return arrayList;
            }
            catch (Exception exception) {
                if (!VERBOSE_LOADING) return arrayList;
                exception.printStackTrace();
            }
        }
        return arrayList;
    }

    private static ClassLoader classLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = Utilities.class.getClassLoader();
            assert (classLoader != null);
        }
        return classLoader;
    }

    public static String unpackPlugins() {
        Object object;
        String string = System.getProperty("com.trolltech.qt.pluginjars");
        if (VERBOSE_LOADING) {
            System.out.println("Loading plugins from: " + string);
        }
        ArrayList arrayList = new ArrayList();
        try {
            object = Utilities.classLoader().getResources("plugins");
            while (object.hasMoreElements()) {
                arrayList.add(object.nextElement());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string != null) {
            String[] stringArray;
            object = Utilities.jambiTempDir();
            for (String string2 : stringArray = string.split(File.pathSeparator)) {
                try {
                    File file = new File(string2);
                    if (file.exists()) {
                        Utilities.unpackPlugins(new JarFile(file));
                        continue;
                    }
                    for (URL uRL : arrayList) {
                        URLConnection uRLConnection;
                        if (!uRL.toString().contains(string2) || !((uRLConnection = uRL.openConnection()) instanceof JarURLConnection)) continue;
                        Utilities.unpackPlugins(((JarURLConnection)uRLConnection).getJarFile());
                    }
                }
                catch (Exception exception) {
                    if (!VERBOSE_LOADING) continue;
                    System.out.println("could not load plugin archive...: " + string2);
                    exception.printStackTrace();
                }
            }
            return ((File)object).getAbsolutePath() + "/plugins";
        }
        return null;
    }

    private static void unpackPlugins(JarFile jarFile) throws IOException {
        File file = Utilities.jambiTempDir();
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            File file2;
            JarEntry jarEntry = enumeration.nextElement();
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            if (!jarEntry.getName().startsWith("plugins") || jarEntry.isDirectory() || (file2 = new File(file.getAbsolutePath(), jarEntry.getName())).exists()) continue;
            File file3 = file2.getParentFile();
            if (!file3.exists()) {
                file3.mkdirs();
            }
            Utilities.copy(inputStream, new FileOutputStream(file2));
        }
        if (VERBOSE_LOADING) {
            System.out.println("unpacked plugins from: " + jarFile);
        }
    }

    private static class LibraryLoadingInfo {
        private String libraryName;
        private boolean success = false;
        private Vector<Object> messages = new Vector();

        LibraryLoadingInfo(String string) {
            this.libraryName = string;
        }

        private void message(String string) {
            this.messages.add(string);
        }

        private void message(Throwable throwable) {
            this.messages.add(throwable);
        }

        private String format() {
            String string = "";
            if (this.success) {
                System.out.println(this.messages.lastElement().toString());
            } else {
                for (Object object : this.messages) {
                    if (object instanceof String) {
                        string = string + object.toString() + "\n";
                        continue;
                    }
                    if (!(object instanceof Throwable)) continue;
                    Throwable throwable = (Throwable)object;
                    string = string + "   Failed with exception:\n";
                    string = string + "     " + throwable.toString() + "\n";
                    StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
                    for (int i = 0; i < stackTraceElementArray.length; ++i) {
                        string = string + "     " + stackTraceElementArray[i].toString() + "\n";
                    }
                    string = string + "\n";
                }
            }
            return string;
        }

        private void success(String string) {
            this.message(string);
            this.success = true;
            if (VERBOSE_LOADING) {
                System.out.print(this.format());
            }
        }

        private void failed() {
            this.success = false;
            if (VERBOSE_LOADING) {
                System.out.println("Failed to laod : " + this.libraryName);
                System.out.println("Below you will se how we tried to load it:\n");
                System.out.println(this.format());
                System.out.println("... giving up loading library: " + this.libraryName);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Configuration {
        Release,
        Debug;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OperatingSystem {
        Windows,
        MacOSX,
        Linux;

    }
}

