/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qt;

import com.trolltech.qt.ConnectionException;
import java.lang.reflect.Method;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QNoSuchSlotException
extends ConnectionException {
    private static final long serialVersionUID = 1L;
    private Object reciver;
    private String slotSignature;
    private String message;

    public QNoSuchSlotException(String string) {
        this.message = string != null ? string : "";
    }

    public QNoSuchSlotException(Object object, String string) {
        this.reciver = object;
        this.slotSignature = string;
    }

    @Override
    public String getMessage() {
        if (this.message != null) {
            return this.message;
        }
        if (this.slotSignature.equals("")) {
            return "Slot can't be an empty string";
        }
        String string = "\n\nCould not find slot with signature: " + this.slotSignature + "\n";
        Vector<Method> vector = QNoSuchSlotException.findPossibleFunctionRecursive(this.reciver, this.slotSignature);
        if (!vector.isEmpty()) {
            string = string + "Possible matching methods:\n";
            for (Method method : vector) {
                string = string + "   " + this.methodToString(method) + "\n";
            }
        }
        return string;
    }

    private String methodToString(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        String string = "";
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz = classArray[i];
            String string2 = "";
            if (clazz.isArray()) {
                do {
                    clazz = clazz.getComponentType();
                    string2 = string2 + "[]";
                } while (clazz.isArray());
            }
            string = string + (i > 0 ? ", " : "" + clazz.getName() + string2);
        }
        return method.getName() + "(" + string + ")";
    }

    private static Vector<Method> findPossibleFunctionRecursive(Object object, String string) {
        Class<?> clazz = object.getClass();
        int n = string.indexOf(40);
        String string2 = string.substring(0, n).trim();
        int n2 = string.indexOf(41, n);
        String string3 = string.substring(n + 1, n2).trim();
        String[] stringArray = string3.length() == 0 ? new String[]{} : string3.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].replace(" ", "");
        }
        return QNoSuchSlotException.findPossibleFunctionRecursiveHelper(clazz, string2, stringArray, new Vector<Method>());
    }

    private static Vector<Method> findPossibleFunctionRecursiveHelper(Class clazz, String string, String[] stringArray, Vector<Method> vector) {
        Method[] methodArray;
        for (Method method : methodArray = clazz.getDeclaredMethods()) {
            Class<?>[] classArray;
            if (!method.getName().equalsIgnoreCase(string) || (classArray = method.getParameterTypes()).length != stringArray.length) continue;
            vector.add(method);
        }
        if ((clazz = clazz.getSuperclass()) == null) {
            return vector;
        }
        return QNoSuchSlotException.findPossibleFunctionRecursiveHelper(clazz, string, stringArray, vector);
    }
}

