/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qt.designer;

import com.trolltech.qt.QSignalEmitter;
import com.trolltech.qt.QtPropertyManager;
import com.trolltech.qt.core.QFile;
import com.trolltech.qt.core.QIODevice;
import com.trolltech.qt.core.QObject;
import com.trolltech.qt.core.QRect;
import com.trolltech.qt.core.QSize;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.designer.BoolPropertyHandler;
import com.trolltech.qt.designer.ColorPropertyHandler;
import com.trolltech.qt.designer.EnumPropertyHandler;
import com.trolltech.qt.designer.FontPropertyHandler;
import com.trolltech.qt.designer.IconsetPropertyHandler;
import com.trolltech.qt.designer.Line;
import com.trolltech.qt.designer.NumberPropertyHandler;
import com.trolltech.qt.designer.OrientationPropertyHandler;
import com.trolltech.qt.designer.PalettePropertyHandler;
import com.trolltech.qt.designer.PixmapPropertyHandler;
import com.trolltech.qt.designer.PointPropertyHandler;
import com.trolltech.qt.designer.PropertyHandler;
import com.trolltech.qt.designer.QUiLoaderException;
import com.trolltech.qt.designer.RectPropertyHandler;
import com.trolltech.qt.designer.SetPropertyHandler;
import com.trolltech.qt.designer.SizePolicyPropertyHandler;
import com.trolltech.qt.designer.SizePropertyHandler;
import com.trolltech.qt.designer.StringPropertyHandler;
import com.trolltech.qt.gui.QAction;
import com.trolltech.qt.gui.QApplication;
import com.trolltech.qt.gui.QBoxLayout;
import com.trolltech.qt.gui.QComboBox;
import com.trolltech.qt.gui.QContentsMargins;
import com.trolltech.qt.gui.QDockWidget;
import com.trolltech.qt.gui.QGridLayout;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QLayoutItem;
import com.trolltech.qt.gui.QLayoutItemInterface;
import com.trolltech.qt.gui.QListWidget;
import com.trolltech.qt.gui.QListWidgetItem;
import com.trolltech.qt.gui.QMainWindow;
import com.trolltech.qt.gui.QMenu;
import com.trolltech.qt.gui.QMenuBar;
import com.trolltech.qt.gui.QSizePolicy;
import com.trolltech.qt.gui.QSpacerItem;
import com.trolltech.qt.gui.QStatusBar;
import com.trolltech.qt.gui.QTabWidget;
import com.trolltech.qt.gui.QToolBar;
import com.trolltech.qt.gui.QWidget;
import com.trolltech.qt.xml.QDomDocument;
import com.trolltech.qt.xml.QDomElement;
import com.trolltech.qt.xml.QDomNode;
import com.trolltech.qt.xml.QDomNodeList;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QUiLoader {
    private QIODevice inputDevice;
    private QWidget topParent;
    private QWidget uiWidget;
    private int parseDepth;
    private Object parent;
    private Object object;
    private PropertyReceiver propertyReceiver;
    private HashMap<String, QWidget> widgetPool = new HashMap();
    private HashMap<String, QAction> actions = new HashMap();
    private HashMap<QLabel, String> buddies = new HashMap();
    private static HashSet<String> ignorableStrings;
    private static HashMap<String, PropertyHandler> typeHandlers;
    private static HashMap<String, PropertyHandler> propertyHandlers;

    public static QWidget load(QIODevice qIODevice) throws QUiLoaderException {
        return QUiLoader.load(qIODevice, null);
    }

    public static QWidget load(QIODevice qIODevice, QWidget qWidget) throws QUiLoaderException {
        QUiLoader qUiLoader = new QUiLoader(qIODevice, qWidget);
        qUiLoader.parse();
        return qUiLoader.widget();
    }

    private QUiLoader(QIODevice qIODevice, QWidget qWidget) {
        this.inputDevice = qIODevice;
        this.topParent = qWidget;
    }

    private void parse() throws QUiLoaderException {
        if (!this.inputDevice.isOpen() && !this.inputDevice.open(QIODevice.OpenModeFlag.ReadOnly)) {
            throw new QUiLoaderException("Unable to open iodevice: " + this.inputDevice);
        }
        QDomDocument qDomDocument = new QDomDocument();
        qDomDocument.setContent(this.inputDevice);
        this.object = this.topParent;
        this.parseChildren(qDomDocument, this.topParent);
        this.uiWidget = (QWidget)this.object;
        for (QAction object : this.actions.values()) {
            object.setParent(this.uiWidget);
        }
        for (Map.Entry entry : this.buddies.entrySet()) {
            QWidget qWidget = this.widgetPool.get(entry.getValue());
            ((QLabel)entry.getKey()).setBuddy(qWidget);
        }
    }

    private void parseChildren(QDomNode qDomNode, Object object) throws QUiLoaderException {
        QDomNodeList qDomNodeList = qDomNode.childNodes();
        for (int i = 0; i < qDomNodeList.size(); ++i) {
            this.parent = object;
            this.parse(qDomNodeList.at(i));
        }
    }

    private void parse(QDomNode qDomNode) throws QUiLoaderException {
        String string = qDomNode.nodeName();
        if (string.equals("ui")) {
            this.parseUiRoot(qDomNode);
        } else if (string.equals("widget")) {
            this.parseWidget(qDomNode);
        } else if (string.equals("layout")) {
            this.parseLayout(qDomNode);
        } else if (string.equals("property")) {
            this.parseProperty(qDomNode);
        } else if (string.equals("item")) {
            this.parseItem(qDomNode);
        } else if (string.equals("spacer")) {
            this.parseSpacer(qDomNode);
        } else if (string.equals("connections")) {
            this.parseConnections(qDomNode);
        } else if (string.equals("taborder")) {
            this.parseTabOrder(qDomNode);
        } else if (string.equals("tabstops")) {
            this.parseTabOrder(qDomNode);
        } else if (string.equals("addaction")) {
            this.parseAddAction(qDomNode);
        } else if (string.equals("attribute")) {
            this.parseAttribute(qDomNode);
        } else if (string.equals("action")) {
            this.parseAction(qDomNode);
        } else if (!ignorableStrings.contains(string)) {
            throw new QUiLoaderException("Unknown tag: " + string);
        }
    }

    private void parseUiRoot(QDomNode qDomNode) throws QUiLoaderException {
        QDomElement qDomElement = qDomNode.toElement();
        String string = qDomElement.attribute("version");
        if (!string.equals("4.0")) {
            throw new QUiLoaderException("Unsupported version: " + string + ", expected 4.0");
        }
        String string2 = qDomElement.attribute("language");
        if (!string2.equals("jambi")) {
            throw new QUiLoaderException("Unsupported language: '" + string2 + "', expected 'jambi'");
        }
        this.parseChildren(qDomElement, this.topParent);
    }

    private void parseWidget(QDomNode qDomNode) throws QUiLoaderException {
        Object object;
        QDomElement qDomElement = qDomNode.toElement();
        QObject qObject = (QObject)this.parent;
        String string = qDomElement.attribute("class");
        String string2 = qDomElement.attribute("name");
        Class<? extends QObject> clazz = this.loadClass(string);
        QWidget qWidget = (QWidget)this.createInstance(clazz, qObject);
        if (qWidget instanceof QMenu) {
            this.actions.put(string2, ((QMenu)qWidget).menuAction());
        }
        this.widgetPool.put(string2, qWidget);
        qWidget.setObjectName(string2);
        if (qObject instanceof QMainWindow) {
            object = (QMainWindow)qObject;
            if (string2.equals("centralwidget")) {
                ((QMainWindow)object).setCentralWidget(qWidget);
            } else if (string2.equals("menubar")) {
                ((QMainWindow)object).setMenuBar((QMenuBar)qWidget);
            } else if (string2.equals("statusbar")) {
                ((QMainWindow)object).setStatusBar((QStatusBar)qWidget);
            } else if (!(qWidget instanceof QToolBar) && !(qWidget instanceof QDockWidget)) {
                System.err.println("unhandled child of main window..." + qWidget + ", " + qWidget.objectName());
            }
        } else if (qObject instanceof QTabWidget) {
            object = qDomElement.namedItem("attribute").firstChild().firstChild().nodeValue();
            ((QTabWidget)qObject).addTab(qWidget, (String)object);
        } else if (qObject instanceof QDockWidget) {
            ((QDockWidget)qObject).setWidget(qWidget);
        }
        object = this.swapPropertyReceiver(new QObjectPropertyReceiver(qWidget));
        this.parseChildren(qDomNode, qWidget);
        this.swapPropertyReceiver((PropertyReceiver)object);
        this.object = qWidget;
    }

    private static int parseInt(String string, int n) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return n;
        }
    }

    private void parseLayout(QDomNode qDomNode) throws QUiLoaderException {
        QDomElement qDomElement = qDomNode.toElement();
        Class<? extends QObject> clazz = this.loadClass(qDomElement.attribute("class"));
        QLayout qLayout = null;
        try {
            qLayout = (QLayout)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new QUiLoaderException("Failed to create layout: " + clazz.getName(), exception);
        }
        Object object = this.parent;
        if (object instanceof QWidget) {
            ((QWidget)object).setLayout(qLayout);
        }
        PropertyReceiver propertyReceiver = this.swapPropertyReceiver(new QObjectPropertyReceiver(qLayout));
        this.parseChildren(qDomNode, qLayout);
        this.swapPropertyReceiver(propertyReceiver);
        this.object = qLayout;
    }

    private void parseItem(QDomNode qDomNode) throws QUiLoaderException {
        if (this.parent instanceof QLayout) {
            this.parseLayoutItem(qDomNode);
        } else if (this.parent instanceof QListWidget) {
            this.parseListWidgetItem(qDomNode);
        } else if (this.parent instanceof QComboBox) {
            this.parseComboBoxItem(qDomNode);
        } else {
            System.err.println("Unhandled 'item' for '" + this.parent + "'");
        }
    }

    private void parseComboBoxItem(QDomNode qDomNode) throws QUiLoaderException {
        ContentItemPropertyReceiver contentItemPropertyReceiver = new ContentItemPropertyReceiver();
        PropertyReceiver propertyReceiver = this.swapPropertyReceiver(contentItemPropertyReceiver);
        this.parseChildren(qDomNode, this.parent);
        this.swapPropertyReceiver(propertyReceiver);
        QComboBox qComboBox = (QComboBox)this.parent;
        qComboBox.addItem(contentItemPropertyReceiver.icon, contentItemPropertyReceiver.text);
    }

    private void parseLayoutItem(QDomNode qDomNode) throws QUiLoaderException {
        QDomElement qDomElement = qDomNode.toElement();
        assert (this.parent instanceof QLayout);
        QLayout qLayout = (QLayout)this.parent;
        this.parseChildren(qDomNode, qLayout);
        Object object = this.object;
        if (qLayout instanceof QGridLayout) {
            int n = QUiLoader.parseInt(qDomElement.attribute("row"), 0);
            int n2 = QUiLoader.parseInt(qDomElement.attribute("column"), 0);
            int n3 = QUiLoader.parseInt(qDomElement.attribute("colspan"), 1);
            int n4 = QUiLoader.parseInt(qDomElement.attribute("rowspan"), 1);
            QGridLayout qGridLayout = (QGridLayout)qLayout;
            if (object instanceof QWidget) {
                qGridLayout.addWidget((QWidget)object, n, n2, n4, n3);
            } else if (object instanceof QLayout) {
                qGridLayout.addLayout((QLayout)object, n, n2, n4, n3);
            } else if (object instanceof QLayoutItemInterface) {
                qGridLayout.addItem((QLayoutItemInterface)object, n, n2, n4, n3);
            }
        } else if (object instanceof QWidget) {
            qLayout.addWidget((QWidget)object);
        } else if (object instanceof QLayout) {
            ((QBoxLayout)qLayout).addLayout((QLayout)object);
        } else if (object instanceof QLayoutItem) {
            qLayout.addItem((QLayoutItem)object);
        }
    }

    private void parseListWidgetItem(QDomNode qDomNode) throws QUiLoaderException {
        ContentItemPropertyReceiver contentItemPropertyReceiver = new ContentItemPropertyReceiver();
        PropertyReceiver propertyReceiver = this.swapPropertyReceiver(contentItemPropertyReceiver);
        this.parseChildren(qDomNode, this.parent);
        QListWidget qListWidget = (QListWidget)this.parent;
        qListWidget.addItem(contentItemPropertyReceiver.listWidgetItem());
        this.swapPropertyReceiver(propertyReceiver);
    }

    private void parseSpacer(QDomNode qDomNode) throws QUiLoaderException {
        PropertyReceiver propertyReceiver = this.swapPropertyReceiver(new SpacerPropertyReceiver());
        this.parseChildren(qDomNode, this.parent);
        this.object = ((SpacerPropertyReceiver)this.propertyReceiver).spacerItem();
        this.swapPropertyReceiver(propertyReceiver);
    }

    private void parseProperty(QDomNode qDomNode) throws QUiLoaderException {
        QDomElement qDomElement = qDomNode.toElement();
        String string = qDomElement.attribute("name");
        assert (!qDomElement.isNull());
        QDomElement qDomElement2 = qDomElement.firstChildElement();
        PropertyHandler propertyHandler = propertyHandlers.get(string);
        if (propertyHandler == null) {
            propertyHandler = typeHandlers.get(qDomElement2.nodeName());
        }
        if (propertyHandler == null) {
            throw new QUiLoaderException("No handler for property " + string + ", of type: " + qDomElement2.nodeName());
        }
        Object object = propertyHandler.create(qDomElement2);
        this.propertyReceiver.setProperty(string, object);
    }

    private QObject createInstance(Class<? extends QObject> clazz, QObject qObject) throws QUiLoaderException {
        try {
            if (QWidget.class.isAssignableFrom(clazz)) {
                if (qObject instanceof QWidget) {
                    return clazz.getConstructor(QWidget.class).newInstance((QWidget)qObject);
                }
                return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            if (QLayout.class.isAssignableFrom(clazz)) {
                if (qObject instanceof QWidget) {
                    Constructor<? extends QObject> constructor = clazz.getConstructor(QWidget.class);
                    return constructor.newInstance(qObject);
                }
                return (QLayout)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return clazz.getConstructor(QObject.class).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new QUiLoaderException("Failed to create instance", exception);
        }
    }

    private Class<? extends QObject> loadClass(String string) throws QUiLoaderException {
        Class<QObject> clazz;
        if (string.equals("Line")) {
            return Line.class;
        }
        try {
            clazz = Class.forName(string).asSubclass(QObject.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = Class.forName("com.trolltech.qt.gui." + string).asSubclass(QObject.class);
            }
            catch (Exception exception) {
                throw new QUiLoaderException("Failed to load class", exception);
            }
        }
        catch (Exception exception) {
            throw new QUiLoaderException("Failed to load class", exception);
        }
        return clazz;
    }

    private void setProperty(QObject qObject, String string, Object object) {
        try {
            QtPropertyManager.Entry entry = QtPropertyManager.findPropertiesRecursive(qObject.getClass()).get(string);
            if (string.equals("geometry") && qObject.isWidgetType() && ((QWidget)qObject).isWindow()) {
                QWidget qWidget = (QWidget)qObject;
                QRect qRect = (QRect)object;
                if (qRect.x() == 0 && qRect.y() == 0) {
                    qWidget.resize(qRect.width(), qRect.height());
                } else {
                    qWidget.setGeometry(qRect);
                }
                return;
            }
            if (string.equals("shortcut") && qObject instanceof QAction && object instanceof String) {
                ((QAction)qObject).setShortcut((String)object);
                return;
            }
            if (string.equals("buddy") && qObject instanceof QLabel) {
                this.buddies.put((QLabel)qObject, (String)object);
                return;
            }
            if (string.equals("icon") && qObject instanceof QWidget && ((QWidget)qObject).isWindow()) {
                ((QWidget)qObject).setWindowIcon((QIcon)object);
                return;
            }
            if (string.endsWith("Margin") && qObject instanceof QLayout) {
                this.writeLayoutMargin((QLayout)qObject, string, object);
                return;
            }
            if (string.endsWith("Spacing") && qObject instanceof QGridLayout) {
                this.writeLayoutSpacing((QGridLayout)qObject, string, object);
                return;
            }
            if (object == null) {
                System.out.println("Null value for: " + string + ", " + entry + ", " + object);
            }
            if (entry == null) {
                System.out.println("No property entry for: " + string + ", " + object + " in " + qObject);
            }
            if (null != entry && object != null) {
                entry.write.invoke((Object)qObject, object);
            }
        }
        catch (Exception exception) {
            System.err.println("setProperty failed: value=" + object + ", name=" + string + ", on=" + qObject);
            exception.printStackTrace();
        }
    }

    private void writeLayoutMargin(QLayout qLayout, String string, Object object) {
        int n = (Integer)object;
        QContentsMargins qContentsMargins = qLayout.getContentsMargins();
        if (string.equals("rightMargin")) {
            qContentsMargins.right = n;
        } else if (string.equals("leftMargin")) {
            qContentsMargins.left = n;
        } else if (string.equals("topMargin")) {
            qContentsMargins.top = n;
        } else if (string.equals("bottomMargin")) {
            qContentsMargins.bottom = n;
        }
        qLayout.setContentsMargins(qContentsMargins);
    }

    private void writeLayoutSpacing(QGridLayout qGridLayout, String string, Object object) {
        if (string.equals("verticalSpacing")) {
            qGridLayout.setVerticalSpacing((Integer)object);
        } else if (string.equals("horizontalSpacing")) {
            qGridLayout.setHorizontalSpacing((Integer)object);
        }
    }

    private void parseConnections(QDomNode qDomNode) throws QUiLoaderException {
        QDomElement qDomElement = qDomNode.toElement();
        assert (!qDomElement.isNull());
        try {
            QDomElement qDomElement2 = qDomElement.firstChildElement();
            while (!qDomElement2.isNull()) {
                if (qDomElement2.nodeName().equals("connection")) {
                    int n;
                    String string = qDomElement2.namedItem("sender").firstChild().nodeValue();
                    String string2 = qDomElement2.namedItem("signal").firstChild().nodeValue();
                    String string3 = qDomElement2.namedItem("receiver").firstChild().nodeValue();
                    String string4 = qDomElement2.namedItem("slot").firstChild().nodeValue();
                    QObject qObject = this.widgetPool.get(string);
                    if (qObject == null) {
                        qObject = this.actions.get(string);
                    }
                    if (qObject == null) {
                        throw new QUiLoaderException("Unknown sender: '" + string + "'");
                    }
                    QObject qObject2 = this.widgetPool.get(string3);
                    if (qObject2 == null) {
                        throw new QUiLoaderException("Unknown sender: '" + string3 + "'");
                    }
                    int n2 = string2.indexOf(60);
                    if (n2 > 0) {
                        string2 = string2.substring(0, n2);
                    }
                    if ((n = string2.indexOf(40)) > 0) {
                        string2 = string2.substring(0, n);
                    }
                    try {
                        QSignalEmitter.AbstractSignal abstractSignal = (QSignalEmitter.AbstractSignal)qObject.getClass().getField(string2).get(qObject);
                        abstractSignal.connect(qObject2, string4);
                    }
                    catch (Exception exception) {
                        throw new QUiLoaderException("Connection failed: " + string + "." + string2 + " to " + string3 + "." + string4, exception);
                    }
                }
                qDomElement2 = qDomElement2.nextSiblingElement();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void parseTabOrder(QDomNode qDomNode) {
        QDomElement qDomElement = qDomNode.toElement();
        if (qDomElement.isNull()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        QDomElement qDomElement2 = qDomElement.firstChildElement();
        while (!qDomElement2.isNull()) {
            assert (!qDomElement2.isNull());
            if (qDomElement2.nodeName().equals("tabstop")) {
                arrayList.add(qDomElement2.firstChild().nodeValue());
            }
            qDomElement2 = qDomElement2.nextSiblingElement();
        }
        for (int i = 0; i < arrayList.size() - 1; ++i) {
            QWidget qWidget = this.widgetPool.get(arrayList.get(i));
            QWidget qWidget2 = this.widgetPool.get(arrayList.get(i + 1));
            QWidget.setTabOrder(qWidget, qWidget2);
        }
    }

    private void parseAddAction(QDomNode qDomNode) {
        QDomElement qDomElement = qDomNode.toElement();
        if (qDomElement.isNull()) {
            return;
        }
        String string = qDomElement.attribute("name");
        if (string.equals("separator")) {
            if (this.parent instanceof QMenu) {
                ((QMenu)this.parent).addSeparator();
            } else if (this.parent instanceof QToolBar) {
                ((QToolBar)this.parent).addSeparator();
            }
            return;
        }
        QAction qAction = this.existingAction(string);
        if (this.parent instanceof QWidget) {
            ((QWidget)this.parent).addAction(qAction);
        }
    }

    private QAction existingAction(String string) {
        QAction qAction = this.actions.get(string);
        if (qAction == null) {
            qAction = new QAction(null);
            qAction.setObjectName(string);
            this.actions.put(string, qAction);
        }
        return qAction;
    }

    private void parseAttribute(QDomNode qDomNode) throws QUiLoaderException {
        AttributeReceiver attributeReceiver = new AttributeReceiver();
        PropertyReceiver propertyReceiver = this.swapPropertyReceiver(attributeReceiver);
        this.parseProperty(qDomNode);
        this.swapPropertyReceiver(propertyReceiver);
    }

    private void parseAction(QDomNode qDomNode) throws QUiLoaderException {
        QDomElement qDomElement = qDomNode.toElement();
        if (qDomElement.isNull()) {
            return;
        }
        String string = qDomElement.attribute("name");
        QAction qAction = this.existingAction(string);
        QObjectPropertyReceiver qObjectPropertyReceiver = new QObjectPropertyReceiver(qAction);
        PropertyReceiver propertyReceiver = this.swapPropertyReceiver(qObjectPropertyReceiver);
        this.parseChildren(qDomNode, qAction);
        this.swapPropertyReceiver(propertyReceiver);
    }

    private QWidget widget() {
        return this.uiWidget;
    }

    private Object swapObject(Object object) {
        Object object2 = this.object;
        this.object = object;
        return object2;
    }

    private PropertyReceiver swapPropertyReceiver(PropertyReceiver propertyReceiver) {
        PropertyReceiver propertyReceiver2 = this.propertyReceiver;
        this.propertyReceiver = propertyReceiver;
        return propertyReceiver2;
    }

    private QUiLoader self() {
        return this;
    }

    public static void main(String[] stringArray) throws QUiLoaderException {
        QApplication.initialize(stringArray);
        QFile qFile = new QFile(stringArray[0]);
        long l = System.currentTimeMillis();
        QWidget qWidget = QUiLoader.load(qFile);
        long l2 = System.currentTimeMillis();
        System.out.println("loading took: " + (l2 - l));
        qFile.dispose();
        qWidget.show();
        QApplication.exec();
    }

    static {
        typeHandlers = new HashMap();
        typeHandlers.put("cstring", new StringPropertyHandler());
        typeHandlers.put("rect", new RectPropertyHandler());
        typeHandlers.put("string", new StringPropertyHandler());
        typeHandlers.put("number", new NumberPropertyHandler());
        typeHandlers.put("sizepolicy", new SizePolicyPropertyHandler());
        typeHandlers.put("size", new SizePropertyHandler());
        typeHandlers.put("point", new PointPropertyHandler());
        typeHandlers.put("bool", new BoolPropertyHandler());
        typeHandlers.put("enum", new EnumPropertyHandler());
        typeHandlers.put("font", new FontPropertyHandler());
        typeHandlers.put("palette", new PalettePropertyHandler());
        typeHandlers.put("color", new ColorPropertyHandler());
        typeHandlers.put("pixmap", new PixmapPropertyHandler());
        typeHandlers.put("iconset", new IconsetPropertyHandler());
        typeHandlers.put("set", new SetPropertyHandler());
        propertyHandlers = new HashMap();
        propertyHandlers.put("orientation", new OrientationPropertyHandler());
        ignorableStrings = new HashSet();
        ignorableStrings.add("author");
        ignorableStrings.add("class");
        ignorableStrings.add("comment");
        ignorableStrings.add("customwidgets");
        ignorableStrings.add("exportmacro");
        ignorableStrings.add("pixmapfunction");
        ignorableStrings.add("resources");
    }

    private class AttributeReceiver
    implements PropertyReceiver {
        private AttributeReceiver() {
        }

        private QMainWindow mainWindow() {
            QWidget qWidget;
            QWidget qWidget2 = qWidget = QUiLoader.this.parent instanceof QWidget ? ((QWidget)QUiLoader.this.parent).window() : null;
            if (qWidget instanceof QMainWindow) {
                return (QMainWindow)qWidget;
            }
            return null;
        }

        public void setProperty(String string, Object object) {
            QMainWindow qMainWindow;
            if (string.equals("toolBarArea")) {
                QMainWindow qMainWindow2 = this.mainWindow();
                if (qMainWindow2 != null && QUiLoader.this.parent instanceof QToolBar) {
                    qMainWindow2.addToolBar(Qt.ToolBarArea.resolve((Integer)object), (QToolBar)QUiLoader.this.parent);
                }
            } else if (string.equals("dockWidgetArea") && (qMainWindow = this.mainWindow()) != null && QUiLoader.this.parent instanceof QDockWidget) {
                qMainWindow.addDockWidget(Qt.DockWidgetArea.resolve((Integer)object), (QDockWidget)QUiLoader.this.parent);
            }
        }
    }

    private class ContentItemPropertyReceiver
    implements PropertyReceiver {
        String text;
        QIcon icon;

        private ContentItemPropertyReceiver() {
        }

        public void setProperty(String string, Object object) {
            if (string.equals("text")) {
                this.text = (String)object;
            } else if (string.equals("icon")) {
                this.icon = (QIcon)object;
            }
        }

        QListWidgetItem listWidgetItem() {
            return new QListWidgetItem(this.icon, this.text);
        }
    }

    private class SpacerPropertyReceiver
    implements PropertyReceiver {
        Qt.Orientation orientation;
        QSize size;

        private SpacerPropertyReceiver() {
        }

        public void setProperty(String string, Object object) {
            if (string.equals("orientation")) {
                this.orientation = (Qt.Orientation)object;
            } else if (string.equals("sizeHint")) {
                this.size = (QSize)object;
            }
        }

        QSpacerItem spacerItem() {
            return new QSpacerItem(this.size.width(), this.size.height(), this.orientation == Qt.Orientation.Horizontal ? QSizePolicy.Policy.Expanding : QSizePolicy.Policy.Minimum, this.orientation == Qt.Orientation.Horizontal ? QSizePolicy.Policy.Minimum : QSizePolicy.Policy.Expanding);
        }
    }

    private class QObjectPropertyReceiver
    implements PropertyReceiver {
        QObject object;

        QObjectPropertyReceiver(QObject qObject) {
            this.object = qObject;
        }

        public void setProperty(String string, Object object) {
            QUiLoader.this.self().setProperty(this.object, string, object);
        }
    }

    private static interface PropertyReceiver {
        public void setProperty(String var1, Object var2);
    }
}

