/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qt.core;

import java.util.ArrayList;
import java.util.List;

public abstract class QMessageHandler {
    private static List<QMessageHandler> handlers;

    public abstract void debug(String var1);

    public abstract void warning(String var1);

    public abstract void critical(String var1);

    public abstract void fatal(String var1);

    public static void installMessageHandler(QMessageHandler qMessageHandler) {
        if (handlers == null) {
            handlers = new ArrayList<QMessageHandler>();
            QMessageHandler.installMessageHandlerProxy();
        }
        handlers.add(qMessageHandler);
    }

    public static void removeMessageHandler(QMessageHandler qMessageHandler) {
        if (handlers != null) {
            handlers.remove(qMessageHandler);
            if (handlers.isEmpty()) {
                QMessageHandler.removeMessageHandlerProxy();
                handlers = null;
            }
        }
    }

    private static boolean process(int n, String string) {
        if (handlers == null) {
            return false;
        }
        switch (n) {
            case 0: {
                for (QMessageHandler qMessageHandler : handlers) {
                    qMessageHandler.debug(string);
                }
                break;
            }
            case 1: {
                for (QMessageHandler qMessageHandler : handlers) {
                    qMessageHandler.warning(string);
                }
                break;
            }
            case 2: {
                for (QMessageHandler qMessageHandler : handlers) {
                    qMessageHandler.critical(string);
                }
                break;
            }
            case 3: {
                for (QMessageHandler qMessageHandler : handlers) {
                    qMessageHandler.fatal(string);
                }
                break;
            }
        }
        return true;
    }

    private static native void installMessageHandlerProxy();

    private static native void removeMessageHandlerProxy();

    static {
        try {
            Class.forName("com.trolltech.qt.QtJambi_LibraryInitializer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

