/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qt;

import com.trolltech.qt.QPropertyException;
import com.trolltech.qt.QtJambiGeneratedClass;
import com.trolltech.qt.QtProperty;
import com.trolltech.qt.QtPropertyDesignable;
import com.trolltech.qt.QtPropertyOrder;
import com.trolltech.qt.QtPropertyReader;
import com.trolltech.qt.QtPropertyResetter;
import com.trolltech.qt.QtPropertyWriter;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QTextEdit;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class QtPropertyManager {
    private static Class[] QT_PROPERTY_ANNOTATION_CLASSES = new Class[]{QtPropertyReader.class, QtPropertyWriter.class, QtPropertyResetter.class};
    private static Method DEFAULT_TRUE = null;
    private static Method DEFAULT_FALSE = null;
    private static HashMap<Class, HashMap<String, Entry>> recursivePropertyTable;

    private static void __qt_default_true() {
    }

    private static void __qt_default_false() {
    }

    private static String matchAndLowercase(String string, String string2) {
        if (string.length() == string2.length() + 1) {
            return String.valueOf(Character.toLowerCase(string.charAt(string2.length())));
        }
        return Character.toLowerCase(string.charAt(string2.length())) + string.substring(string2.length() + 1);
    }

    private static String propertyNameForRead(QtPropertyReader qtPropertyReader, Method method) {
        String string = qtPropertyReader.name();
        if (string.length() == 0) {
            string = method.getName();
            if (string.startsWith("get")) {
                string = QtPropertyManager.matchAndLowercase(string, "get");
            } else if (method.getReturnType() == Boolean.TYPE || method.getReturnType() == Boolean.class) {
                if (string.startsWith("is")) {
                    string = QtPropertyManager.matchAndLowercase(string, "is");
                } else if (string.startsWith("has")) {
                    string = QtPropertyManager.matchAndLowercase(string, "has");
                }
            }
        }
        return string;
    }

    private static String stripAndLowercase(String string, int n) {
        if (string.length() == n + 1) {
            return String.valueOf(Character.toLowerCase(string.charAt(n)));
        }
        return Character.toLowerCase(string.charAt(n)) + string.substring(n + 1);
    }

    private static String propertyNameForWrite(QtPropertyWriter qtPropertyWriter, Method method) {
        String string = qtPropertyWriter.name();
        if (string.length() == 0 && (string = method.getName()).startsWith("set")) {
            string = QtPropertyManager.stripAndLowercase(string, 3);
        }
        return string;
    }

    private static String propertyNameForReset(QtPropertyResetter qtPropertyResetter, Method method) {
        String string = qtPropertyResetter.name();
        if (string.length() == 0 && (string = method.getName()).startsWith("reset")) {
            string = QtPropertyManager.stripAndLowercase(string, 5);
        }
        return string;
    }

    private static Method findMethod(Class<?> clazz, String string, Class ... classArray) {
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static boolean hasOtherAnnotations(Method method, Class clazz) {
        for (Class clazz2 : QT_PROPERTY_ANNOTATION_CLASSES) {
            if (clazz2 == clazz || !method.isAnnotationPresent(clazz2)) continue;
            return true;
        }
        return false;
    }

    private static Method findReadMethodForProperty(Class clazz, String string, Class clazz2) {
        Method method = QtPropertyManager.findMethod(clazz, string, new Class[0]);
        if (method == null) {
            string = QtPropertyManager.upcaseFirst(string);
            method = QtPropertyManager.findMethod(clazz, "get" + string, new Class[0]);
            if (method == null && (clazz2 == Boolean.class || clazz2 == Boolean.TYPE) && (method = QtPropertyManager.findMethod(clazz, "is" + string, new Class[0])) == null) {
                method = QtPropertyManager.findMethod(clazz, "has" + string, new Class[0]);
            }
        }
        if (method != null) {
            if (clazz2 != null && !clazz2.equals(method.getReturnType())) {
                throw new QPropertyException("Wrong type on read method of '" + string + "', expected: " + clazz2 + ", method=" + method);
            }
            if (QtPropertyManager.hasOtherAnnotations(method, QtPropertyReader.class)) {
                return null;
            }
            QtPropertyReader qtPropertyReader = method.getAnnotation(QtPropertyReader.class);
            if (qtPropertyReader != null && !qtPropertyReader.name().equals(string)) {
                return null;
            }
        }
        return method;
    }

    private static Method findWriteMethodForProperty(Class clazz, String string, Class clazz2) {
        string = QtPropertyManager.upcaseFirst(string);
        Method method = QtPropertyManager.findMethod(clazz, "set" + string, clazz2);
        if (method != null) {
            if (QtPropertyManager.hasOtherAnnotations(method, QtPropertyWriter.class)) {
                return null;
            }
            QtPropertyWriter qtPropertyWriter = method.getAnnotation(QtPropertyWriter.class);
            if (qtPropertyWriter != null && !qtPropertyWriter.name().equals(string)) {
                return null;
            }
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length != 1 || !classArray[0].equals(clazz2)) {
                return null;
            }
        }
        return method;
    }

    private static String upcaseFirst(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    private static void checkDesignable(Entry entry) {
        QtPropertyDesignable qtPropertyDesignable = entry.read.getAnnotation(QtPropertyDesignable.class);
        if (qtPropertyDesignable != null) {
            String string = qtPropertyDesignable.value();
            if (string.equals("true")) {
                entry.designable = DEFAULT_TRUE;
            } else if (string.equals("false")) {
                entry.designable = DEFAULT_FALSE;
            } else {
                try {
                    Method method = entry.read.getDeclaringClass().getMethod(string, new Class[0]);
                    if (method.getReturnType() == Boolean.TYPE) {
                        entry.designable = method;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private static int sortOrder(Method method) {
        QtPropertyOrder qtPropertyOrder = method.getAnnotation(QtPropertyOrder.class);
        return qtPropertyOrder != null ? qtPropertyOrder.value() : 0;
    }

    private static void findPropertiesRecursive_helper(HashMap<String, Entry> hashMap, Class clazz) {
        if (clazz == null) {
            return;
        }
        QtPropertyManager.findPropertiesRecursive_helper(hashMap, clazz.getSuperclass());
        for (Entry entry : QtPropertyManager.findProperties(clazz).values()) {
            hashMap.put(entry.name, entry);
        }
    }

    public static HashMap<String, Entry> findPropertiesRecursive(Class clazz) {
        HashMap<String, Entry> hashMap = recursivePropertyTable.get(clazz);
        if (hashMap == null) {
            hashMap = new HashMap();
            QtPropertyManager.findPropertiesRecursive_helper(hashMap, clazz);
            recursivePropertyTable.put(clazz, hashMap);
        }
        return hashMap;
    }

    public static List<QtProperty> properties(Object object) {
        ArrayList<QtProperty> arrayList = new ArrayList<QtProperty>();
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            HashMap<String, Entry> hashMap = QtPropertyManager.findProperties(clazz);
            for (Entry entry : hashMap.values()) {
                arrayList.add(new QtProperty(entry.writable, entry.isDesignable(object), entry.reset != null, entry.name));
            }
        }
        return arrayList;
    }

    public static HashMap<String, Entry> findProperties(Class clazz) {
        HashMap<String, Entry> hashMap = new HashMap<String, Entry>();
        Method[] methodArray = clazz.getDeclaredMethods();
        QtPropertyManager.findReadAnnotatedProperties(hashMap, methodArray);
        QtPropertyManager.findWriteAnnotatedProperties(hashMap, methodArray);
        QtPropertyManager.findResetAnnotatedProperties(hashMap, methodArray);
        QtPropertyManager.findNamePatternProperties(hashMap, clazz, methodArray);
        for (Entry object : hashMap.values()) {
            if (object.readable) {
                if (object.read == null) {
                    object.read = QtPropertyManager.findReadMethodForProperty(clazz, object.name, object.type());
                }
            } else {
                object.read = null;
            }
            if (object.read != null) {
                QtPropertyManager.checkDesignable(object);
                object.sortOrder = QtPropertyManager.sortOrder(object.read);
            }
            if (object.writable) {
                if (object.write != null) continue;
                object.write = QtPropertyManager.findWriteMethodForProperty(clazz, object.name, object.type());
                continue;
            }
            object.write = null;
        }
        List<Entry> list = QtPropertyManager.customSetForClass(clazz);
        if (list != null) {
            for (Entry entry : list) {
                hashMap.put(entry.name, entry);
            }
        }
        return hashMap;
    }

    private static void findResetAnnotatedProperties(HashMap<String, Entry> hashMap, Method[] methodArray) {
        for (Method method : methodArray) {
            QtPropertyResetter qtPropertyResetter = method.getAnnotation(QtPropertyResetter.class);
            if (qtPropertyResetter == null) continue;
            String string = QtPropertyManager.propertyNameForReset(qtPropertyResetter, method);
            Entry entry = hashMap.get(string);
            if (entry == null) {
                entry = new Entry(string);
                hashMap.put(string, entry);
            }
            entry.reset = method;
        }
    }

    private static void findWriteAnnotatedProperties(HashMap<String, Entry> hashMap, Method[] methodArray) {
        for (Method method : methodArray) {
            QtPropertyWriter qtPropertyWriter = method.getAnnotation(QtPropertyWriter.class);
            if (qtPropertyWriter == null) continue;
            String string = QtPropertyManager.propertyNameForWrite(qtPropertyWriter, method);
            Entry entry = hashMap.get(string);
            if (entry == null) {
                entry = new Entry(string);
                hashMap.put(string, entry);
            }
            entry.writable = qtPropertyWriter.enabled();
            entry.write = method;
        }
    }

    private static void findReadAnnotatedProperties(HashMap<String, Entry> hashMap, Method[] methodArray) {
        for (Method method : methodArray) {
            QtPropertyReader qtPropertyReader = method.getAnnotation(QtPropertyReader.class);
            if (qtPropertyReader == null) continue;
            String string = QtPropertyManager.propertyNameForRead(qtPropertyReader, method);
            Entry entry = hashMap.get(string);
            if (entry != null) {
                throw new QPropertyException("Duplicate property '" + string + "', " + entry.read + " and " + method);
            }
            entry = new Entry(string);
            entry.readable = qtPropertyReader.enabled();
            entry.read = method;
            hashMap.put(string, entry);
        }
    }

    private static void findNamePatternProperties(HashMap<String, Entry> hashMap, Class clazz, Method[] methodArray) {
        for (Method method : methodArray) {
            String string;
            String string2 = method.getName();
            if (method.getDeclaringClass().isAnnotationPresent(QtJambiGeneratedClass.class) || !string2.startsWith("set") || method.getParameterTypes().length != 1 || method.getParameterTypes()[0].isArray() || string2.length() <= 3 || !Character.isUpperCase(string2.charAt(3)) || hashMap.containsKey(string = Character.toLowerCase(string2.charAt(3)) + string2.substring(4))) continue;
            Method method2 = QtPropertyManager.findMethod(clazz, string, new Class[0]);
            if (method2 == null) {
                method2 = QtPropertyManager.findMethod(clazz, "get" + string2.substring(3), new Class[0]);
            }
            if (method2 == null && (method.getParameterTypes()[0] == Boolean.class || method.getParameterTypes()[0] == Boolean.TYPE) && (method2 = QtPropertyManager.findMethod(clazz, "is" + string2.substring(3), new Class[0])) == null) {
                method2 = QtPropertyManager.findMethod(clazz, "has" + string2.substring(3), new Class[0]);
            }
            if (method2 == null) continue;
            Entry entry = new Entry(string);
            entry.read = method2;
            entry.write = method;
            entry.readable = true;
            entry.writable = true;
            hashMap.put(string, entry);
        }
    }

    private static List<Entry> customSetForClass(Class<?> clazz) {
        try {
            if (clazz == QTextEdit.class) {
                ArrayList<Entry> arrayList = new ArrayList<Entry>();
                Entry entry = new Entry("html");
                entry.read = clazz.getMethod("toHtml", new Class[0]);
                entry.write = clazz.getMethod("setHtml", String.class);
                entry.designable = DEFAULT_TRUE;
                arrayList.add(entry);
                return arrayList;
            }
            if (clazz == QDialog.class) {
                ArrayList<Entry> arrayList = new ArrayList<Entry>();
                Entry entry = new Entry("modal");
                entry.read = clazz.getMethod("isModal", new Class[0]);
                entry.write = clazz.getMethod("setModal", Boolean.TYPE);
                entry.designable = DEFAULT_TRUE;
                arrayList.add(entry);
                return arrayList;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static Object readProperty(Object object, String string) {
        HashMap<String, Entry> hashMap = QtPropertyManager.findPropertiesRecursive(object.getClass());
        Entry entry = hashMap.get(string);
        if (entry == null) {
            throw new QPropertyException("Property '" + string + "' not found in " + object);
        }
        if (entry.read == null) {
            throw new QPropertyException("Property '" + string + "' is not readable");
        }
        try {
            return entry.read.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            System.err.println("Failed to read property '" + string + "' in " + object);
            exception.printStackTrace();
            return null;
        }
    }

    public static void writeProperty(Object object, String string, Object object2) {
        HashMap<String, Entry> hashMap = QtPropertyManager.findPropertiesRecursive(object.getClass());
        Entry entry = hashMap.get(string);
        if (entry == null) {
            throw new QPropertyException("Property '" + string + "' not found in " + object);
        }
        if (entry.write == null) {
            throw new QPropertyException("Property '" + string + "' is not writable");
        }
        try {
            entry.write.invoke(object, object2);
        }
        catch (Exception exception) {
            System.err.println("Failed to write property '" + string + "' in " + object);
            exception.printStackTrace();
        }
    }

    public static void resetProperty(Object object, String string) {
        HashMap<String, Entry> hashMap = QtPropertyManager.findPropertiesRecursive(object.getClass());
        Entry entry = hashMap.get(string);
        if (entry == null) {
            throw new QPropertyException("Property '" + string + "' not found in " + object);
        }
        if (entry.reset == null) {
            throw new QPropertyException("Property '" + string + "' is not resettable");
        }
        try {
            entry.reset.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            System.err.println("Failed to reset property '" + string + "' in " + object);
            exception.printStackTrace();
        }
    }

    static {
        try {
            DEFAULT_TRUE = QtPropertyManager.class.getDeclaredMethod("__qt_default_true", new Class[0]);
            DEFAULT_FALSE = QtPropertyManager.class.getDeclaredMethod("__qt_default_false", new Class[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        recursivePropertyTable = new HashMap();
    }

    public static class Entry {
        public String name;
        public Method read;
        public Method write;
        public Method reset;
        public Method designable;
        public int sortOrder;
        boolean readable = true;
        boolean writable = false;

        public Entry(String string) {
            this.name = string;
        }

        public boolean isDesignable(Object object) {
            if (this.designable == null || this.designable == DEFAULT_TRUE) {
                return true;
            }
            if (this.designable == DEFAULT_FALSE) {
                return false;
            }
            try {
                return (Boolean)this.designable.invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }

        public Class type() {
            if (this.read != null) {
                return this.read.getReturnType();
            }
            if (this.write != null) {
                return this.write.getParameterTypes()[0];
            }
            return null;
        }
    }
}

