/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qt;

import com.trolltech.qt.QtJambi_LibraryInitializer;

public class QNativePointer {
    private long m_ptr;
    private Type m_type;
    private int m_knownSize;
    private AutoDeleteMode m_autodelete;
    private int m_indirections;
    private boolean m_verification_enabled = true;

    public QNativePointer(Type type) {
        this(type, 1);
    }

    public QNativePointer(Type type, int n) {
        this(type, n, 1);
    }

    public QNativePointer(Type type, int n, int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("level of indirection must be at least 1");
        }
        if (n == 0) {
            throw new IllegalArgumentException("size must be at least 1");
        }
        this.m_ptr = QNativePointer.createPointer(type.ordinal(), n, n2);
        this.m_type = type;
        this.m_knownSize = n;
        this.m_indirections = n2;
        this.m_autodelete = n == 1 ? AutoDeleteMode.Delete : AutoDeleteMode.DeleteArray;
    }

    private QNativePointer(int n, int n2, int n3) {
        this(QNativePointer.typeOf(n), n2, n3);
    }

    private QNativePointer() {
        this.m_knownSize = -1;
        this.m_autodelete = AutoDeleteMode.None;
    }

    public boolean booleanValue() {
        return this.booleanAt(0);
    }

    public byte byteValue() {
        return this.byteAt(0);
    }

    public char charValue() {
        return this.charAt(0);
    }

    public short shortValue() {
        return this.shortAt(0);
    }

    public int intValue() {
        return this.intAt(0);
    }

    public long longValue() {
        return this.longAt(0);
    }

    public float floatValue() {
        return this.floatAt(0);
    }

    public double doubleValue() {
        return this.doubleAt(0);
    }

    public QNativePointer pointerValue() {
        return this.pointerAt(0);
    }

    public String stringValue() {
        return this.stringAt(0);
    }

    public void setBooleanValue(boolean bl) {
        this.setBooleanAt(0, bl);
    }

    public void setByteValue(byte by) {
        this.setByteAt(0, by);
    }

    public void setCharValue(char c) {
        this.setCharAt(0, c);
    }

    public void setShortValue(short s) {
        this.setShortAt(0, s);
    }

    public void setIntValue(int n) {
        this.setIntAt(0, n);
    }

    public void setLongValue(long l) {
        this.setLongAt(0, l);
    }

    public void setFloatValue(float f) {
        this.setFloatAt(0, f);
    }

    public void setDoubleValue(double d) {
        this.setDoubleAt(0, d);
    }

    public void setPointerValue(QNativePointer qNativePointer) {
        this.setPointerAt(0, qNativePointer);
    }

    public void setStringValue(String string) {
        this.setStringAt(0, string);
    }

    public boolean booleanAt(int n) {
        this.verifyAccess(Type.Boolean, n);
        return QNativePointer.readBoolean(this.m_ptr, n);
    }

    public byte byteAt(int n) {
        this.verifyAccess(Type.Byte, n);
        return QNativePointer.readByte(this.m_ptr, n);
    }

    public char charAt(int n) {
        this.verifyAccess(Type.Char, n);
        return QNativePointer.readChar(this.m_ptr, n);
    }

    public short shortAt(int n) {
        this.verifyAccess(Type.Short, n);
        return QNativePointer.readShort(this.m_ptr, n);
    }

    public int intAt(int n) {
        this.verifyAccess(Type.Int, n);
        return QNativePointer.readInt(this.m_ptr, n);
    }

    public long longAt(int n) {
        this.verifyAccess(Type.Long, n);
        return QNativePointer.readLong(this.m_ptr, n);
    }

    public float floatAt(int n) {
        this.verifyAccess(Type.Float, n);
        return QNativePointer.readFloat(this.m_ptr, n);
    }

    public double doubleAt(int n) {
        this.verifyAccess(Type.Double, n);
        return QNativePointer.readDouble(this.m_ptr, n);
    }

    public QNativePointer pointerAt(int n) {
        this.verifyAccess(Type.Pointer, n);
        long l = QNativePointer.readPointer(this.m_ptr, n);
        return QNativePointer.fromNative(l, this.m_type, this.m_indirections - 1);
    }

    public String stringAt(int n) {
        this.verifyAccess(Type.String, n);
        return QNativePointer.readString(this.m_ptr, n);
    }

    public void setBooleanAt(int n, boolean bl) {
        this.verifyAccess(Type.Boolean, n);
        QNativePointer.writeBoolean(this.m_ptr, n, bl);
    }

    public void setByteAt(int n, byte by) {
        this.verifyAccess(Type.Byte, n);
        QNativePointer.writeByte(this.m_ptr, n, by);
    }

    public void setCharAt(int n, char c) {
        this.verifyAccess(Type.Char, n);
        QNativePointer.writeChar(this.m_ptr, n, c);
    }

    public void setShortAt(int n, short s) {
        this.verifyAccess(Type.Short, n);
        QNativePointer.writeShort(this.m_ptr, n, s);
    }

    public void setIntAt(int n, int n2) {
        this.verifyAccess(Type.Int, n);
        QNativePointer.writeInt(this.m_ptr, n, n2);
    }

    public void setLongAt(int n, long l) {
        this.verifyAccess(Type.Long, n);
        QNativePointer.writeLong(this.m_ptr, n, l);
    }

    public void setFloatAt(int n, float f) {
        this.verifyAccess(Type.Float, n);
        QNativePointer.writeFloat(this.m_ptr, n, f);
    }

    public void setDoubleAt(int n, double d) {
        this.verifyAccess(Type.Double, n);
        QNativePointer.writeDouble(this.m_ptr, n, d);
    }

    public void setPointerAt(int n, QNativePointer qNativePointer) {
        this.verifyAccess(Type.Pointer, n);
        if (qNativePointer != null) {
            qNativePointer.setAutoDeleteMode(AutoDeleteMode.None);
        }
        QNativePointer.writePointer(this.m_ptr, n, qNativePointer == null ? 0L : qNativePointer.m_ptr);
    }

    public void setStringAt(int n, String string) {
        this.verifyAccess(Type.String, n);
        QNativePointer.writeString(this.m_ptr, n, string);
    }

    public Type type() {
        return this.m_type;
    }

    public int indirections() {
        return this.m_indirections;
    }

    public boolean isNull() {
        return this.m_ptr == 0L;
    }

    public AutoDeleteMode autoDeleteMode() {
        return this.m_autodelete;
    }

    public void setAutoDeleteMode(AutoDeleteMode autoDeleteMode) {
        this.m_autodelete = autoDeleteMode;
    }

    public void free() {
        if (this.isNull()) {
            return;
        }
        QNativePointer.deletePointer(this.m_ptr, this.m_type.ordinal(), 0);
        this.m_ptr = 0L;
    }

    public void delete() {
        if (this.isNull()) {
            return;
        }
        QNativePointer.deletePointer(this.m_ptr, this.m_type.ordinal(), 1);
        this.m_ptr = 0L;
    }

    public void deleteArray() {
        if (this.isNull()) {
            return;
        }
        QNativePointer.deletePointer(this.m_ptr, this.m_type.ordinal(), 2);
        this.m_ptr = 0L;
    }

    public long pointer() {
        return this.m_ptr;
    }

    public static QNativePointer fromNative(long l, Type type, int n) {
        QNativePointer qNativePointer = new QNativePointer();
        qNativePointer.m_ptr = l;
        qNativePointer.m_type = type;
        qNativePointer.m_indirections = n;
        return qNativePointer;
    }

    public boolean verificationEnabled() {
        return this.m_verification_enabled;
    }

    public void setVerificationEnabled(boolean bl) {
        this.m_verification_enabled = bl;
    }

    private static Type typeOf(int n) {
        switch (n) {
            case 0: {
                return Type.Boolean;
            }
            case 1: {
                return Type.Byte;
            }
            case 2: {
                return Type.Char;
            }
            case 3: {
                return Type.Short;
            }
            case 4: {
                return Type.Int;
            }
            case 5: {
                return Type.Long;
            }
            case 6: {
                return Type.Float;
            }
            case 7: {
                return Type.Double;
            }
            case 8: {
                return Type.Pointer;
            }
        }
        throw new IllegalArgumentException("Unknown type id: " + n);
    }

    public static QNativePointer fromNative(long l, int n, int n2) {
        return QNativePointer.fromNative(l, QNativePointer.typeOf(n), n2);
    }

    public static QNativePointer createCharPointerPointer(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        QNativePointer qNativePointer = new QNativePointer(Type.Byte, stringArray.length + 1, 2);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            qNativePointer.setPointerAt(i, QNativePointer.createCharPointer(string));
        }
        qNativePointer.setPointerAt(stringArray.length, null);
        return qNativePointer;
    }

    public static QNativePointer createCharPointer(String string) {
        if (string == null) {
            return null;
        }
        QNativePointer qNativePointer = new QNativePointer(Type.Byte, string.length() + 1);
        for (int i = 0; i < string.length(); ++i) {
            qNativePointer.setByteAt(i, (byte)string.charAt(i));
        }
        qNativePointer.setByteAt(string.length(), (byte)0);
        return qNativePointer;
    }

    protected void finalize() {
        switch (this.m_autodelete) {
            case Free: {
                this.free();
                break;
            }
            case Delete: {
                this.delete();
                break;
            }
            case DeleteArray: {
                this.deleteArray();
            }
        }
    }

    private void verifyAccess(Type type, int n) {
        if (!this.m_verification_enabled) {
            return;
        }
        if (this.isNull()) {
            throw new NullPointerException("native pointer is null");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("negative index: " + n);
        }
        if (this.m_knownSize >= 0 && n >= this.m_knownSize) {
            throw new IndexOutOfBoundsException("size: " + this.m_knownSize + ", access at: " + n);
        }
        if (this.m_indirections > 1) {
            if (type != Type.Pointer) {
                throw new ClassCastException("accessing pointer with " + this.m_indirections + " levels of indirection as " + (Object)((Object)type));
            }
        } else if (type != this.m_type) {
            throw new ClassCastException("type: " + (Object)((Object)this.m_type) + ", accessed as: " + (Object)((Object)type));
        }
    }

    private static native boolean readBoolean(long var0, int var2);

    private static native byte readByte(long var0, int var2);

    private static native char readChar(long var0, int var2);

    private static native short readShort(long var0, int var2);

    private static native int readInt(long var0, int var2);

    private static native long readLong(long var0, int var2);

    private static native float readFloat(long var0, int var2);

    private static native double readDouble(long var0, int var2);

    private static native long readPointer(long var0, int var2);

    private static native String readString(long var0, int var2);

    private static native void writeBoolean(long var0, int var2, boolean var3);

    private static native void writeByte(long var0, int var2, byte var3);

    private static native void writeChar(long var0, int var2, char var3);

    private static native void writeShort(long var0, int var2, short var3);

    private static native void writeInt(long var0, int var2, int var3);

    private static native void writeLong(long var0, int var2, long var3);

    private static native void writeFloat(long var0, int var2, float var3);

    private static native void writeDouble(long var0, int var2, double var3);

    private static native void writePointer(long var0, int var2, long var3);

    private static native void writeString(long var0, int var2, String var3);

    private static native long createPointer(int var0, int var1, int var2);

    private static native void deletePointer(long var0, int var2, int var3);

    static {
        QtJambi_LibraryInitializer.init();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AutoDeleteMode {
        Free,
        Delete,
        DeleteArray,
        None;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        Boolean,
        Byte,
        Char,
        Short,
        Int,
        Long,
        Float,
        Double,
        Pointer,
        String;

    }
}

