/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qt;

import com.trolltech.qt.QClassPathEntry;
import com.trolltech.qt.QNativePointer;
import com.trolltech.qt.core.QAbstractFileEngine;
import com.trolltech.qt.core.QDate;
import com.trolltech.qt.core.QDateTime;
import com.trolltech.qt.core.QDir;
import com.trolltech.qt.core.QFile;
import com.trolltech.qt.core.QFileInfo;
import com.trolltech.qt.core.QIODevice;
import com.trolltech.qt.core.QTime;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QJarEntryEngine
extends QAbstractFileEngine
implements QClassPathEntry {
    private String m_classPathEntryFileName = null;
    private String m_jarFileName = null;
    private String m_entryFileName = null;
    private JarEntry m_entry = null;
    private JarFile m_jarFile = null;
    private InputStream m_stream = null;
    private BufferedReader m_reader = null;
    private long m_pos = -1L;
    private int m_openMode;
    private boolean m_valid = false;

    public QJarEntryEngine(JarFile jarFile, String string, String string2, String string3) {
        if (jarFile != null && string.length() > 0) {
            this.m_jarFile = jarFile;
            this.m_jarFileName = string;
            this.m_classPathEntryFileName = string3;
            this.setFileName(string2);
        }
    }

    @Override
    public void setFileName(String string) {
        this.m_entry = null;
        if (this.m_jarFile == null) {
            return;
        }
        if (string.length() == 0) {
            this.m_entryFileName = "";
            this.m_valid = true;
            return;
        }
        if (!string.endsWith("/")) {
            this.setFileName(string + "/");
            if (this.m_entry != null) {
                return;
            }
        }
        this.m_entryFileName = string;
        this.m_entry = this.m_jarFile.getJarEntry(this.m_entryFileName);
        this.m_valid = this.m_entry != null;
    }

    @Override
    public String classPathEntryName() {
        return this.m_classPathEntryFileName;
    }

    public boolean isValid() {
        return this.m_valid;
    }

    @Override
    public boolean copy(String string) {
        QNativePointer qNativePointer = new QNativePointer(QNativePointer.Type.Byte, 0x100000);
        QFile qFile = new QFile(string);
        if (qFile.exists()) {
            return false;
        }
        if (!this.open(new QIODevice.OpenMode(QIODevice.OpenModeFlag.ReadOnly))) {
            return false;
        }
        if (!qFile.open(new QIODevice.OpenMode(QIODevice.OpenModeFlag.WriteOnly))) {
            this.close();
            return false;
        }
        long l = this.size();
        long l2 = 0L;
        int n = 0;
        if (l > 0L) {
            do {
                n = (int)Math.min(l - l2, 0x100000L);
                n = (int)this.read(qNativePointer, n);
                byte[] byArray = new byte[n];
                for (int i = 0; i < n; ++i) {
                    byArray[i] = qNativePointer.byteAt(i);
                }
                if (n <= 0 || qFile.write(byArray) == n) continue;
                return false;
            } while (l2 < l && n > 0);
        }
        qFile.close();
        if (!this.close()) {
            return false;
        }
        return l2 == l;
    }

    @Override
    public boolean setPermissions(int n) {
        return false;
    }

    @Override
    public boolean caseSensitive() {
        return true;
    }

    @Override
    public boolean close() {
        if (this.m_stream != null) {
            try {
                this.m_stream.close();
            }
            catch (IOException iOException) {
                return false;
            }
            this.m_stream = null;
        }
        return true;
    }

    @Override
    public List<String> entryList(QDir.Filters filters, List<String> list) {
        String string;
        if (this.m_entry != null && !this.m_entry.isDirectory()) {
            return new LinkedList<String>();
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        if (!filters.isSet(new QDir.Filter[]{QDir.Filter.Readable, QDir.Filter.Writable, QDir.Filter.Executable})) {
            filters.set(new QDir.Filter[]{QDir.Filter.Readable});
        }
        String string2 = string = this.m_entry == null ? "" : this.m_entry.getName();
        if (!string.endsWith("/") && string.length() > 0) {
            string = string + "/";
        }
        Enumeration<JarEntry> enumeration = this.m_jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String string3 = jarEntry.getName();
            int n = string3.lastIndexOf(47, string3.length() - 2);
            String string4 = "";
            if (n > 0) {
                string4 = string3.substring(0, n + 1);
            }
            if (string3.equals(string) || !string4.equals(string)) continue;
            boolean bl = jarEntry.isDirectory();
            if (!filters.isSet(new QDir.Filter[]{QDir.Filter.Readable}) || !filters.isSet(new QDir.Filter[]{QDir.Filter.Dirs}) && bl || !filters.isSet(new QDir.Filter[]{QDir.Filter.Files}) && !bl || list.size() > 0 && (!bl || !filters.isSet(new QDir.Filter[]{QDir.Filter.AllDirs})) && !QDir.match(list, string3)) continue;
            if (string3.endsWith("/") && string3.length() > 1) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            linkedList.add(string3.substring(string4.length()));
        }
        return linkedList;
    }

    @Override
    public QAbstractFileEngine.FileFlags fileFlags(QAbstractFileEngine.FileFlags fileFlags) {
        try {
            int n = 0;
            QFileInfo qFileInfo = new QFileInfo(this.m_jarFileName);
            if (qFileInfo.exists()) {
                n |= qFileInfo.permissions().value() & (QAbstractFileEngine.FileFlag.ReadOwnerPerm.value() | QAbstractFileEngine.FileFlag.ReadGroupPerm.value() | QAbstractFileEngine.FileFlag.ReadOtherPerm.value() | QAbstractFileEngine.FileFlag.ReadUserPerm.value());
            }
            n = this.m_entry == null || this.m_entry.isDirectory() ? (n |= QAbstractFileEngine.FileFlag.DirectoryType.value()) : (n |= QAbstractFileEngine.FileFlag.FileType.value());
            return new QAbstractFileEngine.FileFlags((n | QAbstractFileEngine.FileFlag.ExistsFlag.value()) & fileFlags.value());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public String fileName(QAbstractFileEngine.FileName fileName) {
        String string = this.m_entryFileName;
        if (fileName == QAbstractFileEngine.FileName.LinkName) {
            return "";
        }
        if (fileName == QAbstractFileEngine.FileName.DefaultName || fileName == QAbstractFileEngine.FileName.AbsoluteName || fileName == QAbstractFileEngine.FileName.CanonicalName) {
            return "classpath:" + this.m_jarFileName + "#" + string;
        }
        if (fileName == QAbstractFileEngine.FileName.BaseName) {
            int n = this.m_entryFileName.lastIndexOf("/", this.m_entryFileName.length() - 2);
            return n >= 0 ? this.m_entryFileName.substring(n + 1) : string;
        }
        if (fileName == QAbstractFileEngine.FileName.PathName) {
            int n = this.m_entryFileName.lastIndexOf("/", this.m_entryFileName.length() - 2);
            return n >= 0 ? this.m_entryFileName.substring(0, n) : "/";
        }
        if (fileName == QAbstractFileEngine.FileName.CanonicalPathName || fileName == QAbstractFileEngine.FileName.AbsolutePathName) {
            return "classpath:" + this.m_jarFileName + "#" + this.fileName(QAbstractFileEngine.FileName.PathName);
        }
        throw new IllegalArgumentException("Unknown file name type: " + fileName);
    }

    @Override
    public QDateTime fileTime(QAbstractFileEngine.FileTime fileTime) {
        if (this.m_entry == null) {
            QFileInfo qFileInfo = new QFileInfo(this.m_jarFileName);
            if (qFileInfo.exists()) {
                return qFileInfo.lastModified();
            }
            return new QDateTime();
        }
        long l = this.m_entry.getTime();
        if (l == -1L) {
            return new QDateTime();
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(new Date(l));
        return new QDateTime(new QDate(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5)), new QTime(gregorianCalendar.get(11), gregorianCalendar.get(12), gregorianCalendar.get(13), gregorianCalendar.get(14)));
    }

    @Override
    public boolean link(String string) {
        return false;
    }

    @Override
    public boolean mkdir(String string, boolean bl) {
        return false;
    }

    @Override
    public boolean open(QIODevice.OpenMode openMode) {
        if (this.m_entry == null) {
            return false;
        }
        if ((openMode.value() & ~QIODevice.OpenModeFlag.Text.value()) == QIODevice.OpenModeFlag.ReadOnly.value()) {
            try {
                this.m_stream = this.m_jarFile.getInputStream(this.m_entry);
            }
            catch (IOException iOException) {
                return false;
            }
            if (this.m_stream != null) {
                if (openMode.isSet(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.Text})) {
                    this.m_reader = new BufferedReader(new InputStreamReader(this.m_stream));
                }
                this.m_pos = 0L;
                this.m_openMode = openMode.value();
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public long pos() {
        return this.m_pos;
    }

    @Override
    public long read(QNativePointer qNativePointer, long l) {
        if (this.m_stream == null) {
            return -1L;
        }
        if (l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        byte[] byArray = new byte[(int)l];
        int n = 0;
        try {
            int n2 = 0;
            while (this.m_stream.available() > 0 && (long)n < l && n2 >= 0) {
                n2 = this.m_stream.read(byArray, 0, (int)l - n);
                if (n2 <= 0) continue;
                for (int i = 0; i < n2; ++i) {
                    qNativePointer.setByteAt(i + n, byArray[i]);
                }
                n += n2;
            }
        }
        catch (IOException iOException) {
            return -1L;
        }
        this.m_pos += (long)n;
        return n;
    }

    @Override
    public long readLine(QNativePointer qNativePointer, long l) {
        if (this.m_stream == null || this.m_reader == null) {
            return -1L;
        }
        int n = 0;
        try {
            int n2;
            while (this.m_stream.available() > 0 && (long)n < l && (n2 = this.m_stream.read()) != -1) {
                qNativePointer.setByteAt(n++, (byte)n2);
                if (n2 != 10) continue;
                break;
            }
        }
        catch (IOException iOException) {
            return -1L;
        }
        this.m_pos += (long)n;
        return n;
    }

    @Override
    public boolean remove() {
        return false;
    }

    @Override
    public boolean rename(String string) {
        return false;
    }

    @Override
    public boolean rmdir(String string, boolean bl) {
        return false;
    }

    @Override
    public boolean seek(long l) {
        try {
            this.m_stream.close();
            if (!this.open(new QIODevice.OpenMode(this.m_openMode))) {
                return false;
            }
            this.m_pos = 0L;
            while (this.m_pos < l) {
                int n = (int)Math.min(l - this.m_pos, Integer.MAX_VALUE);
                this.m_stream.skip(n);
                this.m_pos += (long)n;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    @Override
    public String owner(QAbstractFileEngine.FileOwner fileOwner) {
        return "";
    }

    @Override
    public int ownerId(QAbstractFileEngine.FileOwner fileOwner) {
        return -2;
    }

    @Override
    public boolean isRelativePath() {
        return false;
    }

    @Override
    public boolean isSequential() {
        return false;
    }

    @Override
    public boolean setSize(long l) {
        return false;
    }

    @Override
    public long size() {
        return this.m_entry == null ? 0L : this.m_entry.getSize();
    }

    @Override
    public long write(QNativePointer qNativePointer, long l) {
        return -1L;
    }
}

