/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qt;

import com.trolltech.qt.QClassPathEntry;
import com.trolltech.qt.QClassPathFileEngineHandler;
import com.trolltech.qt.QFSEntryEngine;
import com.trolltech.qt.QJarEntryEngine;
import com.trolltech.qt.QNativePointer;
import com.trolltech.qt.QtJambiObject;
import com.trolltech.qt.core.QAbstractFileEngine;
import com.trolltech.qt.core.QDateTime;
import com.trolltech.qt.core.QDir;
import com.trolltech.qt.core.QFileInfo;
import com.trolltech.qt.core.QIODevice;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QClassPathEngine
extends QAbstractFileEngine {
    public static final String FileNameDelim = "#";
    public static final String FileNameDelimRegExp = "\\x23";
    public static final String FileNameIndicator = "classpath";
    public static final String FileNamePrefix = "classpath:";
    private static HashSet<String> classpaths;
    private String m_fileName = "";
    private String m_baseName = "";
    private String m_selectedSource = "*";
    private List<QAbstractFileEngine> m_engines = new LinkedList<QAbstractFileEngine>();

    public QClassPathEngine(String string) {
        this.setFileName(string);
    }

    private static String makeUrl(String string) {
        boolean bl = false;
        try {
            URL uRL = new URL(string);
            if (uRL.getProtocol().length() > 0) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            string = "file:" + string;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSearchPath(String string) {
        Class<QClassPathEngine> clazz = QClassPathEngine.class;
        synchronized (QClassPathEngine.class) {
            if (classpaths == null) {
                QClassPathEngine.findClassPaths();
            }
            String string2 = QClassPathEngine.makeUrl(string);
            classpaths.remove(string2);
            classpaths.add(QClassPathEngine.makeUrl(string));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSearchPath(String string) {
        Class<QClassPathEngine> clazz = QClassPathEngine.class;
        synchronized (QClassPathEngine.class) {
            if (classpaths == null) {
                QClassPathEngine.findClassPaths();
            }
            classpaths.remove(QClassPathEngine.makeUrl(string));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFileName(String string) {
        this.cleanUp();
        if (!string.startsWith(FileNamePrefix)) {
            throw new IllegalArgumentException("Invalid format of path: " + string);
        }
        this.m_fileName = string.substring(FileNamePrefix.length());
        String[] stringArray = this.m_fileName.split(FileNameDelimRegExp, 2);
        this.m_selectedSource = "*";
        if (stringArray.length == 1) {
            this.m_baseName = stringArray[0];
        } else {
            this.m_baseName = stringArray[1];
            this.m_selectedSource = stringArray[0];
        }
        if (this.m_selectedSource.equals("*")) {
            Class<QClassPathEngine> clazz = QClassPathEngine.class;
            synchronized (QClassPathEngine.class) {
                if (classpaths == null) {
                    QClassPathEngine.findClassPaths();
                }
                for (String string2 : classpaths) {
                    this.addFromPath(string2, this.m_baseName);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else {
            this.addFromPath(QClassPathEngine.makeUrl(this.m_selectedSource), this.m_baseName);
        }
    }

    @Override
    public boolean copy(String string) {
        if (this.m_engines.size() > 0) {
            return this.m_engines.get(0).copy(string);
        }
        return false;
    }

    @Override
    public boolean setPermissions(int n) {
        for (QAbstractFileEngine qAbstractFileEngine : this.m_engines) {
            if (!qAbstractFileEngine.setPermissions(n)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean caseSensitive() {
        return true;
    }

    @Override
    public boolean close() {
        if (this.m_engines.size() == 0) {
            return false;
        }
        return this.m_engines.get(0).close();
    }

    @Override
    public List<String> entryList(QDir.Filters filters, List<String> list) {
        List<String> list2 = null;
        for (QAbstractFileEngine qAbstractFileEngine : this.m_engines) {
            if (list2 == null) {
                list2 = qAbstractFileEngine.entryList(filters, list);
                continue;
            }
            List<String> list3 = qAbstractFileEngine.entryList(filters, list);
            list2.removeAll(list3);
            list2.addAll(list3);
        }
        return list2;
    }

    @Override
    public QAbstractFileEngine.FileFlags fileFlags(QAbstractFileEngine.FileFlags fileFlags) {
        QAbstractFileEngine.FileFlags fileFlags2 = new QAbstractFileEngine.FileFlags(new QAbstractFileEngine.FileFlag[0]);
        for (QAbstractFileEngine qAbstractFileEngine : this.m_engines) {
            fileFlags2.set(qAbstractFileEngine.fileFlags(fileFlags));
        }
        if (this.fileName(QAbstractFileEngine.FileName.PathName).equals("/")) {
            fileFlags2.set(new QAbstractFileEngine.FileFlag[]{QAbstractFileEngine.FileFlag.RootFlag});
        }
        fileFlags2.clear(new QAbstractFileEngine.FileFlag[]{QAbstractFileEngine.FileFlag.LocalDiskFlag});
        return fileFlags2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String fileName(QAbstractFileEngine.FileName fileName) {
        Object object;
        if (this.m_engines.size() == 0) {
            return "";
        }
        String string = "";
        if (this.m_engines.size() == 1) {
            object = this.m_engines.get(0);
            if (!(object instanceof QClassPathEntry)) throw new RuntimeException("Bogus engine in class path file engine");
            string = ((QClassPathEntry)object).classPathEntryName();
        } else {
            string = "*";
        }
        object = "";
        if (fileName == QAbstractFileEngine.FileName.DefaultName) {
            object = FileNamePrefix + this.m_fileName;
        } else if (fileName == QAbstractFileEngine.FileName.CanonicalName || fileName == QAbstractFileEngine.FileName.LinkName) {
            object = this.fileName(QAbstractFileEngine.FileName.CanonicalPathName) + "/" + this.fileName(QAbstractFileEngine.FileName.BaseName);
        } else if (fileName == QAbstractFileEngine.FileName.AbsoluteName || fileName == QAbstractFileEngine.FileName.LinkName) {
            object = FileNamePrefix + string + FileNameDelim + this.m_baseName;
        } else if (fileName == QAbstractFileEngine.FileName.BaseName) {
            int n = this.m_baseName.lastIndexOf("/", this.m_baseName.length() - 2);
            object = n >= 0 ? this.m_baseName.substring(n + 1) : this.m_baseName;
        } else if (fileName == QAbstractFileEngine.FileName.PathName) {
            int n = this.m_baseName.lastIndexOf("/", this.m_baseName.length() - 2);
            object = n >= 0 ? this.m_baseName.substring(0, n) : "/";
        } else if (fileName == QAbstractFileEngine.FileName.AbsolutePathName) {
            object = FileNamePrefix + string + FileNameDelim + this.fileName(QAbstractFileEngine.FileName.PathName);
        } else {
            if (fileName != QAbstractFileEngine.FileName.CanonicalPathName) throw new IllegalArgumentException("Unknown file name type: " + fileName);
            object = this.m_engines.get(0).fileName(fileName);
        }
        if (!((String)object).endsWith("/")) return object;
        if (((String)object).length() <= 1) return object;
        return ((String)object).substring(0, ((String)object).length() - 1);
    }

    @Override
    public QDateTime fileTime(QAbstractFileEngine.FileTime fileTime) {
        if (this.m_engines.size() == 0) {
            return new QDateTime();
        }
        return this.m_engines.get(0).fileTime(fileTime);
    }

    @Override
    public boolean link(String string) {
        for (QAbstractFileEngine qAbstractFileEngine : this.m_engines) {
            if (!qAbstractFileEngine.link(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mkdir(String string, boolean bl) {
        for (QAbstractFileEngine qAbstractFileEngine : this.m_engines) {
            if (!qAbstractFileEngine.mkdir(string, bl)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean open(QIODevice.OpenMode openMode) {
        if (this.m_engines.size() == 0) {
            return false;
        }
        return this.m_engines.get(0).open(openMode);
    }

    @Override
    public long pos() {
        if (this.m_engines.size() == 0) {
            return -1L;
        }
        return this.m_engines.get(0).pos();
    }

    @Override
    public long read(QNativePointer qNativePointer, long l) {
        if (this.m_engines.size() == 0) {
            return -1L;
        }
        return this.m_engines.get(0).read(qNativePointer, l);
    }

    @Override
    public long readLine(QNativePointer qNativePointer, long l) {
        if (this.m_engines.size() == 0) {
            return -1L;
        }
        return this.m_engines.get(0).readLine(qNativePointer, l);
    }

    @Override
    public boolean remove() {
        boolean bl = true;
        for (QAbstractFileEngine qAbstractFileEngine : this.m_engines) {
            bl = bl && qAbstractFileEngine.remove();
        }
        return bl;
    }

    @Override
    public boolean rename(String string) {
        boolean bl = true;
        for (QAbstractFileEngine qAbstractFileEngine : this.m_engines) {
            bl = bl && qAbstractFileEngine.rename(string);
        }
        return bl;
    }

    @Override
    public boolean rmdir(String string, boolean bl) {
        boolean bl2 = true;
        for (QAbstractFileEngine qAbstractFileEngine : this.m_engines) {
            bl2 = bl2 && qAbstractFileEngine.rmdir(string, bl);
        }
        return bl2;
    }

    @Override
    public boolean seek(long l) {
        if (this.m_engines.size() == 0) {
            return false;
        }
        return this.m_engines.get(0).seek(l);
    }

    @Override
    public String owner(QAbstractFileEngine.FileOwner fileOwner) {
        String string = "";
        int n = 0;
        while (string.length() == 0 && n < this.m_engines.size()) {
            string = this.m_engines.get(n++).owner(fileOwner);
        }
        return string;
    }

    @Override
    public int ownerId(QAbstractFileEngine.FileOwner fileOwner) {
        int n = -2;
        int n2 = 0;
        while (n == -2 && n2 < this.m_engines.size()) {
            n = this.m_engines.get(n2++).ownerId(fileOwner);
        }
        return n;
    }

    @Override
    public boolean isRelativePath() {
        return false;
    }

    @Override
    public boolean isSequential() {
        for (QAbstractFileEngine qAbstractFileEngine : this.m_engines) {
            if (!qAbstractFileEngine.isSequential()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean setSize(long l) {
        if (this.m_engines.size() == 0) {
            return false;
        }
        return this.m_engines.get(0).setSize(l);
    }

    @Override
    public long size() {
        if (this.m_engines.size() == 0) {
            return -1L;
        }
        return this.m_engines.get(0).size();
    }

    @Override
    public long write(QNativePointer qNativePointer, long l) {
        if (this.m_engines.size() == 0) {
            return -1L;
        }
        return this.m_engines.get(0).write(qNativePointer, l);
    }

    private void cleanUp() {
        if (this.m_engines != null) {
            this.m_engines.clear();
        }
    }

    private void addFromPath(String string, String string2) {
        QtJambiObject qtJambiObject;
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        String string3 = uRL.getFile().replace(File.separator, "/");
        JarFile jarFile = null;
        if (uRL.getProtocol().equals("file") && ((QFileInfo)(qtJambiObject = new QFileInfo(string3))).isDir() && ((QFileInfo)qtJambiObject).exists() && new QFileInfo(string3 + "/" + string2).exists()) {
            this.addEngine(new QFSEntryEngine(string3 + "/" + string2, string));
            return;
        }
        try {
            uRL = new URL("jar:" + uRL.toString() + "!/");
            jarFile = ((JarURLConnection)uRL.openConnection()).getJarFile();
        }
        catch (IOException iOException) {
            return;
        }
        string2 = QDir.cleanPath(string2);
        while (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        qtJambiObject = new QJarEntryEngine(jarFile, string3, string2, string);
        if (((QJarEntryEngine)qtJambiObject).isValid()) {
            this.addEngine((QAbstractFileEngine)qtJambiObject);
        }
    }

    private void addEngine(QAbstractFileEngine qAbstractFileEngine) {
        if (this.m_engines == null) {
            this.m_engines = new LinkedList<QAbstractFileEngine>();
        }
        this.m_engines.add(qAbstractFileEngine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static void findClassPaths() {
        Class<QClassPathEngine> clazz = QClassPathEngine.class;
        synchronized (QClassPathEngine.class) {
            classpaths = new HashSet();
            String[] stringArray = System.getProperty("java.class.path").split(File.pathSeparator);
            int n = 0;
            for (String string : stringArray) {
                if (string.trim().length() <= 0) continue;
                ++n;
                classpaths.add(QClassPathEngine.makeUrl(string));
            }
            try {
                void var3_6;
                ClassLoader exception = Thread.currentThread().getContextClassLoader();
                if (exception == null) {
                    ClassLoader classLoader = QClassPathFileEngineHandler.class.getClassLoader();
                }
                Enumeration<URL> enumeration = var3_6.getResources("META-INF/MANIFEST.MF");
                while (enumeration.hasMoreElements()) {
                    URL uRL = enumeration.nextElement();
                    if (!uRL.getProtocol().equals("jar")) continue;
                    try {
                        String string;
                        string = uRL.getFile();
                        int n2 = string.indexOf("!");
                        if (n2 >= 0) {
                            string = string.substring(0, n2);
                        }
                        if (string.trim().length() <= 0) continue;
                        classpaths.add(string);
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (n == 0) {
                classpaths.add("file:" + QDir.currentPath());
            }
            // ** MonitorExit[clazz] (shouldn't be in output)
            return;
        }
    }
}

