/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.tools.designer.propertysheet;

import com.trolltech.qt.core.QObject;
import com.trolltech.qt.gui.QCalendarWidget;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QStackedWidget;
import com.trolltech.qt.gui.QTabWidget;
import com.trolltech.qt.gui.QToolBox;
import com.trolltech.qt.gui.QWidget;
import com.trolltech.tools.designer.PropertySheet;
import com.trolltech.tools.designer.propertysheet.FakeProperty;
import com.trolltech.tools.designer.propertysheet.Property;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WidgetLayoutProperty
extends FakeProperty {
    public static final String LAYOUT_LEFT_MARGIN = "layoutLeftMargin";
    public static final String LAYOUT_RIGHT_MARGIN = "layoutRightMargin";
    public static final String LAYOUT_BOTTOM_MARGIN = "layoutBottomMargin";
    public static final String LAYOUT_TOP_MARGIN = "layoutTopMargin";
    public static final String LAYOUT_HORIZONTAL_SPACING = "layoutHorizontalSpacing";
    public static final String LAYOUT_VERTICAL_SPACING = "layoutVerticalSpacing";
    private QWidget widget;
    private String alterEgoName;

    public static void initialize(List<Property> list, QObject qObject) {
        if (qObject instanceof QTabWidget || qObject instanceof QStackedWidget || qObject instanceof QToolBox || qObject instanceof QCalendarWidget) {
            return;
        }
        if (qObject instanceof QWidget) {
            QWidget qWidget = (QWidget)qObject;
            list.add(new WidgetLayoutProperty(qWidget, LAYOUT_LEFT_MARGIN));
            list.add(new WidgetLayoutProperty(qWidget, LAYOUT_RIGHT_MARGIN));
            list.add(new WidgetLayoutProperty(qWidget, LAYOUT_BOTTOM_MARGIN));
            list.add(new WidgetLayoutProperty(qWidget, LAYOUT_TOP_MARGIN));
            list.add(new WidgetLayoutProperty(qWidget, LAYOUT_HORIZONTAL_SPACING));
            list.add(new WidgetLayoutProperty(qWidget, LAYOUT_VERTICAL_SPACING));
        }
    }

    public WidgetLayoutProperty(QWidget qWidget, String string) {
        super(string);
        this.widget = qWidget;
        this.groupName = "Layout";
        this.subclassLevel = 1024;
        if (string == LAYOUT_LEFT_MARGIN) {
            this.alterEgoName = "leftMargin";
        } else if (string == LAYOUT_RIGHT_MARGIN) {
            this.alterEgoName = "rightMargin";
        } else if (string == LAYOUT_BOTTOM_MARGIN) {
            this.alterEgoName = "bottomMargin";
        } else if (string == LAYOUT_TOP_MARGIN) {
            this.alterEgoName = "topMargin";
        } else if (string == LAYOUT_HORIZONTAL_SPACING) {
            this.alterEgoName = "horizontalSpacing";
        } else if (string == LAYOUT_VERTICAL_SPACING) {
            this.alterEgoName = "verticalSpacing";
        }
    }

    @Override
    public Object read() {
        PropertySheet propertySheet = this.layoutPropertySheet();
        return propertySheet != null ? propertySheet.property(propertySheet.indexOf(this.alterEgoName)) : null;
    }

    @Override
    public void write(Object object) {
        PropertySheet propertySheet = this.layoutPropertySheet();
        if (propertySheet != null) {
            propertySheet.setProperty(propertySheet.indexOf(this.alterEgoName), object);
        }
    }

    @Override
    public boolean designable() {
        PropertySheet propertySheet = this.layoutPropertySheet();
        return propertySheet != null && propertySheet.isVisible(propertySheet.indexOf(this.alterEgoName));
    }

    private PropertySheet layoutPropertySheet() {
        QLayout qLayout = this.widget.layout();
        return qLayout != null ? PropertySheet.get(qLayout) : null;
    }
}

