/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.tools.designer.propertysheet;

import com.trolltech.qt.core.QObject;
import com.trolltech.qt.core.QRect;
import com.trolltech.qt.gui.QContentsMargins;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.tools.designer.propertysheet.FakeProperty;
import com.trolltech.tools.designer.propertysheet.Property;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutProperty
extends FakeProperty {
    public static final String RIGHT_MARGIN = "rightMargin";
    public static final String LEFT_MARGIN = "leftMargin";
    public static final String TOP_MARGIN = "topMargin";
    public static final String BOTTOM_MARGIN = "bottomMargin";
    public static final String VERTICAL_SPACING = "verticalSpacing";
    public static final String HORIZONTAL_SPACING = "horizontalSpacing";
    private QLayout layout;

    public LayoutProperty(QLayout qLayout, String string) {
        super(string);
        this.layout = qLayout;
        this.attribute = false;
    }

    @Override
    public Object read() {
        if (this.entry.name.endsWith("Margin")) {
            QRect qRect = this.layout.contentsRect();
            QRect qRect2 = this.layout.geometry();
            if (this.entry.name == RIGHT_MARGIN) {
                return qRect2.right() - qRect.right();
            }
            if (this.entry.name == LEFT_MARGIN) {
                return qRect.left() - qRect2.left();
            }
            if (this.entry.name == TOP_MARGIN) {
                return qRect.top() - qRect2.top();
            }
            if (this.entry.name == BOTTOM_MARGIN) {
                return qRect2.bottom() - qRect.bottom();
            }
        }
        return null;
    }

    @Override
    public void write(Object object) {
        this.changed = true;
        if (this.entry.name.endsWith("Margin")) {
            int n = (Integer)object;
            QContentsMargins qContentsMargins = this.layout.getContentsMargins();
            if (this.entry.name == RIGHT_MARGIN) {
                qContentsMargins.right = n;
            } else if (this.entry.name == LEFT_MARGIN) {
                qContentsMargins.left = n;
            } else if (this.entry.name == TOP_MARGIN) {
                qContentsMargins.top = n;
            } else if (this.entry.name == BOTTOM_MARGIN) {
                qContentsMargins.bottom = n;
            }
            this.layout.setContentsMargins(qContentsMargins);
        }
    }

    @Override
    public boolean designable() {
        return true;
    }

    public static void initialize(List<Property> list, QObject qObject) {
        if (qObject instanceof QLayout) {
            QLayout qLayout = (QLayout)qObject;
            list.add(new LayoutProperty(qLayout, RIGHT_MARGIN));
            list.add(new LayoutProperty(qLayout, LEFT_MARGIN));
            list.add(new LayoutProperty(qLayout, TOP_MARGIN));
            list.add(new LayoutProperty(qLayout, BOTTOM_MARGIN));
        }
    }
}

