/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.tools.designer;

import com.trolltech.qt.QSignalEmitter;
import com.trolltech.qt.core.QAbstractItemModel;
import com.trolltech.qt.core.QModelIndex;
import com.trolltech.qt.core.QObject;
import com.trolltech.qt.core.QRegExp;
import com.trolltech.qt.core.QSize;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QApplication;
import com.trolltech.qt.gui.QBrush;
import com.trolltech.qt.gui.QImage;
import com.trolltech.qt.gui.QLinearGradient;
import com.trolltech.qt.gui.QPalette;
import com.trolltech.qt.gui.QPixmap;
import com.trolltech.qt.gui.QSortFilterProxyModel;
import java.util.ArrayList;
import java.util.List;

public class ResourceBrowserModel
extends QAbstractItemModel {
    public static final QSize PIXMAP_SIZE = new QSize(16, 16);
    private static final String DEFAULT_PACKAGE = "<default package>";
    private static final QPixmap FOLDER_PIXMAP = new QPixmap("classpath:com/trolltech/tools/designer/folder.png").scaled(PIXMAP_SIZE, Qt.AspectRatioMode.KeepAspectRatio, Qt.TransformationMode.SmoothTransformation);
    public QSignalEmitter.Signal1<QModelIndex> rowsAdded = new QSignalEmitter.Signal1();
    private List<Path> roots = new ArrayList<Path>();
    private QBrush gradient;

    public ResourceBrowserModel() {
        QPalette qPalette = QApplication.palette();
        QLinearGradient qLinearGradient = new QLinearGradient(0.0, 0.0, 0.0, 16.0);
        qLinearGradient.setColorAt(0.0, qPalette.color(QPalette.ColorRole.AlternateBase));
        qLinearGradient.setColorAt(0.1, qPalette.color(QPalette.ColorRole.Base));
        qLinearGradient.setColorAt(1.0, qPalette.color(QPalette.ColorRole.AlternateBase));
        this.gradient = new QBrush(qLinearGradient);
    }

    public String resource(QModelIndex qModelIndex) {
        int n = (int)qModelIndex.internalId();
        if (n > 0) {
            Path path = this.roots.get(n - 1);
            return path.images.get((int)qModelIndex.row()).fullName;
        }
        return null;
    }

    private static String pathName(String string) {
        int n;
        int n2 = Math.max(string.indexOf(58), string.indexOf(35)) + 1;
        if (string.charAt(n2) == '/') {
            ++n2;
        }
        if (n2 >= (n = string.lastIndexOf(47))) {
            return null;
        }
        return string.substring(n2, n).replace('/', '.');
    }

    private static String imageName(String string) {
        int n = string.lastIndexOf(47);
        return string.substring(n + 1);
    }

    public QModelIndex indexForPath(String string) {
        String string2 = ResourceBrowserModel.pathName(string).replace('/', '.');
        String string3 = null;
        for (int i = 0; i < this.roots.size(); ++i) {
            Path path = this.roots.get(i);
            if (!path.name.equals(string2)) continue;
            if (string3 == null) {
                string3 = ResourceBrowserModel.imageName(string);
            }
            for (int j = 0; j < path.images.size(); ++j) {
                Resource resource = path.images.get(j);
                if (!string3.equals(resource.name)) continue;
                return this.createIndex(j, 0, i + 1);
            }
        }
        return null;
    }

    public void addResource(String string, QImage qImage) {
        String string2 = ResourceBrowserModel.pathName(string);
        String string3 = ResourceBrowserModel.imageName(string);
        if (string2 == null) {
            return;
        }
        if (string2.length() == 0) {
            string2 = DEFAULT_PACKAGE;
        }
        int n = this.resolvePath(string2);
        Path path = this.roots.get(n);
        int n2 = path.images.size();
        QModelIndex qModelIndex = this.index(n, 0, null);
        this.beginInsertRows(qModelIndex, n2, n2);
        path.addResource(string3, string, qImage);
        this.endInsertRows();
        this.rowsAdded.emit(qModelIndex);
    }

    private int resolvePath(String string) {
        Path path;
        int n;
        string = string.intern();
        for (n = 0; n < this.roots.size(); ++n) {
            path = this.roots.get(n);
            if (path.name != string) continue;
            return n;
        }
        n = this.roots.size();
        this.beginInsertRows(null, n, n);
        path = new Path(string);
        this.roots.add(path);
        this.endInsertRows();
        return n;
    }

    public int columnCount(QModelIndex qModelIndex) {
        return 1;
    }

    public Object data(QModelIndex qModelIndex, int n) {
        if (qModelIndex == null) {
            return null;
        }
        if (qModelIndex.internalId() > 0L) {
            Path path = this.roots.get((int)qModelIndex.internalId() - 1);
            Resource resource = path.images.get(qModelIndex.row());
            if (n == 0) {
                return resource.name;
            }
            if (n == 1) {
                return resource.image;
            }
        } else {
            if (n == 0) {
                return this.roots.get((int)qModelIndex.row()).name;
            }
            if (n == 8) {
                return this.gradient;
            }
            if (n == 1) {
                return FOLDER_PIXMAP;
            }
        }
        return null;
    }

    public QModelIndex index(int n, int n2, QModelIndex qModelIndex) {
        if (qModelIndex == null) {
            return this.createIndex(n, n2);
        }
        return this.createIndex(n, n2, qModelIndex.row() + 1);
    }

    public QModelIndex parent(QModelIndex qModelIndex) {
        if (qModelIndex.internalId() == 0L) {
            return null;
        }
        return this.createIndex((int)qModelIndex.internalId() - 1, 0);
    }

    public int rowCount(QModelIndex qModelIndex) {
        if (qModelIndex == null) {
            return this.roots.size();
        }
        if (qModelIndex.internalId() == 0L) {
            return this.roots.get((int)qModelIndex.row()).images.size();
        }
        return 0;
    }

    public static class Resource
    extends NamedItem
    implements Comparable {
        String fullName;
        QImage image;

        public Resource(String string) {
            super(string);
        }
    }

    public static class FilterModel
    extends QSortFilterProxyModel {
        public FilterModel(QObject qObject) {
            super(qObject);
        }

        private boolean pathContains(Path path, QRegExp qRegExp) {
            for (Resource resource : path.images) {
                if (qRegExp.indexIn(resource.name) < 0) continue;
                return true;
            }
            return false;
        }

        protected boolean filterAcceptsRow(int n, QModelIndex qModelIndex) {
            ResourceBrowserModel resourceBrowserModel = (ResourceBrowserModel)this.sourceModel();
            QRegExp qRegExp = this.filterRegExp();
            if (qModelIndex == null) {
                Path path = (Path)resourceBrowserModel.roots.get(n);
                return qRegExp.indexIn(path.name) >= 0 || this.pathContains(path, qRegExp);
            }
            Path path = (Path)resourceBrowserModel.roots.get(qModelIndex.row());
            Resource resource = path.images.get(n);
            return qRegExp.indexIn(path.name) >= 0 || qRegExp.indexIn(resource.name) >= 0;
        }
    }

    private static class Path
    extends NamedItem
    implements Comparable {
        List<Resource> images = new ArrayList<Resource>();

        public Path(String string) {
            super(string);
        }

        public void addResource(String string, String string2, QImage qImage) {
            Resource resource = new Resource(string);
            resource.fullName = string2;
            resource.image = qImage;
            this.images.add(resource);
        }
    }

    private static class NamedItem
    implements Comparable {
        String name;

        public NamedItem(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }

        public int compareTo(Object object) {
            return this.name.compareTo(object.toString());
        }
    }
}

