/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.tools.designer;

import com.trolltech.qt.QFlags;
import com.trolltech.qt.QPropertyException;
import com.trolltech.qt.QtEnumerator;
import com.trolltech.qt.QtPropertyManager;
import com.trolltech.qt.core.QObject;
import com.trolltech.qt.core.QPoint;
import com.trolltech.qt.core.QRect;
import com.trolltech.qt.core.QSize;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QColor;
import com.trolltech.qt.gui.QComboBox;
import com.trolltech.qt.gui.QDialogButtonBox;
import com.trolltech.qt.gui.QFont;
import com.trolltech.qt.gui.QFontDatabase;
import com.trolltech.qt.gui.QFrame;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QKeySequence;
import com.trolltech.qt.gui.QLineEdit;
import com.trolltech.qt.gui.QPalette;
import com.trolltech.qt.gui.QPixmap;
import com.trolltech.qt.gui.QSizePolicy;
import com.trolltech.qt.gui.QTabWidget;
import com.trolltech.tools.designer.JambiPropertySheet;
import com.trolltech.tools.designer.NamedIntSet;
import com.trolltech.tools.designer.propertysheet.BuddyProperty;
import com.trolltech.tools.designer.propertysheet.DockWidgetProperty;
import com.trolltech.tools.designer.propertysheet.GridLayoutMarginPropertyRemover;
import com.trolltech.tools.designer.propertysheet.LayoutProperty;
import com.trolltech.tools.designer.propertysheet.Property;
import com.trolltech.tools.designer.propertysheet.TabWidgetProperty;
import com.trolltech.tools.designer.propertysheet.WidgetLayoutProperty;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertySheet
extends JambiPropertySheet {
    private static List<Class<? extends Property>> CUSTOM_PROPERTIES = new ArrayList<Class<? extends Property>>();
    private static Set<String> INVISIBLE_PROPERTIES = new HashSet<String>();
    private static Map<Class, Object> RESETTABLE_TYPES;
    private List<Property> properties;
    private QObject object;
    private static HashMap<QObject, PropertySheet> propertySheets;

    public static void addCustomProperty(Class<? extends Property> clazz) {
        CUSTOM_PROPERTIES.add(clazz);
    }

    private PropertySheet(QObject qObject, QObject qObject2) {
        super(qObject2);
        this.object = qObject;
        this.build();
    }

    public static PropertySheet get(QObject qObject) {
        return propertySheets.get(qObject);
    }

    public static PropertySheet create(QObject qObject, QObject qObject2) {
        PropertySheet propertySheet = propertySheets.get(qObject);
        if (propertySheet == null) {
            propertySheet = new PropertySheet(qObject, qObject2);
            propertySheets.put(qObject, propertySheet);
        }
        return propertySheet;
    }

    @Override
    protected void disposed() {
        propertySheets.remove(this.object);
    }

    public boolean canAddDynamicProperty(String string, Object object) {
        return false;
    }

    public boolean addDynamicProperty(String string, Object object) {
        return false;
    }

    @Override
    public int count() {
        return this.properties.size();
    }

    public boolean dynamicPropertiesAllowed() {
        return false;
    }

    @Override
    public boolean hasReset(int n) {
        if (n < 0) {
            return true;
        }
        Property property = this.properties.get(n);
        return property.entry.reset != null || RESETTABLE_TYPES.containsKey(property.entry.type());
    }

    @Override
    public int indexOf(String string) {
        for (int i = 0; i < this.properties.size(); ++i) {
            Property property = this.properties.get(i);
            if (!property.entry.name.equals(string)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isAttribute(int n) {
        if (n < 0) {
            return false;
        }
        return this.properties.get((int)n).attribute;
    }

    @Override
    public boolean isChanged(int n) {
        if (n < 0) {
            return false;
        }
        return this.properties.get((int)n).changed;
    }

    public boolean isDynamicProperty(int n) {
        return false;
    }

    @Override
    public boolean isVisible(int n) {
        if (n < 0) {
            return false;
        }
        Property property = this.properties.get(n);
        return property.entry.isDesignable(this.invokationTarget(property)) && property.entry.write != null || property.visible;
    }

    @Override
    public Object readProperty(int n) {
        if (n < 0) {
            return null;
        }
        try {
            Property property = this.properties.get(n);
            Object object = this.invokationTarget(property);
            Method method = property.entry.read;
            Object object2 = method.invoke(object, new Object[0]);
            if (object2 == null) {
                object2 = this.defaultConstruct(property.entry.type());
            }
            if (QtEnumerator.class.isAssignableFrom(method.getReturnType()) && Enum.class.isAssignableFrom(method.getReturnType())) {
                object2 = PropertySheet.translateEnum((QtEnumerator)object2);
            } else if (QFlags.class.isAssignableFrom(method.getReturnType())) {
                object2 = PropertySheet.translateFlags((QFlags)object2);
            }
            return object2;
        }
        catch (Exception exception) {
            System.err.printf("Failed to read property '%s' from '%s'\n", this.propertyName(n), this.object.getClass().getName());
            exception.printStackTrace();
            return null;
        }
    }

    private Object defaultConstruct(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean removeDynamicProperty(String string) {
        return false;
    }

    private static NamedIntSet createAndFillNamedIntSet(Class<?> clazz) {
        Object[] objectArray;
        Object object;
        try {
            object = clazz.getMethod("values", new Class[0]);
            objectArray = (Object[])((Method)object).invoke(clazz, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        object = new NamedIntSet();
        ((NamedIntSet)object).isEnum = true;
        for (Object object2 : objectArray) {
            ((NamedIntSet)object).names.put(object2.getClass().getName().replace('$', '.') + "." + ((Enum)object2).name(), ((QtEnumerator)object2).value());
        }
        return object;
    }

    public static Object translateFlags(QFlags qFlags) {
        Class<?> clazz = qFlags.getClass();
        ParameterizedType parameterizedType = (ParameterizedType)clazz.getGenericSuperclass();
        Class clazz2 = (Class)parameterizedType.getActualTypeArguments()[0];
        NamedIntSet namedIntSet = PropertySheet.createAndFillNamedIntSet(clazz2);
        namedIntSet.value = qFlags.value();
        namedIntSet.isEnum = false;
        return namedIntSet;
    }

    public static Object translateEnum(QtEnumerator qtEnumerator) {
        NamedIntSet namedIntSet = PropertySheet.createAndFillNamedIntSet(qtEnumerator.getClass());
        namedIntSet.value = qtEnumerator.value();
        namedIntSet.isEnum = true;
        return namedIntSet;
    }

    @Override
    public String propertyGroup(int n) {
        if (n < 0) {
            return null;
        }
        return this.properties.get((int)n).groupName;
    }

    @Override
    public String propertyName(int n) {
        return this.properties.get((int)n).entry.name;
    }

    @Override
    public boolean reset(int n) {
        if (this.hasReset(n)) {
            try {
                Property property = this.properties.get(n);
                if (property.entry.reset != null) {
                    Object object = this.invokationTarget(property);
                    property.entry.reset.invoke(object, new Object[0]);
                    property.changed = false;
                } else if (RESETTABLE_TYPES.containsKey(property.entry.type())) {
                    this.writeProperty(n, RESETTABLE_TYPES.get(property.entry.type()));
                }
                return true;
            }
            catch (Exception exception) {
                System.err.println("Resetting property failed: " + this.properties.get((int)n).entry.name + " for " + this.object);
                exception.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public void setAttribute(int n, boolean bl) {
        if (n < 0) {
            return;
        }
        Property property = this.properties.get(n);
        property.attribute = true;
    }

    @Override
    public void setChanged(int n, boolean bl) {
        if (n < 0 || n >= this.properties.size()) {
            return;
        }
        this.properties.get((int)n).changed = bl;
    }

    @Override
    public void writeProperty(int n, Object object) {
        if (n < 0 || n >= this.properties.size()) {
            return;
        }
        try {
            Object object2;
            Method method = this.properties.get((int)n).entry.write;
            Class<?> clazz = method.getParameterTypes()[0];
            if (QFlags.class.isAssignableFrom(clazz)) {
                object2 = clazz.getConstructor(Integer.TYPE);
                object = ((Constructor)object2).newInstance((Integer)object);
            } else if (Enum.class.isAssignableFrom(clazz)) {
                object2 = clazz.getMethod("resolve", Integer.TYPE);
                if (object == null) {
                    throw new NullPointerException("Enum value cannot be null");
                }
                object = ((Method)object2).invoke(null, (Integer)object);
            }
            object2 = this.properties.get(n);
            ((Property)object2).entry.write.invoke(this.invokationTarget((Property)object2), object);
            ((Property)object2).changed = true;
        }
        catch (Exception exception) {
            System.out.println("Writing property failed: " + this.properties.get((int)n).entry.name + " for " + this.object + " with " + object);
            exception.printStackTrace();
        }
    }

    @Override
    public void setPropertyGroup(int n, String string) {
    }

    @Override
    public void setVisible(int n, boolean bl) {
        if (n < 0) {
            return;
        }
        this.properties.get((int)n).visible = bl;
    }

    private void build(Class clazz, int n, Collection<Property> collection) {
        if (clazz == null) {
            return;
        }
        this.build(clazz.getSuperclass(), n + 1, collection);
        String string = PropertySheet.groupNameForClass(clazz);
        try {
            HashMap<String, QtPropertyManager.Entry> hashMap = QtPropertyManager.findProperties(clazz);
            for (QtPropertyManager.Entry entry : hashMap.values()) {
                if (INVISIBLE_PROPERTIES.contains(entry.name)) continue;
                Property property = new Property();
                property.entry = entry;
                property.groupName = string;
                property.subclassLevel = n;
                collection.add(property);
            }
        }
        catch (QPropertyException qPropertyException) {
            qPropertyException.printStackTrace();
        }
    }

    private static String groupNameForClass(Class clazz) {
        String string = clazz.getName();
        if (string.indexOf(46) < 0) {
            return string;
        }
        int n = string.lastIndexOf(46);
        String string2 = string.substring(n + 1);
        String string3 = string.substring(0, n);
        if (string3.startsWith("com.trolltech.qt.")) {
            return string2;
        }
        return string2 + "; " + string3;
    }

    private Object invokationTarget(Property property) {
        if (property.isPropertyInvokationTarget()) {
            return property;
        }
        return this.object;
    }

    private void build() {
        TreeSet<Property> treeSet = new TreeSet<Property>();
        this.build(this.object.getClass(), 0, treeSet);
        this.properties = new ArrayList<Property>();
        this.properties.addAll(treeSet);
        for (Class<? extends Property> clazz : CUSTOM_PROPERTIES) {
            try {
                Method method = clazz.getMethod("initialize", List.class, QObject.class);
                method.invoke(null, this.properties, this.object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    static {
        INVISIBLE_PROPERTIES.add("backgroundRole");
        INVISIBLE_PROPERTIES.add("focusProxy");
        INVISIBLE_PROPERTIES.add("foregroundRole");
        INVISIBLE_PROPERTIES.add("hidden");
        INVISIBLE_PROPERTIES.add("inputContext");
        INVISIBLE_PROPERTIES.add("layout");
        INVISIBLE_PROPERTIES.add("windowFlags");
        INVISIBLE_PROPERTIES.add("windowIconText");
        INVISIBLE_PROPERTIES.add("windowModified");
        INVISIBLE_PROPERTIES.add("windowRole");
        INVISIBLE_PROPERTIES.add("windowState");
        INVISIBLE_PROPERTIES.add("parent");
        INVISIBLE_PROPERTIES.add("cornerWidget");
        INVISIBLE_PROPERTIES.add("menu");
        INVISIBLE_PROPERTIES.add("activeWindow");
        INVISIBLE_PROPERTIES.add("currentWidget");
        INVISIBLE_PROPERTIES.add("rootModelIndex");
        INVISIBLE_PROPERTIES.add("validator");
        INVISIBLE_PROPERTIES.add("actionGroup");
        INVISIBLE_PROPERTIES.add("buddy");
        PropertySheet.addCustomProperty(WidgetLayoutProperty.class);
        PropertySheet.addCustomProperty(LayoutProperty.class);
        PropertySheet.addCustomProperty(TabWidgetProperty.class);
        PropertySheet.addCustomProperty(BuddyProperty.class);
        PropertySheet.addCustomProperty(GridLayoutMarginPropertyRemover.class);
        PropertySheet.addCustomProperty(DockWidgetProperty.class);
        RESETTABLE_TYPES = new HashMap<Class, Object>();
        RESETTABLE_TYPES.put(Boolean.TYPE, false);
        RESETTABLE_TYPES.put(Byte.TYPE, (byte)0);
        RESETTABLE_TYPES.put(Character.TYPE, Character.valueOf('\u0000'));
        RESETTABLE_TYPES.put(Short.TYPE, (short)0);
        RESETTABLE_TYPES.put(Integer.TYPE, (short)0);
        RESETTABLE_TYPES.put(Long.TYPE, 0);
        RESETTABLE_TYPES.put(Float.TYPE, Float.valueOf(0.0f));
        RESETTABLE_TYPES.put(Double.TYPE, 0.0);
        RESETTABLE_TYPES.put(String.class, null);
        RESETTABLE_TYPES.put(QColor.class, null);
        RESETTABLE_TYPES.put(QFont.class, null);
        RESETTABLE_TYPES.put(QIcon.class, null);
        RESETTABLE_TYPES.put(QPalette.class, null);
        RESETTABLE_TYPES.put(QPixmap.class, null);
        RESETTABLE_TYPES.put(QPoint.class, null);
        RESETTABLE_TYPES.put(QRect.class, null);
        RESETTABLE_TYPES.put(QSize.class, null);
        RESETTABLE_TYPES.put(QSizePolicy.class, null);
        RESETTABLE_TYPES.put(QKeySequence.class, null);
        RESETTABLE_TYPES.put(QFrame.Shape.class, QFrame.Shape.StyledPanel);
        RESETTABLE_TYPES.put(QFrame.Shadow.class, QFrame.Shadow.Sunken);
        RESETTABLE_TYPES.put(Qt.ScrollBarPolicy.class, Qt.ScrollBarPolicy.ScrollBarAsNeeded);
        RESETTABLE_TYPES.put(Qt.WindowModality.class, Qt.WindowModality.NonModal);
        RESETTABLE_TYPES.put(Qt.FocusPolicy.class, Qt.FocusPolicy.NoFocus);
        RESETTABLE_TYPES.put(Qt.ContextMenuPolicy.class, Qt.ContextMenuPolicy.DefaultContextMenu);
        RESETTABLE_TYPES.put(Qt.LayoutDirection.class, Qt.LayoutDirection.LeftToRight);
        RESETTABLE_TYPES.put(Qt.TextElideMode.class, Qt.TextElideMode.ElideNone);
        RESETTABLE_TYPES.put(QTabWidget.TabPosition.class, QTabWidget.TabPosition.North);
        RESETTABLE_TYPES.put(QTabWidget.TabShape.class, QTabWidget.TabShape.Rounded);
        RESETTABLE_TYPES.put(QLineEdit.EchoMode.class, QLineEdit.EchoMode.Normal);
        RESETTABLE_TYPES.put(QComboBox.InsertPolicy.class, QComboBox.InsertPolicy.InsertAtBottom);
        RESETTABLE_TYPES.put(QComboBox.SizeAdjustPolicy.class, QComboBox.SizeAdjustPolicy.AdjustToContentsOnFirstShow);
        RESETTABLE_TYPES.put(QFontDatabase.WritingSystem.class, QFontDatabase.WritingSystem.Any);
        RESETTABLE_TYPES.put(QDialogButtonBox.StandardButtons.class, QDialogButtonBox.StandardButton.NoButton);
        propertySheets = new HashMap();
    }
}

