/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qt;

import com.trolltech.qt.QtInfo;
import com.trolltech.qt.gui.QApplication;
import com.trolltech.qt.gui.QMessageBox;
import com.trolltech.qt.gui.QPaintDeviceInterface;
import com.trolltech.qt.gui.QPainter;
import com.trolltech.qt.gui.QPixmap;
import com.trolltech.qt.gui.QWidget;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class QtJambiGuiInternal {
    private static HashMap<QWidget, List<QPainter>> painters = new HashMap();

    public static void aboutQtJambi() {
        QMessageBox qMessageBox = new QMessageBox(QApplication.activeWindow());
        qMessageBox.setWindowTitle("About Qt Jambi");
        qMessageBox.setText("<h3>About Qt Jambi</h3><p>Qt Jambi is a Java toolkit based on Qt, a C++ toolkit for cross-platform application development.</p><p>This program uses Qt version " + QtInfo.versionString() + ".</p>" + "<p>Qt Jambi provides single-source " + "portability across MS&nbsp;Windows, Mac&nbsp;OS&nbsp;X, " + "Linux, and all major commercial Unix variants" + "<p>Qt Jambi is a Trolltech product. See " + "<a href=\"http://www.trolltech.com/jambi\">http://www.trolltech.com/jambi</a> for more information.</p>");
        qMessageBox.setIconPixmap(new QPixmap("classpath:com/trolltech/images/qt-logo.png"));
        qMessageBox.exec();
    }

    public static boolean beginPaint(QWidget qWidget, QPainter qPainter) {
        List<QPainter> list = painters.get(qWidget);
        if (list == null) {
            list = new LinkedList<QPainter>();
            painters.put(qWidget, list);
        }
        if (list.contains(qPainter)) {
            throw new RuntimeException("Painter opened twice on the same widget");
        }
        if (qPainter.isActive()) {
            throw new RuntimeException("Painter already active");
        }
        list.add(qPainter);
        return qPainter.begin((QPaintDeviceInterface)qWidget);
    }

    private static void endPaint(QWidget qWidget) {
        List<QPainter> list = painters.get(qWidget);
        if (list != null) {
            for (QPainter qPainter : list) {
                qPainter.dispose();
            }
            painters.remove(qWidget);
        }
    }
}

