/****************************************************************************
**
** Copyright (C) 1992-2009 Nokia. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.


**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QTJAMBIVARIANT_H
#define QTJAMBIVARIANT_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt Jambi API.
// This header file may change from version to version without notice,
// or even be removed.
//
// We mean it.
//
//

#include <QVariant>
#include "qtjambi_core.h"

class QtJambiVariant: private QVariant
{

 public:
    static const QVariant::Handler *getLastHandler()
        {
            return lastHandler;
        }

    static int registerHandler()
        {
            lastHandler = QVariant::handler;
            setHandler(&handler);
            return 1;
        }

    static int unregisterHandler()
        {
            setHandler(lastHandler);
            lastHandler = 0;
            return 1;
        }

 private:
    static const QVariant::Handler handler;

    static void setHandler(const Handler *handler) {
        QVariant::handler = handler;
    }

    static const Handler *getHandler() {
        return QVariant::handler;
    }

    static const QVariant::Handler *lastHandler;

};

#endif // QTJAMBIVARIANT_H
