/****************************************************************************
**
** Copyright (C) 1992-2009 Nokia. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.


**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "qtjambifunctiontable.h"
#include "qtjambi_cache.h"

#include <memory.h>

QtJambiFunctionTable::QtJambiFunctionTable(const QString &className,
                                         int size)
    : m_class_name(className),
      m_method_count(size),
      m_reference_count(1)
{
    m_method_ids = new jmethodID[size];

    for (int i=0; i<size; ++i)
        m_method_ids[i] = 0;
}

QtJambiFunctionTable::~QtJambiFunctionTable()
{
    removeFunctionTable(this);
    delete [] m_method_ids;
}

void QtJambiFunctionTable::ref()
{
    ++m_reference_count;
    Q_ASSERT(m_reference_count > 0);
}

void QtJambiFunctionTable::deref()
{
    --m_reference_count;
    Q_ASSERT(m_reference_count >= 0);
}
