/****************************************************************************
**
** Copyright (C) 1992-2009 Nokia. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.


**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QTJAMBI_UTILS_H
#define QTJAMBI_UTILS_H

struct ClassData {
    jclass *cl;
    const char *name;
};

struct MethodData {
    jclass *cl;
    jmethodID *id;
    const char *name;
    const char *signature;
};

struct FieldData {
    jclass *cl;
    jfieldID *id;
    const char *name;
    const char *signature;
};

QTJAMBI_EXPORT bool qtjambi_resolve_classes(JNIEnv *env, ClassData *data);
QTJAMBI_EXPORT void qtjambi_resolve_fields(JNIEnv *env, FieldData *data);
QTJAMBI_EXPORT void qtjambi_resolve_static_fields(JNIEnv *env, FieldData *data);
QTJAMBI_EXPORT void qtjambi_resolve_methods(JNIEnv *env, MethodData *data);
QTJAMBI_EXPORT void qtjambi_resolve_static_methods(JNIEnv *env, MethodData *data);

#endif // QTJAMBI_UTILS_H
