/****************************************************************************
**
** Copyright (C) 1992-2009 Nokia. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.


**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QDYNAMICMETAOBJECT_H
#define QDYNAMICMETAOBJECT_H

#include "qtjambi_global.h"

#include <QtCore/QString>
#include <QtCore/QByteArray>
#include <QtCore/QMetaObject>

class QtDynamicMetaObjectPrivate;

class QTJAMBI_EXPORT QtDynamicMetaObject: public QMetaObject
{
public:
    QtDynamicMetaObject(JNIEnv *jni_env, jclass java_class, const QMetaObject *original_meta_object);
    ~QtDynamicMetaObject();

    int invokeSignalOrSlot(JNIEnv *env, jobject object, int _id, void **_a) const;
    int readProperty(JNIEnv *env, jobject object, int _id, void **_a) const;
    int writeProperty(JNIEnv *env, jobject object, int _id, void **_a) const;
    int resetProperty(JNIEnv *env, jobject object, int _id, void **_a) const;
    int queryPropertyDesignable(JNIEnv *env, jobject object, int _id, void **_a) const;

    int originalSignalOrSlotSignature(JNIEnv *env, int _id, QString *signature) const;

private:
    QtDynamicMetaObjectPrivate *d_ptr;
    Q_DECLARE_PRIVATE(QtDynamicMetaObject);
};

#endif // QDYNAMICMETAOBJECT_H
