/****************************************************************************
**
** Copyright (C) 1992-2009 Nokia. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.


**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "gameaction.h"
#include "gamescene.h"
#include "abstractgameobject.h"

bool GameAction::perform(GameScene *scene)
{
    if (subjects.size() > 0) {
        AbstractGameObject **objects = this->objects.size() > 0 ? this->objects.data() : 0;
        for (int i=0; i<subjects.size(); ++i) {
            subjects.at(i)->perform(type(), objects, this->objects.size());
        }
    } else {
        scene->lookAround();
    }

    return true;
}
