/****************************************************************************
**
** Copyright (C) 1992-2009 Nokia. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.


**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "reporthandler.h"
#include "typesystem.h"

int ReportHandler::m_warning_count = 0;
int ReportHandler::m_suppressed_count = 0;
QString ReportHandler::m_context;
ReportHandler::DebugLevel ReportHandler::m_debug_level = NoDebug;
QSet<QString> ReportHandler::m_reported_warnings;


void ReportHandler::warning(const QString &text)
{
    QString warningText = QString("WARNING(%1) :: %2").arg(m_context).arg(text);

    TypeDatabase *db = TypeDatabase::instance();
    if (db && db->isSuppressedWarning(warningText)) {
        ++m_suppressed_count;
    } else if (!m_reported_warnings.contains(warningText)) {
        qDebug(qPrintable(warningText));
        ++m_warning_count;

        m_reported_warnings.insert(warningText);
    }
}

void ReportHandler::debug(DebugLevel level, const QString &text)
{
    if (m_debug_level == NoDebug)
        return;

    if (level <= m_debug_level)
        qDebug(" - DEBUG(%s) :: %s", qPrintable(m_context), qPrintable(text));
}
