/****************************************************************************
**
** Copyright (C) 1992-2009 Nokia. All rights reserved.
** Copyright (C) 2002-2005 Roberto Raggi <roberto@kdevelop.org>
**
** This file is part of Qt Jambi.
**
** ** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.


**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/


#include "compiler_utils.h"
#include "type_compiler.h"
#include "name_compiler.h"
#include "declarator_compiler.h"
#include "ast.h"
#include "binder.h"

TypeInfo CompilerUtils::typeDescription(TypeSpecifierAST *type_specifier, DeclaratorAST *declarator, Binder *binder)
{
  TypeCompiler type_cc (binder);
  DeclaratorCompiler decl_cc (binder);

  type_cc.run (type_specifier);
  decl_cc.run (declarator);

  TypeInfo typeInfo;
  typeInfo.setQualifiedName (type_cc.qualifiedName ());
  typeInfo.setConstant (type_cc.isConstant ());
  typeInfo.setVolatile (type_cc.isVolatile ());
  typeInfo.setReference (decl_cc.isReference ());
  typeInfo.setIndirections (decl_cc.indirection ());
  typeInfo.setArrayElements (decl_cc.arrayElements ());

  return typeInfo;
}

// kate: space-indent on; indent-width 2; replace-tabs on;
