/****************************************************************************
**
** Copyright (C) 1992-2009 Nokia. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.


**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef JUMPTABLE_H
#define JUMPTABLE_H

#include "generator.h"
#include "abstractmetalang.h"
#include "prigenerator.h"


typedef QHash<QString, AbstractMetaFunctionList> SignatureTable;
typedef QHash<QString, SignatureTable> PackageJumpTable;


class JumpTablePreprocessor : public Generator
{
    Q_OBJECT
public:
    void generate();

    static QString signature(const AbstractMetaFunction *func);

    inline const PackageJumpTable *table() const { return &m_table; }

    bool usesJumpTable(AbstractMetaFunction *func);

private:
    void process(AbstractMetaClass *cls);
    void process(AbstractMetaFunction *cls, SignatureTable *sigList);
    PackageJumpTable m_table;
};


class JumpTableGenerator : public Generator
{
    Q_OBJECT
public:
    JumpTableGenerator(JumpTablePreprocessor *pp, PriGenerator *pri);

    void generate();
    void generatePackage(const QString &packageName, const SignatureTable &table);
    void generateNativeTable(const QString &packageName, const SignatureTable &table);
    void generateJavaTable(const QString &packageName, const SignatureTable &table);

    static bool isJumpTableActive();

private:
    JumpTablePreprocessor *m_preprocessor;
    PriGenerator *m_prigenerator;

    static bool active;
};

#endif
