/****************************************************************************
**
** Copyright (C) 1992-2009 Nokia. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.


**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef DOCPARSER_H
#define DOCPARSER_H

#include <QtCore/QString>


class AbstractMetaClass;
class AbstractMetaFunction;
class AbstractMetaEnum;
class AbstractMetaEnumValue;
class QDomDocument;

class DocParser
{
public:
    DocParser(const QString &docFile);
    ~DocParser();

    QString documentation(const AbstractMetaClass *meta_class) const;
    QString documentation(const AbstractMetaEnum *meta_enum) const;
    QString documentation(const AbstractMetaEnumValue *meta_enum) const;
    QString documentationForFunction(const QString &signature) const;
    QString documentationForSignal(const QString &signature) const;

private:
    QString documentationForFunction(const QString &signature, const QString &tag) const;
    void build();

    QString m_doc_file;
    QDomDocument *m_dom;
};

#endif // DOCPARSER_H
