/****************************************************************************
**
** Copyright (C) 1992-2009 Nokia. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.


**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef CPPGENERATOR_H
#define CPPGENERATOR_H

#include "generator.h"
#include "metajava.h"
#include "prigenerator.h"

class CppGenerator : public Generator
{
    Q_OBJECT

public:
    static inline QString subDirectoryForPackage(const QString &package) {
        return QLatin1String("cpp/") + QString(package).replace(".", "_");
    }

    virtual QString subDirectoryForClass(const AbstractMetaClass *cls) const
    {
        return subDirectoryForPackage(cls->package()) + "/";
    }

    static QString fixNormalizedSignatureForQt(const QString &signature);
    static void writeTypeInfo(QTextStream &s, const AbstractMetaType *type, Option option = NoOption);
    static void writeFunctionSignature(QTextStream &s, const AbstractMetaFunction *java_function,
                                const AbstractMetaClass *implementor = 0,
                                const QString &name_prefix = QString(),
                                Option option = NoOption,
                                const QString &classname_prefix = QString(),
                                const QStringList &extra_arguments = QStringList(),
                                int numArguments = -1);
    static void writeFunctionArguments(QTextStream &s, const AbstractMetaArgumentList &arguments,
                                Option option = NoOption,
                                int numArguments = -1);

    static inline AbstractMetaFunctionList signalFunctions(const AbstractMetaClass *cls);

    QString signalWrapperPrefix() const { return "__qt_signalwrapper_"; }

    bool shouldGenerate(const AbstractMetaClass *java_class) const {
        return (!java_class->isNamespace() || java_class->functionsInTargetLang().size() > 0) && !java_class->isInterface()
            && !java_class->typeEntry()->isVariant()
            && (java_class->typeEntry()->codeGeneration() & TypeEntry::GenerateCpp)
            && !(java_class->attributes() & AbstractMetaAttributes::Fake);
    }

    static QString shellClassName(const AbstractMetaClass *java_class) {
        return java_class->generateShellClass()
               ? "QtJambiShell_" + java_class->name()
               : java_class->qualifiedCppName();
    }

 protected:
    PriGenerator *priGenerator;

};

inline AbstractMetaFunctionList CppGenerator::signalFunctions(const AbstractMetaClass *cls) {
    return cls->cppSignalFunctions();
}


#endif // CPPGENERATOR_H
