/****************************************************************************
**
** Copyright (C) 1992-2009 Nokia. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.


**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

package com.trolltech.qt;

/**
 * The super interface of all interface types in Qt Jambi.
 */
public interface QtJambiInterface {

    /**
     * Function that returns a unique identifier for a Qt Jambi object.
     * @return A value which uniquely identifies the native resources held by an object in their life time.
     */
    public long nativeId();

    public void disableGarbageCollection();

    public void setJavaOwnership();
    public void reenableGarbageCollection();
    public QNativePointer nativePointer();
}
